/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.player.controller;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.EntityPlayerSP;
import net.minecraft.core.InventoryAction;
import net.minecraft.core.block.Block;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.enums.EnumArt;
import net.minecraft.core.enums.EnumBlockSoundEffectType;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.tag.ItemTags;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;

public abstract class PlayerController {
    public static boolean clickMining = true;
    protected float currentDamage;
    protected float previousDamage;
    protected int soundDelay;
    protected int blockHitDelay;
    protected int swingCooldown = 0;
    protected Integer miningX;
    protected Integer miningY;
    protected Integer miningZ;
    protected final Minecraft mc;
    public boolean field_1064_b = false;

    public PlayerController(Minecraft minecraft) {
        this.mc = minecraft;
    }

    public void clickBlock(int x, int y, int z, Side side, boolean repeat) {
        float mineStrength;
        if (!this.mc.thePlayer.getGamemode().doBlockBreakingAnim) {
            this.swingItem(true);
            ItemStack heldItem = this.mc.thePlayer.getCurrentEquippedItem();
            if (heldItem != null && heldItem.getItem().hasTag(ItemTags.preventCreativeMining)) {
                return;
            }
            this.destroyBlock(x, y, z, side, this.mc.thePlayer);
            this.sendStartDigPacket(x, y, z, side);
            return;
        }
        Block mineBlock = Block.getBlock(this.mc.theWorld.getBlockId(x, y, z));
        if (mineBlock != null && (mineStrength = mineBlock.blockStrength(this.mc.thePlayer)) < 1.0f && !repeat) {
            this.sendStartDigPacket(x, y, z, side);
            this.hitBlock(x, y, z, side);
        }
    }

    public void mine(int x, int y, int z, Side side) {
        if (!this.mc.thePlayer.getGamemode().doBlockBreakingAnim) {
            return;
        }
        this.swingItem(false);
        if (this.blockHitDelay > 0) {
            --this.blockHitDelay;
            return;
        }
        Block mineBlock = Block.getBlock(this.mc.theWorld.getBlockId(x, y, z));
        if (mineBlock != null) {
            this.syncCurrentPlayItem();
            float mineStrength = mineBlock.blockStrength(this.mc.thePlayer);
            if (mineStrength >= 1.0f) {
                this.setMineBlock(x, y, z);
                this.destroyBlock(x, y, z, side, this.mc.thePlayer);
                this.sendStartDigPacket(x, y, z, side);
                this.currentDamage = 0.0f;
                this.previousDamage = 0.0f;
                this.soundDelay = 0;
                this.blockHitDelay = 1;
            } else {
                if (!this.isMiningBlock(x, y, z)) {
                    this.sendStartDigPacket(x, y, z, side);
                    this.currentDamage = 0.0f;
                    this.previousDamage = 0.0f;
                    this.setMineBlock(x, y, z);
                }
                this.mc.effectRenderer.addBlockHitEffects(x, y, z, side);
                this.playDigSound(mineBlock, x, y, z);
                this.currentDamage += mineStrength;
                if (this.currentDamage > 1.0f) {
                    ItemStack stack = this.mc.thePlayer.inventory.getCurrentItem();
                    this.blockHitDelay = stack != null && stack.getItem() != null ? stack.getItem().getBlockHitDelay() : 5;
                    this.destroyBlock(x, y, z, side, this.mc.thePlayer);
                    this.sendDestroyBlockPacket(x, y, z, side);
                    this.currentDamage = 0.0f;
                    this.previousDamage = 0.0f;
                    this.soundDelay = 0;
                }
            }
        } else {
            this.currentDamage = 0.0f;
            this.previousDamage = 0.0f;
            this.soundDelay = 0;
        }
    }

    public boolean swingItem(boolean force) {
        if (this.swingCooldown == 0 || force) {
            this.mc.thePlayer.swingItem();
            this.swingCooldown = 5;
            return true;
        }
        return false;
    }

    public boolean destroyBlock(int x, int y, int z, Side side, EntityPlayer player) {
        this.setMineBlock(null, null, null);
        World world = this.mc.theWorld;
        Block block = Block.getBlock(world.getBlockId(x, y, z));
        if (block == null) {
            return false;
        }
        Item heldItem = null;
        ItemStack heldItemStack = player.getCurrentEquippedItem();
        if (heldItemStack != null) {
            heldItem = heldItemStack.getItem();
        }
        world.playSoundEffect(2001, x, y, z, block.id);
        int meta = world.getBlockMetadata(x, y, z);
        boolean removed = world.setBlockWithNotify(x, y, z, 0);
        if (removed) {
            block.onBlockDestroyedByPlayer(world, x, y, z, meta, player, heldItem);
        }
        return removed;
    }

    public void dontMine(boolean leftClickDown) {
        this.currentDamage = 0.0f;
        this.previousDamage = 0.0f;
        this.soundDelay = 0;
        if (this.blockHitDelay > 0) {
            --this.blockHitDelay;
        }
        if (!leftClickDown && clickMining) {
            this.blockHitDelay = 0;
        }
    }

    protected void hitBlock(int x, int y, int z, Side side) {
        this.mc.theWorld.onBlockHit(this.mc.thePlayer, x, y, z, side);
        Block block = Block.getBlock(this.mc.theWorld.getBlockId(x, y, z));
        if (block != null) {
            block.onBlockClicked(this.mc.theWorld, x, y, z, this.mc.thePlayer);
        }
    }

    private boolean isMiningBlock(int x, int y, int z) {
        return this.miningX != null && this.miningX == x && this.miningY != null && this.miningY == y && this.miningZ != null && this.miningZ == z;
    }

    private void setMineBlock(Integer x, Integer y, Integer z) {
        this.miningX = x;
        this.miningY = y;
        this.miningZ = z;
    }

    public void setPartialTime(float f) {
        if (this.currentDamage <= 0.0f) {
            this.mc.ingameGUI.damageGuiPartialTime = 0.0f;
            this.mc.renderGlobal.damagePartialTime = 0.0f;
        } else {
            float f1;
            this.mc.ingameGUI.damageGuiPartialTime = f1 = this.previousDamage + (this.currentDamage - this.previousDamage) * f;
            this.mc.renderGlobal.damagePartialTime = f1;
        }
    }

    public float getBlockReachDistance() {
        return this.mc.thePlayer.getGamemode().blockReachDistance;
    }

    public float getEntityReachDistance() {
        return this.mc.thePlayer.getGamemode().entityReachDistance;
    }

    public boolean sendUseItem(EntityPlayer player, World world, ItemStack stack) {
        int prevStacksize = stack.stackSize;
        ItemStack newItemStack = stack.useItemRightClick(world, player);
        if (newItemStack != stack || newItemStack.stackSize != prevStacksize) {
            player.inventory.mainInventory[player.inventory.currentItem] = newItemStack;
            if (newItemStack == null || newItemStack.stackSize <= 0) {
                player.inventory.mainInventory[player.inventory.currentItem] = null;
            }
            return true;
        }
        return false;
    }

    public void flipPlayer(EntityPlayer entityplayer) {
        entityplayer.yRot = -180.0f;
    }

    public void updateController() {
        if (this.swingCooldown > 0) {
            --this.swingCooldown;
        }
        this.syncCurrentPlayItem();
        this.previousDamage = this.currentDamage;
        this.mc.sndManager.playRandomMusicIfReady();
    }

    public boolean shouldDrawHUD() {
        return true;
    }

    public void func_6473_b(EntityPlayer entityplayer) {
    }

    public boolean activateBlockOrUseItem(EntityPlayer entityplayer, World world, ItemStack itemstack, int blockX, int blockY, int blockZ, Side side, double xPlaced, double yPlaced) {
        int i1 = world.getBlockId(blockX, blockY, blockZ);
        if ((!entityplayer.isSneaking() || entityplayer.inventory.getCurrentItem() == null) && i1 > 0 && Block.blocksList[i1].blockActivated(world, blockX, blockY, blockZ, entityplayer)) {
            return true;
        }
        if (itemstack == null) {
            return false;
        }
        return itemstack.useItem(entityplayer, world, blockX, blockY, blockZ, side, xPlaced, yPlaced);
    }

    public EntityPlayer createPlayer(World world) {
        return new EntityPlayerSP(this.mc, world, this.mc.session, world.dimension.id);
    }

    public void interactWithEntity(EntityPlayer entityplayer, Entity entity) {
        entityplayer.useCurrentItemOnEntity(entity);
    }

    public void attackEntity(EntityPlayer entityplayer, Entity entity) {
        entityplayer.attackTargetEntityWithCurrentItem(entity);
    }

    public ItemStack doInventoryAction(int windowId, InventoryAction action, int[] args, EntityPlayer entityplayer) {
        return entityplayer.craftingInventory.clickInventorySlot(action, args, entityplayer);
    }

    public void func_20086_a(int i, EntityPlayer entityplayer) {
        entityplayer.craftingInventory.onCraftGuiClosed(entityplayer);
        entityplayer.craftingInventory = entityplayer.inventorySlots;
    }

    public void playDigSound(Block block, int x, int y, int z) {
        if (this.soundDelay <= 0) {
            this.mc.theWorld.playBlockSoundEffect((float)x + 0.5f, (float)y + 0.5f, (float)z + 0.5f, block, EnumBlockSoundEffectType.DIG);
            this.soundDelay = 3;
        } else {
            --this.soundDelay;
        }
    }

    public boolean isBlockFullyMined() {
        return this.currentDamage >= 1.0f;
    }

    protected void syncCurrentPlayItem() {
    }

    public void sendStartDigPacket(int x, int y, int z, Side side) {
    }

    public void sendDestroyBlockPacket(int x, int y, int z, Side side) {
    }

    public void changeWorld(World world) {
    }

    public void setPaintingType(EnumArt art) {
        this.mc.thePlayer.setSelectedArt(art);
    }
}

