/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render;

import net.minecraft.client.Minecraft;
import net.minecraft.client.render.Tessellator;
import net.minecraft.core.MinecraftError;
import net.minecraft.core.world.IProgressUpdate;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL11;

public class LoadingScreenRenderer
implements IProgressUpdate {
    private String text = "";
    private Minecraft mc;
    private String title = "";
    private long startTime = System.currentTimeMillis();
    private boolean field_1005_e = false;

    public LoadingScreenRenderer(Minecraft minecraft) {
        this.mc = minecraft;
    }

    public void printText(String s) {
        this.field_1005_e = false;
        this.func_597_c(s);
    }

    @Override
    public void func_594_b(String s) {
        this.field_1005_e = true;
        this.func_597_c(this.title);
    }

    public void func_597_c(String s) {
        if (!this.mc.running) {
            if (!this.field_1005_e) {
                throw new MinecraftError();
            }
        } else {
            this.title = s;
            GL11.glClear((int)256);
            GL11.glMatrixMode((int)5889);
            GL11.glLoadIdentity();
            GL11.glOrtho((double)0.0, (double)this.mc.resolution.scaledWidthExact, (double)this.mc.resolution.scaledHeightExact, (double)0.0, (double)100.0, (double)300.0);
            GL11.glMatrixMode((int)5888);
            GL11.glLoadIdentity();
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-200.0f);
        }
    }

    @Override
    public void displayLoadingString(String string) {
        if (!this.mc.running) {
            if (!this.field_1005_e) {
                throw new MinecraftError();
            }
        } else {
            this.startTime = 0L;
            this.text = string;
            this.setLoadingProgress(-1);
            this.startTime = 0L;
        }
    }

    @Override
    public void setLoadingProgress(int progress) {
        if (!this.mc.running && !this.field_1005_e) {
            throw new MinecraftError();
        }
        long time = System.currentTimeMillis();
        if (time - this.startTime < 20L) {
            return;
        }
        this.startTime = time;
        boolean isNether = this.title.equals("Entering the Nether");
        this.mc.render.beginRenderGame(1.0f);
        GL11.glEnable((int)3008);
        int width = this.mc.resolution.scaledWidth;
        int height = this.mc.resolution.scaledHeight;
        GL11.glDisable((int)2929);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)this.mc.resolution.scaledWidthExact, (double)this.mc.resolution.scaledHeightExact, (double)0.0, (double)100.0, (double)300.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-200.0f);
        Tessellator tessellator = Tessellator.instance;
        int bgTexture = isNether ? this.mc.renderEngine.getTexture("/gui/background-loading-nether.png") : this.mc.renderEngine.getTexture("/gui/background.png");
        GL11.glBindTexture((int)3553, (int)bgTexture);
        float f = 32.0f;
        tessellator.startDrawingQuads();
        tessellator.setColorOpaque_I(0x404040);
        tessellator.addVertexWithUV(0.0, height, 0.0, 0.0, (float)height / f);
        tessellator.addVertexWithUV(width, height, 0.0, (float)width / f, (float)height / f);
        tessellator.addVertexWithUV(width, 0.0, 0.0, (float)width / f, 0.0);
        tessellator.addVertexWithUV(0.0, 0.0, 0.0, 0.0, 0.0);
        tessellator.draw();
        if (progress >= 0) {
            int byte0 = 100;
            int byte1 = 2;
            int j1 = width / 2 - byte0 / 2;
            int k1 = height / 2 + 16;
            GL11.glDisable((int)3553);
            tessellator.startDrawingQuads();
            tessellator.setColorOpaque_I(0x808080);
            tessellator.addVertex(j1, k1, 0.0);
            tessellator.addVertex(j1, k1 + byte1, 0.0);
            tessellator.addVertex(j1 + byte0, k1 + byte1, 0.0);
            tessellator.addVertex(j1 + byte0, k1, 0.0);
            tessellator.setColorOpaque_I(0x80FF80);
            tessellator.addVertex(j1, k1, 0.0);
            tessellator.addVertex(j1, k1 + byte1, 0.0);
            tessellator.addVertex(j1 + progress, k1 + byte1, 0.0);
            tessellator.addVertex(j1 + progress, k1, 0.0);
            tessellator.draw();
            GL11.glEnable((int)3553);
        }
        this.mc.fontRenderer.drawStringWithShadow(this.title, (width - this.mc.fontRenderer.getStringWidth(this.title)) / 2, height / 2 - 4 - 16, 0xFFFFFF);
        this.mc.fontRenderer.drawStringWithShadow(this.text, (width - this.mc.fontRenderer.getStringWidth(this.text)) / 2, height / 2 - 4 + 8, 0xFFFFFF);
        this.mc.render.endRenderGame(1.0f);
        Display.update();
        try {
            Thread.yield();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

