/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.minecraft.client.GLAllocation;
import net.minecraft.client.Minecraft;
import net.minecraft.client.option.GameSettings;
import net.minecraft.client.option.enums.MipmapType;
import net.minecraft.client.render.DownloadedTexture;
import net.minecraft.client.render.FontRenderer;
import net.minecraft.client.render.ImageParser;
import net.minecraft.client.render.TextureFX;
import net.minecraft.client.render.colorizer.ColorProperties;
import net.minecraft.client.render.dynamictexture.DynamicTexture;
import net.minecraft.client.render.dynamictexture.DynamicTextureCalendar;
import net.minecraft.client.render.dynamictexture.DynamicTextureClock;
import net.minecraft.client.render.dynamictexture.DynamicTextureCompass;
import net.minecraft.client.render.dynamictexture.DynamicTextureCustom;
import net.minecraft.client.render.dynamictexture.DynamicTextureFire;
import net.minecraft.client.render.dynamictexture.DynamicTextureFireflyJar;
import net.minecraft.client.render.dynamictexture.DynamicTextureLavaFlowing;
import net.minecraft.client.render.dynamictexture.DynamicTextureLavaStill;
import net.minecraft.client.render.dynamictexture.DynamicTexturePortal;
import net.minecraft.client.render.dynamictexture.DynamicTextureTrommel;
import net.minecraft.client.render.dynamictexture.DynamicTextureWaterFlow;
import net.minecraft.client.render.dynamictexture.DynamicTextureWaterStill;
import net.minecraft.client.render.texturepack.TexturePackBase;
import net.minecraft.client.render.texturepack.TexturePackList;
import net.minecraft.core.Global;
import net.minecraft.core.block.Block;
import net.minecraft.core.util.helper.Buffer;
import net.minecraft.core.util.helper.Colors;
import net.minecraft.core.util.helper.Textures;
import org.lwjgl.opengl.GL11;

public class RenderEngine {
    public static boolean debugMipmap = false;
    private static boolean fixArtifacts = true;
    public final Minecraft minecraft;
    private Map<String, Integer> textureMap = new HashMap<String, Integer>();
    private Map<String, int[]> intArrayTextureData = new HashMap<String, int[]>();
    private Map<Integer, BufferedImage> textureNameToImageMap = new HashMap<Integer, BufferedImage>();
    private Map<String, DownloadedTexture> downloadedTextures = new HashMap<String, DownloadedTexture>();
    private List<DynamicTexture> dynamicTextures = new ArrayList<DynamicTexture>();
    private GameSettings gameSettings;
    public TexturePackList texturePacks;
    private boolean clampTexture;
    private boolean blurTexture;

    public RenderEngine(Minecraft minecraft, TexturePackList texturePacks, GameSettings gameSettings) {
        this.minecraft = minecraft;
        this.clampTexture = false;
        this.blurTexture = false;
        this.texturePacks = texturePacks;
        this.gameSettings = gameSettings;
    }

    public void initDynamicTextures() {
        System.out.println("Initializing Dynamic Textures...");
        this.dynamicTextures.clear();
        GL11.glBindTexture((int)3553, (int)this.getTexture("/terrain.png"));
        int terrainResolution = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4096) / RenderEngine.atlasWidth();
        GL11.glBindTexture((int)3553, (int)this.getTexture("/gui/items.png"));
        int itemsResolution = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4096) / RenderEngine.atlasWidth();
        System.out.println("Resolution: Terrain: " + terrainResolution + " Items: " + itemsResolution);
        TextureFX.tileWidthTerrain = terrainResolution;
        TextureFX.tileWidthItems = itemsResolution;
        if ((Integer)this.minecraft.gameSettings.animations.value != 0) {
            boolean useCustomAnimations;
            boolean bl = useCustomAnimations = (Integer)this.minecraft.gameSettings.animations.value == 2;
            if (useCustomAnimations && this.texturePacks.selectedTexturePack.hasFile("/custom_water_still.png")) {
                System.out.println("Using Custom Still Water Animation");
                this.dynamicTextures.add(new DynamicTextureCustom(this.minecraft, "/terrain.png", "/custom_water_still.png", Block.texCoordToIndex(13, 12), terrainResolution, 1));
            } else {
                System.out.println("Using Generated Still Water Animation");
                this.dynamicTextures.add(new DynamicTextureWaterStill(terrainResolution));
            }
            if (useCustomAnimations && this.texturePacks.selectedTexturePack.hasFile("/custom_water_flowing.png")) {
                System.out.println("Using Custom Flowing Water Animation");
                this.dynamicTextures.add(new DynamicTextureCustom(this.minecraft, "/terrain.png", "/custom_water_flowing.png", Block.texCoordToIndex(14, 12), terrainResolution, 2));
            } else {
                System.out.println("Using Generated Flowing Water Animation");
                this.dynamicTextures.add(new DynamicTextureWaterFlow(terrainResolution));
            }
            if (useCustomAnimations && this.texturePacks.selectedTexturePack.hasFile("/custom_lava_still.png")) {
                System.out.println("Using Custom Still Lava Animation");
                this.dynamicTextures.add(new DynamicTextureCustom(this.minecraft, "/terrain.png", "/custom_lava_still.png", Block.texCoordToIndex(13, 14), terrainResolution, 1));
            } else {
                System.out.println("Using Generated Still Lava Animation");
                this.dynamicTextures.add(new DynamicTextureLavaStill(terrainResolution));
            }
            if (useCustomAnimations && this.texturePacks.selectedTexturePack.hasFile("/custom_lava_flowing.png")) {
                System.out.println("Using Custom Flowing Lava Animation");
                this.dynamicTextures.add(new DynamicTextureCustom(this.minecraft, "/terrain.png", "/custom_lava_flowing.png", Block.texCoordToIndex(14, 14), terrainResolution, 2));
            } else {
                System.out.println("Using Generated Flowing Lava Animation");
                this.dynamicTextures.add(new DynamicTextureLavaFlowing(terrainResolution));
            }
            if (useCustomAnimations && this.texturePacks.selectedTexturePack.hasFile("/custom_portal.png")) {
                System.out.println("Using Custom Portal Animation");
                this.dynamicTextures.add(new DynamicTextureCustom(this.minecraft, "/terrain.png", "/custom_portal.png", Block.texCoordToIndex(14, 0), terrainResolution, 1));
            } else {
                System.out.println("Using Generated Portal Animation");
                this.dynamicTextures.add(new DynamicTexturePortal(terrainResolution, false));
            }
            this.dynamicTextures.add(new DynamicTextureTrommel(this.minecraft, Block.texCoordToIndex(1, 7), terrainResolution, false));
            this.dynamicTextures.add(new DynamicTextureTrommel(this.minecraft, Block.texCoordToIndex(2, 7), terrainResolution, true));
            this.dynamicTextures.add(new DynamicTextureFire(terrainResolution));
        } else {
            this.updateDynamicTexture(new DynamicTextureTrommel(this.minecraft, Block.texCoordToIndex(1, 7), terrainResolution, false));
            this.updateDynamicTexture(new DynamicTextureTrommel(this.minecraft, Block.texCoordToIndex(2, 7), terrainResolution, true));
        }
        this.dynamicTextures.add(new DynamicTextureClock(this.minecraft, itemsResolution));
        this.dynamicTextures.add(new DynamicTextureCalendar(this.minecraft, itemsResolution));
        this.dynamicTextures.add(new DynamicTextureCompass(this.minecraft, itemsResolution));
        this.dynamicTextures.add(new DynamicTextureFireflyJar(this.minecraft, Block.texCoordToIndex(13, 10), terrainResolution));
        this.dynamicTextures.add(new DynamicTextureFireflyJar(this.minecraft, Block.texCoordToIndex(14, 10), terrainResolution));
        this.dynamicTextures.add(new DynamicTextureFireflyJar(this.minecraft, Block.texCoordToIndex(13, 11), terrainResolution));
        this.dynamicTextures.add(new DynamicTextureFireflyJar(this.minecraft, Block.texCoordToIndex(14, 11), terrainResolution));
    }

    public int[] getTextureImageData(String name) {
        int[] imageData = this.intArrayTextureData.get(name);
        if (imageData != null) {
            return imageData;
        }
        imageData = Textures.getImageData(Textures.readImage(this.texturePacks.selectedTexturePack.getResourceAsStream(name)));
        if (imageData == null) {
            imageData = Textures.getImageData(Textures.missingTexture);
        }
        this.intArrayTextureData.put(name, imageData);
        return imageData;
    }

    public boolean enableMipmapForTexture(String name) {
        return name.equals("/terrain.png") || name.equals("/gui/items.png");
    }

    public int getTexture(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        TexturePackBase texturePack = this.texturePacks.selectedTexturePack;
        Integer id = this.textureMap.get(name);
        if (id != null) {
            return id;
        }
        try {
            id = GLAllocation.generateTexture();
            if (name.startsWith("##")) {
                this.setupTexture(Textures.unwrapImageByColumns(Textures.readImage(texturePack.getResourceAsStream(name.substring(2)))), id);
            } else if (name.startsWith("%clamp%")) {
                this.clampTexture = true;
                this.setupTexture(Textures.readImage(texturePack.getResourceAsStream(name.substring(7))), id);
                this.clampTexture = false;
            } else if (name.startsWith("%blur%")) {
                this.blurTexture = true;
                this.setupTexture(Textures.readImage(texturePack.getResourceAsStream(name.substring(6))), id);
                this.blurTexture = false;
            } else {
                InputStream inputstream = texturePack.getResourceAsStream(name);
                if (inputstream == null) {
                    this.setupTexture(Textures.missingTexture, id);
                } else {
                    this.setupTexture(Textures.readImage(inputstream), id, this.enableMipmapForTexture(name));
                }
            }
            this.textureMap.put(name, id);
            return id;
        }
        catch (Exception e) {
            e.printStackTrace();
            int j = GLAllocation.generateTexture();
            this.setupTexture(Textures.missingTexture, j);
            this.textureMap.put(name, j);
            return j;
        }
    }

    public int allocateAndSetupTexture(BufferedImage bufferedimage) {
        int i = GLAllocation.generateTexture();
        this.setupTexture(bufferedimage, i);
        this.textureNameToImageMap.put(i, bufferedimage);
        return i;
    }

    public void setupTexture(BufferedImage img, int id) {
        this.setupTexture(img, id, false);
    }

    public void setupTexture(BufferedImage img, int id, boolean mipmap) {
        GL11.glBindTexture((int)3553, (int)id);
        if (this.blurTexture) {
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        } else {
            GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        }
        if (this.clampTexture) {
            GL11.glTexParameteri((int)3553, (int)10242, (int)10496);
            GL11.glTexParameteri((int)3553, (int)10243, (int)10496);
        } else {
            GL11.glTexParameteri((int)3553, (int)10242, (int)10497);
            GL11.glTexParameteri((int)3553, (int)10243, (int)10497);
        }
        int w = img.getWidth();
        int h = img.getHeight();
        Buffer.put(img);
        GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)w, (int)h, (int)0, (int)6408, (int)5121, (ByteBuffer)Buffer.buffer);
        if (mipmap) {
            this.generateMipmaps(Buffer.buffer, img, (Integer)this.minecraft.gameSettings.mipmapLevels.value, this.minecraft.gameSettings.mipmapType.value == MipmapType.SMOOTH);
        }
    }

    private void generateMipmaps(ByteBuffer buffer, BufferedImage image, int levels, boolean smooth) {
        System.out.println("Generating Mipmaps...");
        int width = image.getWidth();
        int height = image.getHeight();
        int[] data = new int[width * height];
        int[] newData = null;
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                data[width * y + x] = image.getRGB(x, y);
            }
        }
        if (fixArtifacts) {
            for (int level = levels; level > 0; --level) {
                int lod = (int)Math.pow(2.0, level);
                int tilesX = width / lod;
                int tilesY = height / lod;
                for (int x = 0; x < tilesX; ++x) {
                    for (int y = 0; y < tilesY; ++y) {
                        int color;
                        int x0;
                        int y0;
                        int j;
                        int i;
                        Integer nonTransparentColor = null;
                        block5: for (i = 0; i < lod; ++i) {
                            for (j = 0; j < lod; ++j) {
                                y0 = y * lod + j;
                                x0 = x * lod + i;
                                color = data[width * y0 + x0];
                                if ((color >> 24 & 0xFF) <= 0) continue;
                                nonTransparentColor = color;
                                break block5;
                            }
                        }
                        if (nonTransparentColor == null) continue;
                        nonTransparentColor = nonTransparentColor & 0xFFFFFF;
                        for (i = 0; i < lod; ++i) {
                            for (j = 0; j < lod; ++j) {
                                y0 = y * lod + j;
                                x0 = x * lod + i;
                                color = data[width * y0 + x0];
                                if ((color >> 24 & 0xFF) != 0) continue;
                                data[width * y0 + x0] = nonTransparentColor;
                            }
                        }
                    }
                }
            }
        }
        int previousWidth = width;
        int newWidth = width;
        int newHeight = height;
        for (int level = 0; level <= levels; ++level) {
            newData = new int[newWidth * newHeight];
            for (int y = 0; y < newWidth; ++y) {
                for (int x = 0; x < newHeight; ++x) {
                    int color;
                    if (level == 0) {
                        color = data[width * y + x];
                    } else {
                        int x1 = x << 1;
                        int y1 = y << 1;
                        if (smooth) {
                            int color0 = data[previousWidth * (y1 + 0) + (x1 + 0)];
                            int color1 = data[previousWidth * (y1 + 0) + (x1 + 1)];
                            int color2 = data[previousWidth * (y1 + 1) + (x1 + 0)];
                            int color3 = data[previousWidth * (y1 + 1) + (x1 + 1)];
                            color = this.blendColor(this.blendColor(color0, color1), this.blendColor(color2, color3));
                        } else {
                            color = data[previousWidth * y1 + x1];
                        }
                    }
                    newData[y * newWidth + x] = color;
                }
            }
            buffer.position(0).limit(buffer.capacity());
            for (int i = 0; i < newData.length; ++i) {
                int color = newData[i];
                buffer.put((byte)(color >> 16 & 0xFF));
                buffer.put((byte)(color >> 8 & 0xFF));
                buffer.put((byte)(color >> 0 & 0xFF));
                buffer.put((byte)(color >> 24 & 0xFF));
            }
            buffer.limit(buffer.position()).flip();
            GL11.glTexImage2D((int)3553, (int)(debugMipmap ? 0 : level), (int)6408, (int)newWidth, (int)newHeight, (int)0, (int)6408, (int)5121, (ByteBuffer)buffer);
            if (!debugMipmap) {
                GL11.glTexParameteri((int)3553, (int)33085, (int)level);
                GL11.glTexParameteri((int)3553, (int)10241, (int)9986);
            }
            data = newData;
            previousWidth = newWidth;
            newWidth /= 2;
            newHeight /= 2;
        }
    }

    private int blendColor(int color0, int color1) {
        int alpha0 = color0 >> 24 & 0xFF;
        int alpha1 = color1 >> 24 & 0xFF;
        int alphaAvg = (alpha0 + alpha1) / 2;
        if (alpha0 == 0 && alpha1 == 0) {
            alpha0 = 1;
            alpha1 = 1;
        } else {
            if (alpha0 == 0) {
                color0 = color1;
                alphaAvg /= 2;
            }
            if (alpha1 == 0) {
                color1 = color0;
                alphaAvg /= 2;
            }
        }
        int r0 = (color0 >> 16 & 0xFF) * alpha0;
        int g0 = (color0 >> 8 & 0xFF) * alpha0;
        int b0 = (color0 >> 0 & 0xFF) * alpha0;
        int r1 = (color1 >> 16 & 0xFF) * alpha1;
        int g1 = (color1 >> 8 & 0xFF) * alpha1;
        int b1 = (color1 >> 0 & 0xFF) * alpha1;
        int rAvg = (r0 + r1) / (alpha0 + alpha1);
        int gAvg = (g0 + g1) / (alpha0 + alpha1);
        int bAvg = (b0 + b1) / (alpha0 + alpha1);
        return alphaAvg << 24 | rAvg << 16 | gAvg << 8 | bAvg;
    }

    public int createTexture(int width, int height) {
        int tex = GLAllocation.generateTexture();
        GL11.glBindTexture((int)3553, (int)tex);
        ByteBuffer buffer = ByteBuffer.allocateDirect(width * height * 4);
        GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)width, (int)height, (int)0, (int)6408, (int)5121, (ByteBuffer)buffer);
        return tex;
    }

    public void updateDynamicTexture(DynamicTexture texture) {
        texture.update();
        Buffer.checkBufferSize(texture.imageData.length);
        Buffer.reset();
        Buffer.buffer.put(texture.imageData);
        Buffer.buffer.position(0).limit(texture.imageData.length);
        GL11.glBindTexture((int)3553, (int)this.getTexture(texture.getTextureName()));
        int res = texture.resolution;
        int tileX = texture.textureIndex % RenderEngine.atlasWidth();
        int tileY = texture.textureIndex / RenderEngine.atlasWidth();
        for (int i = 0; i < texture.tileWidth; ++i) {
            for (int j = 0; j < texture.tileHeight; ++j) {
                int x1 = (tileX + i) * res;
                int y1 = (tileY + j) * res;
                GL11.glTexSubImage2D((int)3553, (int)0, (int)x1, (int)y1, (int)res, (int)res, (int)6408, (int)5121, (ByteBuffer)Buffer.buffer);
            }
        }
        if ((Integer)this.minecraft.gameSettings.mipmapLevels.value > 0) {
            int levels = GL11.glGetTexParameteri((int)3553, (int)33085);
            for (int level = 1; level <= levels; ++level) {
                int j;
                int i;
                int lod = (int)Math.pow(2.0, level);
                int res2 = res / lod;
                Buffer.reset();
                for (i = 0; i < res2; ++i) {
                    for (j = 0; j < res2; ++j) {
                        int k = j * lod * res + i * lod;
                        int l = j * res2 + i;
                        Buffer.buffer.put(l * 4 + 0, texture.imageData[k * 4 + 0]);
                        Buffer.buffer.put(l * 4 + 1, texture.imageData[k * 4 + 1]);
                        Buffer.buffer.put(l * 4 + 2, texture.imageData[k * 4 + 2]);
                        Buffer.buffer.put(l * 4 + 3, texture.imageData[k * 4 + 3]);
                    }
                }
                Buffer.buffer.position(0).limit(res2 * res2 * 4);
                for (i = 0; i < texture.tileWidth; ++i) {
                    for (j = 0; j < texture.tileHeight; ++j) {
                        int x1 = (tileX + i) * res;
                        int y1 = (tileY + j) * res;
                        GL11.glTexSubImage2D((int)3553, (int)level, (int)(x1 / lod), (int)(y1 / lod), (int)res2, (int)res2, (int)6408, (int)5121, (ByteBuffer)Buffer.buffer);
                    }
                }
            }
        }
    }

    public void updateTextureData(int[] imageData, int w, int h, int textureId) {
        GL11.glBindTexture((int)3553, (int)textureId);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        if (this.blurTexture) {
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        }
        if (this.clampTexture) {
            GL11.glTexParameteri((int)3553, (int)10242, (int)10496);
            GL11.glTexParameteri((int)3553, (int)10243, (int)10496);
        } else {
            GL11.glTexParameteri((int)3553, (int)10242, (int)10497);
            GL11.glTexParameteri((int)3553, (int)10243, (int)10497);
        }
        byte[] bytes = new byte[w * h * 4];
        for (int l = 0; l < imageData.length; ++l) {
            int i1 = imageData[l] >> 24 & 0xFF;
            int j1 = imageData[l] >> 16 & 0xFF;
            int k1 = imageData[l] >> 8 & 0xFF;
            int l1 = imageData[l] & 0xFF;
            bytes[l * 4] = (byte)j1;
            bytes[l * 4 + 1] = (byte)k1;
            bytes[l * 4 + 2] = (byte)l1;
            bytes[l * 4 + 3] = (byte)i1;
        }
        Buffer.buffer.clear();
        Buffer.buffer.put(bytes);
        Buffer.buffer.position(0).limit(bytes.length);
        GL11.glTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)w, (int)h, (int)6408, (int)5121, (ByteBuffer)Buffer.buffer);
    }

    public void deleteTexture(int i) {
        this.textureNameToImageMap.remove(i);
        GL11.glDeleteTextures((int)i);
    }

    public static int atlasWidth() {
        return Global.TEXTURE_ATLAS_WIDTH_TILES;
    }

    public void updateDynamicTextures() {
        for (DynamicTexture dynamicTexture : this.dynamicTextures) {
            this.updateDynamicTexture(dynamicTexture);
        }
    }

    private int weightedAverageColor(int i, int j) {
        int k = (i & 0xFF000000) >> 24 & 0xFF;
        int l = (j & 0xFF000000) >> 24 & 0xFF;
        int c = 255;
        if (k + l == 0) {
            k = 1;
            l = 1;
            c = 0;
        }
        int i1 = (i >> 16 & 0xFF) * k;
        int j1 = (i >> 8 & 0xFF) * k;
        int k1 = (i & 0xFF) * k;
        int l1 = (j >> 16 & 0xFF) * l;
        int i2 = (j >> 8 & 0xFF) * l;
        int j2 = (j & 0xFF) * l;
        int k2 = (i1 + l1) / (k + l);
        int l2 = (j1 + i2) / (k + l);
        int i3 = (k1 + j2) / (k + l);
        return c << 24 | k2 << 16 | l2 << 8 | i3;
    }

    public BufferedImage getImage(String name) {
        TexturePackBase pack = this.texturePacks.selectedTexturePack;
        try {
            BufferedImage img;
            if (name.startsWith("##")) {
                img = Textures.unwrapImageByColumns(Textures.readImage(pack.getResourceAsStream(name.substring(2))));
            } else if (name.startsWith("%clamp%")) {
                this.clampTexture = true;
                img = Textures.readImage(pack.getResourceAsStream(name.substring(7)));
            } else if (name.startsWith("%blur%")) {
                this.blurTexture = true;
                img = Textures.readImage(pack.getResourceAsStream(name.substring(6)));
            } else {
                img = Textures.readImage(pack.getResourceAsStream(name));
            }
            return img;
        }
        catch (Exception e) {
            return Textures.missingTexture;
        }
    }

    public void setupTexture(String name) {
        try {
            BufferedImage img = this.getImage(name);
            int j = this.textureMap.get(name);
            this.setupTexture(img, j, this.enableMipmapForTexture(name));
            this.blurTexture = false;
            this.clampTexture = false;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void refreshTextures() {
        TexturePackBase texturePack = this.texturePacks.selectedTexturePack;
        this.textureNameToImageMap.forEach((i, img) -> this.setupTexture((BufferedImage)img, (int)i));
        this.textureMap.forEach((name, id) -> this.setupTexture((String)name));
        for (String s : this.intArrayTextureData.keySet()) {
            try {
                BufferedImage img2;
                if (s.startsWith("##")) {
                    img2 = Textures.unwrapImageByColumns(Textures.readImage(texturePack.getResourceAsStream(s.substring(2))));
                } else if (s.startsWith("%clamp%")) {
                    this.clampTexture = true;
                    img2 = Textures.readImage(texturePack.getResourceAsStream(s.substring(7)));
                } else if (s.startsWith("%blur%")) {
                    this.blurTexture = true;
                    img2 = Textures.readImage(texturePack.getResourceAsStream(s.substring(6)));
                } else {
                    img2 = Textures.readImage(texturePack.getResourceAsStream(s));
                }
                Textures.getImageData(img2, this.intArrayTextureData.get(s));
                this.blurTexture = false;
                this.clampTexture = false;
            }
            catch (Exception ioexception1) {
                ioexception1.printStackTrace();
            }
        }
        this.initDynamicTextures();
        Colors.loadColors(texturePack);
        this.texturePacks.mc.fontRenderer = new FontRenderer(this.gameSettings, "/font/default.png", this);
        Properties colors = new Properties();
        try {
            colors.load(texturePack.getResourceAsStream("/misc/colors.properties"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ColorProperties.loadColors(colors);
    }

    public void bindTexture(int i) {
        if (i < 0) {
            return;
        }
        GL11.glBindTexture((int)3553, (int)i);
    }

    public Map<String, Integer> getTextureMap() {
        return this.textureMap;
    }

    public boolean loadDownloadableTexture(String url, String localTexture, ImageParser imageParser) {
        if (url == null) {
            if (localTexture != null) {
                this.bindTexture(this.getTexture(localTexture));
                return true;
            }
            return false;
        }
        DownloadedTexture texture = this.downloadedTextures.get(url);
        if (texture == null) {
            texture = new DownloadedTexture(url, imageParser);
            this.downloadedTextures.put(url, texture);
        }
        if (texture.textureId < 0 && texture.image != null) {
            texture.textureId = this.allocateAndSetupTexture(texture.image);
        }
        if (texture.textureId > 0) {
            this.bindTexture(texture.textureId);
            return true;
        }
        if (localTexture != null) {
            this.bindTexture(this.getTexture(localTexture));
            return true;
        }
        return false;
    }
}

