/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.camera;

import net.minecraft.client.Minecraft;
import net.minecraft.client.render.camera.EntityCamera;
import net.minecraft.core.entity.EntityLiving;

public class EntityCameraSleeping
extends EntityCamera {
    private static final int ANIM_TICKS = 5;
    private int ticks = 0;
    private double x;
    private double xo;
    private final double xs;
    private final double xt;
    private double y;
    private double yo;
    private final double ys;
    private final double yt;
    private double z;
    private double zo;
    private final double zs;
    private final double zt;
    private double yRot;
    private double yRotO;
    private final double yRotS;
    private final double yRotT;
    private double xRot;
    private double xRotO;
    private final double xRotS;
    private final double xRotT;

    public EntityCameraSleeping(Minecraft mc, EntityLiving entity, int xb, int yb, int zb, double xs, double ys, double zs, double yRotS, double xRotS) {
        super(mc, entity);
        int metadata = mc.theWorld.getBlockMetadata(xb, yb, zb) & 3;
        while (yRotS < 0.0) {
            yRotS += 360.0;
        }
        while (yRotS > 360.0) {
            yRotS -= 360.0;
        }
        while (xRotS < 0.0) {
            xRotS += 360.0;
        }
        while (xRotS > 360.0) {
            xRotS -= 360.0;
        }
        this.xo = this.x = xs;
        this.xs = this.x;
        this.yo = this.y = ys;
        this.ys = this.y;
        this.zo = this.z = zs;
        this.zs = this.z;
        this.yRotO = this.yRot = yRotS;
        this.yRotS = this.yRot;
        this.xRotO = this.xRot = xRotS;
        this.xRotS = this.xRot;
        this.xt = (double)xb + 0.5;
        this.yt = (double)yb + 0.8;
        this.zt = (double)zb + 0.5;
        this.yRotT = metadata * 90 + 180;
        this.xRotT = 0.0;
    }

    @Override
    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        this.yRotO = this.yRot;
        this.xRotO = this.xRot;
        if (this.ticks < 5) {
            ++this.ticks;
            double progress = (double)this.ticks / 5.0;
            double dx = this.xt - this.xs;
            double dy = this.yt - this.ys;
            double dz = this.zt - this.zs;
            double dYRot = this.yRotT - this.yRotS;
            double dXRot = this.xRotT - this.xRotS;
            if (dYRot > 180.0) {
                dYRot -= 360.0;
            }
            if (dXRot > 180.0) {
                dXRot -= 360.0;
            }
            this.x = this.xs + dx * progress;
            this.y = this.ys + dy * progress;
            this.z = this.zs + dz * progress;
            this.yRot = this.yRotS + dYRot * progress;
            this.xRot = this.xRotS + dXRot * progress;
        }
    }

    @Override
    public double getX(float renderPartialTicks) {
        if (renderPartialTicks == 1.0f) {
            return this.x;
        }
        return this.xo + (this.x - this.xo) * (double)renderPartialTicks;
    }

    @Override
    public double getY(float renderPartialTicks) {
        if (renderPartialTicks == 1.0f) {
            return this.y;
        }
        return this.yo + (this.y - this.yo) * (double)renderPartialTicks;
    }

    @Override
    public double getZ(float renderPartialTicks) {
        if (renderPartialTicks == 1.0f) {
            return this.z;
        }
        return this.zo + (this.z - this.zo) * (double)renderPartialTicks;
    }

    @Override
    public double getXRot(float renderPartialTicks) {
        if (renderPartialTicks == 1.0f) {
            return this.xRot;
        }
        return this.xRotO + (this.xRot - this.xRotO) * (double)renderPartialTicks;
    }

    @Override
    public double getYRot(float renderPartialTicks) {
        if (renderPartialTicks == 1.0f) {
            return this.yRot;
        }
        return this.yRotO + (this.yRot - this.yRotO) * (double)renderPartialTicks;
    }
}

