/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.dynamictexture;

import java.awt.image.BufferedImage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.render.dynamictexture.DynamicTextureRotating;
import net.minecraft.core.util.helper.Textures;

public abstract class DynamicTextureAbstractClock
extends DynamicTextureRotating {
    private String atlasTexture;

    public DynamicTextureAbstractClock(Minecraft minecraft, String atlasTexture, String dialTexture, int textureIndex, int resolution) {
        super(minecraft, atlasTexture, textureIndex, resolution);
        BufferedImage dialImage = Textures.readImage(minecraft.texturePackList.selectedTexturePack.getResourceAsStream(dialTexture));
        if (dialImage.getWidth() != dialImage.getHeight()) {
            throw new RuntimeException("Dial Texture " + dialTexture + " is not square!");
        }
        this.dialTexRes = dialImage.getWidth();
        this.dialImageData = new byte[dialImage.getWidth() * dialImage.getWidth() * 4];
        for (int x = 0; x < this.dialTexRes; ++x) {
            for (int y = 0; y < this.dialTexRes; ++y) {
                DynamicTextureAbstractClock.putPixel(this.dialImageData, y * this.dialTexRes + x, dialImage.getRGB(x, y));
            }
        }
        this.atlasTexture = atlasTexture;
    }

    @Override
    public String getTextureName() {
        return this.atlasTexture;
    }
}

