/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.entity;

import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.render.Tessellator;
import net.minecraft.client.render.entity.EntityRenderer;
import net.minecraft.core.entity.EntityPainting;
import net.minecraft.core.enums.EnumArt;
import net.minecraft.core.util.helper.MathHelper;
import org.lwjgl.opengl.GL11;

public class PaintingRenderer
extends EntityRenderer<EntityPainting> {
    private final Random rand = new Random();

    public void renderPainting(EntityPainting entity, double x, double y, double z, float yaw, float renderPartialTicks) {
        this.rand.setSeed(187L);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        GL11.glRotatef((float)yaw, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glEnable((int)32826);
        this.loadTexture("/art/kz.png");
        EnumArt art = entity.art;
        float scale = 0.0625f;
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        this.renderArt(entity, art.sizeX, art.sizeY, art.offsetX, art.offsetY);
        GL11.glDisable((int)32826);
        GL11.glPopMatrix();
    }

    private void renderArt(EntityPainting entity, int sizeX, int sizeY, int offsetX, int offsetY) {
        float negCenterX = (float)(-sizeX) / 2.0f;
        float negCenterY = (float)(-sizeY) / 2.0f;
        float minZ = -0.5f;
        float maxZ = 0.5f;
        for (int x = 0; x < sizeX / 16; ++x) {
            for (int y = 0; y < sizeY / 16; ++y) {
                float maxX = negCenterX + (float)((x + 1) * 16);
                float minX = negCenterX + (float)(x * 16);
                float maxY = negCenterY + (float)((y + 1) * 16);
                float minY = negCenterY + (float)(y * 16);
                this.setupPaintingBrightness(entity, (maxX + minX) / 2.0f, (maxY + minY) / 2.0f);
                float frontMinU = (float)(offsetX + sizeX - x * 16) / 512.0f;
                float frontMaxU = (float)(offsetX + sizeX - (x + 1) * 16) / 512.0f;
                float frontMinV = (float)(offsetY + sizeY - y * 16) / 512.0f;
                float frontMaxV = (float)(offsetY + sizeY - (y + 1) * 16) / 512.0f;
                float backMinU = 0.875f;
                float backMaxU = 0.90625f;
                float backMinV = 0.0f;
                float backMaxV = 0.03125f;
                float topBottomMinU = 0.875f;
                float topBottomMaxU = 0.90625f;
                float topBottomMinV = 9.765625E-4f;
                float topBottomMaxV = 9.765625E-4f;
                float sidesMinU = 0.875f;
                float sidesMaxU = 0.8769531f;
                float sidesMinV = 0.0f;
                float sidesMaxV = 0.03125f;
                Tessellator tessellator = Tessellator.instance;
                tessellator.startDrawingQuads();
                tessellator.setNormal(0.0f, 0.0f, -1.0f);
                tessellator.addVertexWithUV(maxX, minY, minZ, frontMaxU, frontMinV);
                tessellator.addVertexWithUV(minX, minY, minZ, frontMinU, frontMinV);
                tessellator.addVertexWithUV(minX, maxY, minZ, frontMinU, frontMaxV);
                tessellator.addVertexWithUV(maxX, maxY, minZ, frontMaxU, frontMaxV);
                tessellator.setNormal(0.0f, 0.0f, 1.0f);
                tessellator.addVertexWithUV(maxX, maxY, maxZ, backMinU, backMinV);
                tessellator.addVertexWithUV(minX, maxY, maxZ, backMaxU, backMinV);
                tessellator.addVertexWithUV(minX, minY, maxZ, backMaxU, backMaxV);
                tessellator.addVertexWithUV(maxX, minY, maxZ, backMinU, backMaxV);
                tessellator.setNormal(0.0f, 1.0f, 0.0f);
                tessellator.addVertexWithUV(maxX, maxY, minZ, topBottomMinU, topBottomMinV);
                tessellator.addVertexWithUV(minX, maxY, minZ, topBottomMaxU, topBottomMinV);
                tessellator.addVertexWithUV(minX, maxY, maxZ, topBottomMaxU, topBottomMaxV);
                tessellator.addVertexWithUV(maxX, maxY, maxZ, topBottomMinU, topBottomMaxV);
                tessellator.setNormal(0.0f, -1.0f, 0.0f);
                tessellator.addVertexWithUV(maxX, minY, maxZ, topBottomMinU, topBottomMinV);
                tessellator.addVertexWithUV(minX, minY, maxZ, topBottomMaxU, topBottomMinV);
                tessellator.addVertexWithUV(minX, minY, minZ, topBottomMaxU, topBottomMaxV);
                tessellator.addVertexWithUV(maxX, minY, minZ, topBottomMinU, topBottomMaxV);
                tessellator.setNormal(-1.0f, 0.0f, 0.0f);
                tessellator.addVertexWithUV(maxX, maxY, maxZ, sidesMaxU, sidesMinV);
                tessellator.addVertexWithUV(maxX, minY, maxZ, sidesMaxU, sidesMaxV);
                tessellator.addVertexWithUV(maxX, minY, minZ, sidesMinU, sidesMaxV);
                tessellator.addVertexWithUV(maxX, maxY, minZ, sidesMinU, sidesMinV);
                tessellator.setNormal(1.0f, 0.0f, 0.0f);
                tessellator.addVertexWithUV(minX, maxY, minZ, sidesMaxU, sidesMinV);
                tessellator.addVertexWithUV(minX, minY, minZ, sidesMaxU, sidesMaxV);
                tessellator.addVertexWithUV(minX, minY, maxZ, sidesMinU, sidesMaxV);
                tessellator.addVertexWithUV(minX, maxY, maxZ, sidesMinU, sidesMinV);
                tessellator.draw();
            }
        }
    }

    private void setupPaintingBrightness(EntityPainting entity, float centerX, float centerY) {
        int worldX = MathHelper.floor_double(entity.x);
        int worldY = MathHelper.floor_double(entity.y + (double)(centerY / 16.0f));
        int worldZ = MathHelper.floor_double(entity.z);
        if (entity.direction == 0) {
            worldX = MathHelper.floor_double(entity.x + (double)(centerX / 16.0f));
        }
        if (entity.direction == 1) {
            worldZ = MathHelper.floor_double(entity.z - (double)(centerX / 16.0f));
        }
        if (entity.direction == 2) {
            worldX = MathHelper.floor_double(entity.x - (double)(centerX / 16.0f));
        }
        if (entity.direction == 3) {
            worldZ = MathHelper.floor_double(entity.z + (double)(centerX / 16.0f));
        }
        float brightness = this.renderDispatcher.world.getLightBrightness(worldX, worldY, worldZ);
        if (Minecraft.getMinecraft((Object)this).fullbright) {
            brightness = 1.0f;
        }
        GL11.glColor3f((float)brightness, (float)brightness, (float)brightness);
    }

    @Override
    public void doRender(EntityPainting entity, double x, double y, double z, float yaw, float renderPartialTicks) {
        this.renderPainting(entity, x, y, z, yaw, renderPartialTicks);
    }
}

