/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.model;

import java.util.Random;
import net.minecraft.client.render.model.Cube;
import net.minecraft.client.render.model.ModelBase;
import net.minecraft.core.util.helper.MathHelper;

public class ModelGhast
extends ModelBase {
    Cube body;
    Cube[] tentacles = new Cube[9];

    public ModelGhast() {
        int byte0 = -16;
        this.body = new Cube(0, 0);
        this.body.addBox(-8.0f, -8.0f, -8.0f, 16, 16, 16);
        this.body.rotationPointY += (float)(24 + byte0);
        Random random = new Random(1660L);
        for (int i = 0; i < this.tentacles.length; ++i) {
            this.tentacles[i] = new Cube(0, 0);
            float f = (((float)(i % 3) - (float)(i / 3 % 2) * 0.5f + 0.25f) / 2.0f * 2.0f - 1.0f) * 5.0f;
            float f1 = ((float)(i / 3) / 2.0f * 2.0f - 1.0f) * 5.0f;
            int j = random.nextInt(7) + 8;
            this.tentacles[i].addBox(-1.0f, 0.0f, -1.0f, 2, j, 2);
            this.tentacles[i].rotationPointX = f;
            this.tentacles[i].rotationPointZ = f1;
            this.tentacles[i].rotationPointY = 31 + byte0;
        }
    }

    @Override
    public void setRotationAngles(float limbSwing, float limbYaw, float ticksExisted, float headYaw, float headPitch, float scale) {
        for (int i = 0; i < this.tentacles.length; ++i) {
            this.tentacles[i].rotateAngleX = 0.2f * MathHelper.sin(ticksExisted * 0.3f + (float)i) + 0.4f;
        }
    }

    @Override
    public void render(float limbSwing, float limbYaw, float ticksExisted, float headYaw, float headPitch, float scale) {
        this.setRotationAngles(limbSwing, limbYaw, ticksExisted, headYaw, headPitch, scale);
        this.body.render(scale);
        for (int i = 0; i < this.tentacles.length; ++i) {
            this.tentacles[i].render(scale);
        }
    }
}

