/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.model;

import net.minecraft.client.render.model.Cube;
import net.minecraft.client.render.model.ModelBase;
import net.minecraft.core.util.helper.MathHelper;

public class ModelQuadruped
extends ModelBase {
    public Cube head = new Cube(0, 0);
    public Cube body;
    public Cube leg1;
    public Cube leg2;
    public Cube leg3;
    public Cube leg4;

    public ModelQuadruped(int i, float f) {
        this.head.addBox(-4.0f, -4.0f, -8.0f, 8, 8, 8, f);
        this.head.setRotationPoint(0.0f, 18 - i, -6.0f);
        this.body = new Cube(28, 8);
        this.body.addBox(-5.0f, -10.0f, -7.0f, 10, 16, 8, f);
        this.body.setRotationPoint(0.0f, 17 - i, 2.0f);
        this.leg1 = new Cube(0, 16);
        this.leg1.addBox(-2.0f, 0.0f, -2.0f, 4, i, 4, f);
        this.leg1.setRotationPoint(-3.0f, 24 - i, 7.0f);
        this.leg2 = new Cube(0, 16);
        this.leg2.addBox(-2.0f, 0.0f, -2.0f, 4, i, 4, f);
        this.leg2.setRotationPoint(3.0f, 24 - i, 7.0f);
        this.leg3 = new Cube(0, 16);
        this.leg3.addBox(-2.0f, 0.0f, -2.0f, 4, i, 4, f);
        this.leg3.setRotationPoint(-3.0f, 24 - i, -5.0f);
        this.leg4 = new Cube(0, 16);
        this.leg4.addBox(-2.0f, 0.0f, -2.0f, 4, i, 4, f);
        this.leg4.setRotationPoint(3.0f, 24 - i, -5.0f);
    }

    @Override
    public void render(float limbSwing, float limbYaw, float ticksExisted, float headYaw, float headPitch, float scale) {
        this.setRotationAngles(limbSwing, limbYaw, ticksExisted, headYaw, headPitch, scale);
        this.head.render(scale);
        this.body.render(scale);
        this.leg1.render(scale);
        this.leg2.render(scale);
        this.leg3.render(scale);
        this.leg4.render(scale);
    }

    @Override
    public void setRotationAngles(float limbSwing, float limbYaw, float ticksExisted, float headYaw, float headPitch, float scale) {
        this.head.rotateAngleX = headPitch / 57.29578f;
        this.head.rotateAngleY = headYaw / 57.29578f;
        this.body.rotateAngleX = 1.570796f;
        this.leg1.rotateAngleX = MathHelper.cos(limbSwing * 0.6662f) * 1.4f * limbYaw;
        this.leg2.rotateAngleX = MathHelper.cos(limbSwing * 0.6662f + 3.141593f) * 1.4f * limbYaw;
        this.leg3.rotateAngleX = MathHelper.cos(limbSwing * 0.6662f + 3.141593f) * 1.4f * limbYaw;
        this.leg4.rotateAngleX = MathHelper.cos(limbSwing * 0.6662f) * 1.4f * limbYaw;
    }
}

