/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.sound;

import java.lang.reflect.Field;
import java.util.HashMap;
import net.minecraft.client.option.GameSettings;
import net.minecraft.client.option.VolumeOption;
import net.minecraft.core.sound.SoundType;

public class SoundTypeHelper {
    private static final HashMap<SoundType, Field> VOLUME_FIELDS = new HashMap();

    public static boolean isAnyEnabled(GameSettings gameSettings) {
        for (SoundType type : SoundType.values()) {
            if (!(SoundTypeHelper.getEffectiveVolume(type, gameSettings) > 0.0f)) continue;
            return true;
        }
        return false;
    }

    public static float getVolume(SoundType soundType, GameSettings gameSettings) {
        Field field = VOLUME_FIELDS.get((Object)soundType);
        if (field == null) {
            return 0.0f;
        }
        try {
            return ((Float)((VolumeOption)field.get((Object)gameSettings)).value).floatValue();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0.0f;
        }
    }

    public static float getEffectiveVolume(SoundType soundType, GameSettings gameSettings) {
        Field field = VOLUME_FIELDS.get((Object)soundType);
        if (field == null) {
            return 0.0f;
        }
        try {
            float value = ((Float)((VolumeOption)field.get((Object)gameSettings)).value).floatValue();
            return value * ((Float)gameSettings.masterVolume.value).floatValue();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0.0f;
        }
    }

    public static void setVolume(SoundType soundType, GameSettings gameSettings, float value) {
        Field field = VOLUME_FIELDS.get((Object)soundType);
        if (field == null) {
            return;
        }
        try {
            VolumeOption option = (VolumeOption)field.get(gameSettings);
            option.value = Float.valueOf(value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        try {
            VOLUME_FIELDS.put(SoundType.MUSIC, GameSettings.class.getDeclaredField("musicVolume"));
            VOLUME_FIELDS.put(SoundType.WORLD_SOUNDS, GameSettings.class.getDeclaredField("worldSoundsVolume"));
            VOLUME_FIELDS.put(SoundType.WEATHER_SOUNDS, GameSettings.class.getDeclaredField("weatherSoundsVolume"));
            VOLUME_FIELDS.put(SoundType.ENTITY_SOUNDS, GameSettings.class.getDeclaredField("entitySoundsVolume"));
            VOLUME_FIELDS.put(SoundType.CAVE_SOUNDS, GameSettings.class.getDeclaredField("caveSoundsVolume"));
            VOLUME_FIELDS.put(SoundType.GUI_SOUNDS, GameSettings.class.getDeclaredField("guiSoundsVolume"));
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }
}

