/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.achievement.stat;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.core.achievement.AchievementList;
import net.minecraft.core.achievement.stat.StatBase;
import net.minecraft.core.achievement.stat.StatBasic;
import net.minecraft.core.achievement.stat.StatItem;
import net.minecraft.core.block.Block;
import net.minecraft.core.crafting.CraftingManager;
import net.minecraft.core.crafting.recipe.IRecipe;
import net.minecraft.core.crafting.recipe.RecipesFurnace;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;

public abstract class StatList {
    protected static Map<Integer, StatBase> statMap = new HashMap<Integer, StatBase>();
    public static List<StatBase> statList1 = new ArrayList<StatBase>();
    public static List<StatBase> statList2 = new ArrayList<StatBase>();
    public static List<StatBase> usedItemStatsList = new ArrayList<StatBase>();
    public static List<StatBase> statList3 = new ArrayList<StatBase>();
    public static StatBase startGameStat = new StatBasic(1000, "stat.startGame").setClientside().registerStat();
    public static StatBase createWorldStat = new StatBasic(1001, "stat.createWorld").setClientside().registerStat();
    public static StatBase loadWorldStat = new StatBasic(1002, "stat.loadWorld").setClientside().registerStat();
    public static StatBase joinMultiplayerStat = new StatBasic(1003, "stat.joinMultiplayer").setClientside().registerStat();
    public static StatBase leaveGameStat = new StatBasic(1004, "stat.leaveGame").setClientside().registerStat();
    public static StatBase minutesPlayedStat = new StatBasic(1100, "stat.playOneMinute", StatBase.statTypeTime).setClientside().registerStat();
    public static StatBase distanceWalkedStat = new StatBasic(2000, "stat.walkOneCm", StatBase.statTypeDistance).setClientside().registerStat();
    public static StatBase distanceSwumStat = new StatBasic(2001, "stat.swimOneCm", StatBase.statTypeDistance).setClientside().registerStat();
    public static StatBase distanceFallenStat = new StatBasic(2002, "stat.fallOneCm", StatBase.statTypeDistance).setClientside().registerStat();
    public static StatBase distanceClimbedStat = new StatBasic(2003, "stat.climbOneCm", StatBase.statTypeDistance).setClientside().registerStat();
    public static StatBase distanceFlownStat = new StatBasic(2004, "stat.flyOneCm", StatBase.statTypeDistance).setClientside().registerStat();
    public static StatBase distanceDoveStat = new StatBasic(2005, "stat.diveOneCm", StatBase.statTypeDistance).setClientside().registerStat();
    public static StatBase distanceByMinecartStat = new StatBasic(2006, "stat.minecartOneCm", StatBase.statTypeDistance).setClientside().registerStat();
    public static StatBase distanceByBoatStat = new StatBasic(2007, "stat.boatOneCm", StatBase.statTypeDistance).setClientside().registerStat();
    public static StatBase distanceByPigStat = new StatBasic(2008, "stat.pigOneCm", StatBase.statTypeDistance).setClientside().registerStat();
    public static StatBase jumpStat = new StatBasic(2010, "stat.jump").setClientside().registerStat();
    public static StatBase dropStat = new StatBasic(2011, "stat.drop").setClientside().registerStat();
    public static StatBase damageDealtStat = new StatBasic(2020, "stat.damageDealt").registerStat();
    public static StatBase damageTakenStat = new StatBasic(2021, "stat.damageTaken").registerStat();
    public static StatBase deathsStat = new StatBasic(2022, "stat.deaths").registerStat();
    public static StatBase mobKillsStat = new StatBasic(2023, "stat.mobKills").registerStat();
    public static StatBase playerKillsStat = new StatBasic(2024, "stat.playerKills").registerStat();
    public static StatBase fishCaughtStat = new StatBasic(2025, "stat.fishCaught").registerStat();
    public static StatBase[] mineBlockStatArray = StatList.func_25153_a("stat.mineBlock", 0x1000000);
    public static StatBase[] craftedItemStats;
    public static StatBase[] usedItemStats;
    public static StatBase[] breakItemStats;
    public static StatBase[] pickUpItemStats;
    private static boolean blocksInitialized;
    private static boolean itemsInitialized;

    public static void init() {
    }

    public static void onBlockInit() {
        usedItemStats = StatList.initUsedItemStats(usedItemStats, "stat.useItem", 0x1020000, 0, Block.blocksList.length);
        breakItemStats = StatList.initBreakItemStats(breakItemStats, "stat.breakItem", 0x1030000, 0, Block.blocksList.length);
        blocksInitialized = true;
        StatList.blocksAndItemsInitialized();
    }

    public static void onItemInit() {
        usedItemStats = StatList.initUsedItemStats(usedItemStats, "stat.useItem", 0x1020000, Block.blocksList.length, Item.itemsList.length);
        breakItemStats = StatList.initBreakItemStats(breakItemStats, "stat.breakItem", 0x1030000, Block.blocksList.length, Item.itemsList.length);
        itemsInitialized = true;
        StatList.blocksAndItemsInitialized();
    }

    public static void blocksAndItemsInitialized() {
        if (!blocksInitialized || !itemsInitialized) {
            return;
        }
        HashSet<Integer> hashset = new HashSet<Integer>();
        for (IRecipe irecipe : CraftingManager.getInstance().getRecipeList()) {
            hashset.add(irecipe.getRecipeOutput().itemID);
        }
        for (ItemStack itemstack : RecipesFurnace.smelting().getSmeltingList().values()) {
            hashset.add(itemstack.itemID);
        }
        craftedItemStats = new StatBase[Item.itemsList.length];
        pickUpItemStats = new StatBase[Item.itemsList.length];
        for (Integer integer : hashset) {
            if (Item.itemsList[integer] == null) continue;
            StatList.craftedItemStats[integer.intValue()] = new StatItem(0x1010000 + integer, "stat.craftItem", integer).registerStat();
        }
        for (int i = 0; i < Item.itemsList.length; ++i) {
            StatList.pickUpItemStats[i] = new StatItem(0x1040000 + i, "", i).registerStat();
        }
        StatList.replaceAllSimilarBlocks(craftedItemStats);
    }

    private static StatBase[] func_25153_a(String s, int i) {
        StatBase[] astatbase = new StatBase[Block.blocksList.length];
        for (int j = 0; j < Block.blocksList.length; ++j) {
            if (Block.blocksList[j] == null || !Block.blocksList[j].getEnableStats()) continue;
            astatbase[j] = new StatItem(i + j, s, j).registerStat();
            statList3.add((StatItem)astatbase[j]);
        }
        StatList.replaceAllSimilarBlocks(astatbase);
        return astatbase;
    }

    private static StatBase[] initUsedItemStats(StatBase[] astatbase, String s, int i, int j, int k) {
        if (astatbase == null) {
            astatbase = new StatBase[Item.itemsList.length];
        }
        for (int l = j; l < k; ++l) {
            if (Item.itemsList[l] == null) continue;
            astatbase[l] = new StatItem(i + l, s, l).registerStat();
            if (l < Block.blocksList.length) continue;
            usedItemStatsList.add((StatItem)astatbase[l]);
        }
        StatList.replaceAllSimilarBlocks(astatbase);
        return astatbase;
    }

    private static StatBase[] initBreakItemStats(StatBase[] astatbase, String s, int i, int j, int k) {
        if (astatbase == null) {
            astatbase = new StatBase[Item.itemsList.length];
        }
        for (int l = j; l < k; ++l) {
            if (Item.itemsList[l] == null || !Item.itemsList[l].isDamagable()) continue;
            astatbase[l] = new StatItem(i + l, s, l).registerStat();
        }
        StatList.replaceAllSimilarBlocks(astatbase);
        return astatbase;
    }

    private static void replaceAllSimilarBlocks(StatBase[] astatbase) {
        StatList.replaceSimilarBlocks(astatbase, Block.fluidWaterStill.id, Block.fluidWaterFlowing.id);
        StatList.replaceSimilarBlocks(astatbase, Block.fluidLavaStill.id, Block.fluidLavaStill.id);
        StatList.replaceSimilarBlocks(astatbase, Block.pumpkinCarvedActive.id, Block.pumpkinCarvedIdle.id);
        StatList.replaceSimilarBlocks(astatbase, Block.furnaceStoneActive.id, Block.furnaceStoneIdle.id);
        StatList.replaceSimilarBlocks(astatbase, Block.oreRedstoneGlowingStone.id, Block.oreRedstoneStone.id);
        StatList.replaceSimilarBlocks(astatbase, Block.repeaterActive.id, Block.repeaterIdle.id);
        StatList.replaceSimilarBlocks(astatbase, Block.torchRedstoneActive.id, Block.torchRedstoneIdle.id);
        StatList.replaceSimilarBlocks(astatbase, Block.mushroomRed.id, Block.mushroomBrown.id);
        StatList.replaceSimilarBlocks(astatbase, Block.grass.id, Block.dirt.id);
        StatList.replaceSimilarBlocks(astatbase, Block.farmlandDirt.id, Block.dirt.id);
    }

    private static void replaceSimilarBlocks(StatBase[] astatbase, int i, int j) {
        if (astatbase[i] != null && astatbase[j] == null) {
            astatbase[j] = astatbase[i];
            return;
        }
        statList1.remove(astatbase[i]);
        statList3.remove(astatbase[i]);
        statList2.remove(astatbase[i]);
        astatbase[i] = astatbase[j];
    }

    public static StatBase getStat(int i) {
        return statMap.get(i);
    }

    static {
        blocksInitialized = false;
        itemsInitialized = false;
        AchievementList.init();
    }
}

