/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.achievement.stat;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import net.minecraft.core.achievement.stat.StatFileWriter;
import net.minecraft.core.net.thread.ThreadStatSyncherReceive;
import net.minecraft.core.net.thread.ThreadStatSyncherSend;
import net.minecraft.core.player.Session;

public class StatsSyncher {
    private volatile boolean busy = false;
    private volatile Map map1 = null;
    private volatile Map map2 = null;
    private StatFileWriter statFileWriter;
    private File file1;
    private File file2;
    private File file3;
    private File file4;
    private File file5;
    private File file6;
    private Session session;
    private int int1 = 0;
    private int int2 = 0;

    public StatsSyncher(Session session, StatFileWriter statfilewriter, File file) {
        this.file1 = new File(file, "stats_" + session.username.toLowerCase() + "_unsent.dat");
        this.file2 = new File(file, "stats_" + session.username.toLowerCase() + ".dat");
        this.file5 = new File(file, "stats_" + session.username.toLowerCase() + "_unsent.old");
        this.file6 = new File(file, "stats_" + session.username.toLowerCase() + ".old");
        this.file3 = new File(file, "stats_" + session.username.toLowerCase() + "_unsent.tmp");
        this.file4 = new File(file, "stats_" + session.username.toLowerCase() + ".tmp");
        if (!session.username.toLowerCase().equals(session.username)) {
            this.func_28214_a(file, "stats_" + session.username + "_unsent.dat", this.file1);
            this.func_28214_a(file, "stats_" + session.username + ".dat", this.file2);
            this.func_28214_a(file, "stats_" + session.username + "_unsent.old", this.file5);
            this.func_28214_a(file, "stats_" + session.username + ".old", this.file6);
            this.func_28214_a(file, "stats_" + session.username + "_unsent.tmp", this.file3);
            this.func_28214_a(file, "stats_" + session.username + ".tmp", this.file4);
        }
        this.statFileWriter = statfilewriter;
        this.session = session;
        if (this.file1.exists()) {
            statfilewriter.func_27179_a(this.func_27415_a(this.file1, this.file3, this.file5));
        }
        this.func_27418_a();
    }

    private void func_28214_a(File file, String s, File file1) {
        File file2 = new File(file, s);
        if (file2.exists() && !file2.isDirectory() && !file1.exists()) {
            file2.renameTo(file1);
        }
    }

    private Map func_27415_a(File file, File file1, File file2) {
        if (file.exists()) {
            return this.func_27408_a(file);
        }
        if (file2.exists()) {
            return this.func_27408_a(file2);
        }
        if (file1.exists()) {
            return this.func_27408_a(file1);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map func_27408_a(File file) {
        BufferedReader bufferedreader = null;
        try {
            Map map;
            bufferedreader = new BufferedReader(new FileReader(file));
            String s = "";
            StringBuilder stringbuilder = new StringBuilder();
            while ((s = bufferedreader.readLine()) != null) {
                stringbuilder.append(s);
            }
            Map map2 = map = StatFileWriter.func_27177_a(stringbuilder.toString());
            return map2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (bufferedreader != null) {
                try {
                    bufferedreader.close();
                }
                catch (Exception exception2) {
                    exception2.printStackTrace();
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveStats(Map map, File file, File file1, File file2) throws IOException {
        try (PrintWriter printwriter = new PrintWriter(new FileWriter(file1, false));){
            printwriter.print(StatFileWriter.getStatFileContentString(this.session.username, "local", map));
        }
        if (file2.exists()) {
            file2.delete();
        }
        if (file.exists()) {
            file.renameTo(file2);
        }
        file1.renameTo(file);
    }

    public void func_27418_a() {
        if (this.busy) {
            throw new IllegalStateException("Can't get stats from server while StatsSyncher is busy!");
        }
        this.int1 = 100;
        this.busy = true;
        new ThreadStatSyncherReceive(this).start();
    }

    public void func_27424_a(Map map) {
        if (this.busy) {
            throw new IllegalStateException("Can't save stats while StatsSyncher is busy!");
        }
        this.int1 = 100;
        this.busy = true;
        new ThreadStatSyncherSend(this, map).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncStatsFileWithMap(Map map) {
        int i = 30;
        while (this.busy && --i > 0) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedexception) {
                interruptedexception.printStackTrace();
            }
        }
        this.busy = true;
        try {
            this.saveStats(map, this.file1, this.file3, this.file5);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            this.busy = false;
        }
    }

    public boolean func_27420_b() {
        return this.int1 <= 0 && !this.busy && this.map2 == null;
    }

    public void func_27425_c() {
        if (this.int1 > 0) {
            --this.int1;
        }
        if (this.int2 > 0) {
            --this.int2;
        }
        if (this.map2 != null) {
            this.statFileWriter.func_27187_c(this.map2);
            this.map2 = null;
        }
        if (this.map1 != null) {
            this.statFileWriter.func_27180_b(this.map1);
            this.map1 = null;
        }
    }

    public static Map func_27422_a(StatsSyncher statssyncher) {
        return statssyncher.map1;
    }

    public static File func_27423_b(StatsSyncher statssyncher) {
        return statssyncher.file2;
    }

    public static File func_27411_c(StatsSyncher statssyncher) {
        return statssyncher.file4;
    }

    public static File func_27413_d(StatsSyncher statssyncher) {
        return statssyncher.file6;
    }

    public static void func_27412_a(StatsSyncher statssyncher, Map map, File file, File file1, File file2) throws IOException {
        statssyncher.saveStats(map, file, file1, file2);
    }

    public static Map func_27421_a(StatsSyncher statssyncher, Map map) {
        statssyncher.map1 = map;
        return statssyncher.map1;
    }

    public static Map func_27409_a(StatsSyncher statssyncher, File file, File file1, File file2) {
        return statssyncher.func_27415_a(file, file1, file2);
    }

    public static boolean func_27416_a(StatsSyncher statssyncher, boolean flag) {
        statssyncher.busy = flag;
        return statssyncher.busy;
    }

    public static File func_27414_e(StatsSyncher statssyncher) {
        return statssyncher.file1;
    }

    public static File func_27417_f(StatsSyncher statssyncher) {
        return statssyncher.file3;
    }

    public static File func_27419_g(StatsSyncher statssyncher) {
        return statssyncher.file5;
    }
}

