/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.vehicle.EntityBoat;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;

public class BlockAlgae
extends Block {
    protected BlockAlgae(String key, int id, Material material) {
        super(key, id, material);
        this.setBlockBounds(0.0f, -0.125f, 0.0f, 1.0f, 0.00625f, 1.0f);
    }

    @Override
    public void onEntityCollidedWithBlock(World world, int x, int y, int z, Entity entity) {
        if (entity instanceof EntityBoat) {
            world.playSoundEffectForPlayer(null, 2001, x, y, z, this.id);
            world.setBlockWithNotify(x, y, z, 0);
            this.onBlockRemoval(world, x, y, z);
        }
    }

    @Override
    public boolean canPlaceBlockAt(World world, int x, int y, int z) {
        int blockId = world.getBlockId(x, y, z);
        return blockId == 0 && Block.hasTag(world.getBlockId(x, y - 1, z), BlockTags.IS_WATER);
    }

    @Override
    public void onNeighborBlockChange(World world, int x, int y, int z, int blockId) {
        if (world.getBlockId(x, y - 1, z) != Block.fluidWaterStill.id) {
            world.setBlock(x, y, z, 0);
        }
    }

    @Override
    public void setBlockBoundsForItemRender() {
        this.setBlockBounds(0.0f, 0.01f, 0.0f, 1.0f, 0.0125f, 1.0f);
    }

    @Override
    public AABB getCollisionBoundingBoxFromPool(World world, int x, int y, int z) {
        return null;
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public boolean shouldSideBeRendered(WorldSource blockAccess, int x, int y, int z, int side) {
        if (side == 1) {
            return true;
        }
        return super.shouldSideBeRendered(blockAccess, x, y, z, side);
    }

    @Override
    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int x, int y, int z, int meta, TileEntity tileEntity) {
        switch (dropCause) {
            case SILK_TOUCH: 
            case PICK_BLOCK: {
                return new ItemStack[]{new ItemStack(this)};
            }
        }
        return null;
    }
}

