/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;

public class BlockCandle
extends Block {
    public BlockCandle(String key, int id, Material material) {
        super(key, id, material);
        this.setTickOnLoad(true);
        this.setBlockBounds(0.40625f, 0.0f, 0.40625f, 0.59375f, 0.5f, 0.59375f);
    }

    @Override
    public AABB getCollisionBoundingBoxFromPool(World world, int x, int y, int z) {
        return null;
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public boolean canPlaceBlockAt(World world, int x, int y, int z) {
        return world.canPlaceOnSurfaceOfBlock(x, y - 1, z);
    }

    @Override
    public void onNeighborBlockChange(World world, int x, int y, int z, int blockId) {
        boolean flag;
        if (world.isClientSide) {
            return;
        }
        boolean bl = flag = !world.canPlaceOnSurfaceOfBlock(x, y - 1, z);
        if (flag) {
            this.dropBlockWithCause(world, EnumDropCause.WORLD, x, y, z, world.getBlockMetadata(x, y, z), null);
            world.setBlockWithNotify(x, y, z, 0);
        }
    }

    @Override
    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int x, int y, int z, int meta, TileEntity tileEntity) {
        return new ItemStack[]{null};
    }

    @Override
    public void randomDisplayTick(World world, int x, int y, int z, Random rand) {
        double d = (float)x + 0.5f;
        double d1 = (float)y + 0.7f;
        double d2 = (float)z + 0.5f;
        world.spawnParticle("smoke", d, d1, d2, 0.0, 0.0, 0.0);
        world.spawnParticle("soulflame", d, d1, d2, 0.0, 0.0, 0.0);
    }
}

