/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockChest;
import net.minecraft.core.block.BlockTileEntity;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.entity.TileEntityChest;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;

public class BlockChestLegacy
extends BlockTileEntity {
    public BlockChestLegacy(String key, int id, Material material) {
        super(key, id, Material.wood);
        this.withTexCoords(9, 1);
    }

    @Override
    public int getBlockTextureFromSideAndMetadata(Side side, int meta) {
        if (side.isHorizontal()) {
            return BlockChestLegacy.texCoordToIndex(10, 1);
        }
        return BlockChestLegacy.texCoordToIndex(9, 1);
    }

    @Override
    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int x, int y, int z, int meta, TileEntity tileEntity) {
        Block block;
        if (BlockChestLegacy.isLegacyChest(world, x, y, z)) {
            this.updateLegacyChest(world, x, y, z);
        }
        if ((block = world.getBlock(x, y, z)) != null) {
            return block.getBreakResult(world, dropCause, x, y, z, meta, tileEntity);
        }
        return null;
    }

    @Override
    protected TileEntity getNewBlockEntity() {
        return new TileEntityChest();
    }

    public static boolean isLegacyChest(World world, int x, int y, int z) {
        int id = world.getBlockId(x, y, z);
        return id == Block.chestLegacy.id || id == Block.chestLegacyPainted.id;
    }

    @Override
    public void onBlockRemoval(World world, int x, int y, int z) {
        BlockChest.dropChestContent(world, x, y, z);
        super.onBlockRemoval(world, x, y, z);
    }

    @Override
    public boolean blockActivated(World world, int x, int y, int z, EntityPlayer player) {
        if (world.isClientSide) {
            return true;
        }
        if (BlockChestLegacy.isLegacyChest(world, x, y, z)) {
            this.updateLegacyChest(world, x, y, z);
        }
        return world.getBlock(x, y, z).blockActivated(world, x, y, z, player);
    }

    private void updateLegacyChest(World world, int x, int y, int z) {
        Direction facingDirection = Direction.SOUTH;
        Direction otherChestDirection = null;
        if (BlockChestLegacy.isLegacyChest(world, x + 1, y, z)) {
            otherChestDirection = Direction.EAST;
        }
        if (BlockChestLegacy.isLegacyChest(world, x - 1, y, z)) {
            otherChestDirection = Direction.WEST;
        }
        if (BlockChestLegacy.isLegacyChest(world, x, y, z + 1)) {
            otherChestDirection = Direction.SOUTH;
        }
        if (BlockChestLegacy.isLegacyChest(world, x, y, z - 1)) {
            otherChestDirection = Direction.NORTH;
        }
        if (otherChestDirection == null) {
            int meta = world.getBlockMetadata(x, y, z);
            if (world.isBlockOpaqueCube(x + 1, y, z) && !world.isBlockOpaqueCube(x - 1, y, z)) {
                facingDirection = Direction.WEST;
            }
            if (world.isBlockOpaqueCube(x - 1, y, z) && !world.isBlockOpaqueCube(x + 1, y, z)) {
                facingDirection = Direction.EAST;
            }
            if (world.isBlockOpaqueCube(x, y, z + 1) && !world.isBlockOpaqueCube(x, y, z - 1)) {
                facingDirection = Direction.NORTH;
            }
            if (world.isBlockOpaqueCube(x, y, z - 1) && !world.isBlockOpaqueCube(x, y, z + 1)) {
                facingDirection = Direction.SOUTH;
            }
            meta = BlockChest.getMetaWithDirection(meta, facingDirection);
            meta = BlockChest.getMetaWithType(meta, BlockChest.Type.SINGLE);
            ItemStack[] items = this.getAndClearChestInventory(world, x, y, z);
            this.updateChestBlock(world, x, y, z, meta);
            this.setChestInventory(world, x, y, z, items);
        } else {
            int otherChestX = x;
            int otherChestZ = z;
            if (otherChestDirection == Direction.NORTH) {
                --otherChestZ;
            }
            if (otherChestDirection == Direction.SOUTH) {
                ++otherChestZ;
            }
            if (otherChestDirection == Direction.EAST) {
                ++otherChestX;
            }
            if (otherChestDirection == Direction.WEST) {
                --otherChestX;
            }
            int meta = world.getBlockMetadata(x, y, z);
            int otherMeta = world.getBlockMetadata(otherChestX, y, otherChestZ);
            if (otherChestDirection == Direction.NORTH) {
                facingDirection = Direction.EAST;
                if (world.isBlockOpaqueCube(x + 1, y, z) || world.isBlockOpaqueCube(x + 1, y, z - 1)) {
                    facingDirection = Direction.WEST;
                }
            }
            if (otherChestDirection == Direction.SOUTH) {
                facingDirection = Direction.EAST;
                if (world.isBlockOpaqueCube(x + 1, y, z) || world.isBlockOpaqueCube(x + 1, y, z + 1)) {
                    facingDirection = Direction.WEST;
                }
            }
            if (otherChestDirection == Direction.EAST) {
                facingDirection = Direction.SOUTH;
                if (world.isBlockOpaqueCube(x, y, z + 1) || world.isBlockOpaqueCube(x + 1, y, z + 1)) {
                    facingDirection = Direction.NORTH;
                }
            }
            if (otherChestDirection == Direction.WEST) {
                facingDirection = Direction.SOUTH;
                if (world.isBlockOpaqueCube(x, y, z + 1) || world.isBlockOpaqueCube(x - 1, y, z + 1)) {
                    facingDirection = Direction.NORTH;
                }
            }
            BlockChest.Type type = BlockChest.Type.SINGLE;
            if (facingDirection == Direction.NORTH && otherChestDirection == Direction.EAST) {
                type = BlockChest.Type.RIGHT;
            }
            if (facingDirection == Direction.NORTH && otherChestDirection == Direction.WEST) {
                type = BlockChest.Type.LEFT;
            }
            if (facingDirection == Direction.EAST && otherChestDirection == Direction.NORTH) {
                type = BlockChest.Type.LEFT;
            }
            if (facingDirection == Direction.EAST && otherChestDirection == Direction.SOUTH) {
                type = BlockChest.Type.RIGHT;
            }
            if (facingDirection == Direction.SOUTH && otherChestDirection == Direction.EAST) {
                type = BlockChest.Type.LEFT;
            }
            if (facingDirection == Direction.SOUTH && otherChestDirection == Direction.WEST) {
                type = BlockChest.Type.RIGHT;
            }
            if (facingDirection == Direction.WEST && otherChestDirection == Direction.NORTH) {
                type = BlockChest.Type.RIGHT;
            }
            if (facingDirection == Direction.WEST && otherChestDirection == Direction.SOUTH) {
                type = BlockChest.Type.LEFT;
            }
            BlockChest.Type otherType = BlockChest.Type.SINGLE;
            if (type == BlockChest.Type.LEFT) {
                otherType = BlockChest.Type.RIGHT;
            }
            if (type == BlockChest.Type.RIGHT) {
                otherType = BlockChest.Type.LEFT;
            }
            meta = BlockChest.getMetaWithDirection(meta, facingDirection);
            meta = BlockChest.getMetaWithType(meta, type);
            otherMeta = BlockChest.getMetaWithDirection(otherMeta, facingDirection);
            otherMeta = BlockChest.getMetaWithType(otherMeta, otherType);
            ItemStack[] items1 = this.getAndClearChestInventory(world, x, y, z);
            ItemStack[] items2 = this.getAndClearChestInventory(world, otherChestX, y, otherChestZ);
            this.updateChestBlock(world, x, y, z, meta);
            this.updateChestBlock(world, otherChestX, y, otherChestZ, otherMeta);
            if (facingDirection == Direction.NORTH || facingDirection == Direction.EAST) {
                this.setChestInventory(world, x, y, z, items2);
                this.setChestInventory(world, otherChestX, y, otherChestZ, items1);
            } else {
                this.setChestInventory(world, x, y, z, items1);
                this.setChestInventory(world, otherChestX, y, otherChestZ, items2);
            }
        }
    }

    private ItemStack[] getAndClearChestInventory(World world, int x, int y, int z) {
        TileEntityChest tileEntityChest = (TileEntityChest)world.getBlockTileEntity(x, y, z);
        ItemStack[] items = new ItemStack[tileEntityChest.getSizeInventory()];
        for (int i = 0; i < items.length; ++i) {
            items[i] = tileEntityChest.getStackInSlot(i);
            tileEntityChest.setInventorySlotContents(i, null);
        }
        return items;
    }

    private void setChestInventory(World world, int x, int y, int z, ItemStack[] items) {
        TileEntityChest tileEntityChest = (TileEntityChest)world.getBlockTileEntity(x, y, z);
        for (int i = 0; i < items.length; ++i) {
            tileEntityChest.setInventorySlotContents(i, items[i]);
        }
    }

    private void updateChestBlock(World world, int x, int y, int z, int newMeta) {
        if (!BlockChestLegacy.isLegacyChest(world, x, y, z)) {
            return;
        }
        int legacyChestMeta = world.getBlockMetadata(x, y, z);
        Block oldBlock = world.getBlock(x, y, z);
        Block newBlock = Block.chestPlanksOak;
        if (oldBlock == Block.chestLegacyPainted) {
            newBlock = Block.chestPlanksOakPainted;
            newMeta |= legacyChestMeta << 4;
        }
        world.setBlockAndMetadata(x, y, z, newBlock.id, newMeta);
        world.markBlockNeedsUpdate(x, y, z);
    }
}

