/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockFlower;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;

public class BlockCrops
extends BlockFlower {
    public final int[] growthStageTextures = new int[]{BlockCrops.texCoordToIndex(8, 5), BlockCrops.texCoordToIndex(9, 5), BlockCrops.texCoordToIndex(10, 5), BlockCrops.texCoordToIndex(11, 5), BlockCrops.texCoordToIndex(12, 5), BlockCrops.texCoordToIndex(13, 5), BlockCrops.texCoordToIndex(14, 5), BlockCrops.texCoordToIndex(15, 5)};

    public BlockCrops(String key, int id) {
        super(key, id);
        this.setTickOnLoad(true);
        float f = 0.5f;
        this.setBlockBounds(0.5f - f, 0.0f, 0.5f - f, 0.5f + f, 0.25f, 0.5f + f);
    }

    @Override
    public boolean canThisPlantGrowOnThisBlockID(int i) {
        return i == Block.farmlandDirt.id;
    }

    @Override
    public void updateTick(World world, int x, int y, int z, Random rand) {
        float f;
        int l;
        super.updateTick(world, x, y, z, rand);
        if (world.getBlockLightValue(x, y + 1, z) >= 9 && (l = world.getBlockMetadata(x, y, z)) < 7 && rand.nextInt((int)(100.0f / (f = this.getGrowthRate(world, x, y, z)))) == 0) {
            world.setBlockMetadataWithNotify(x, y, z, ++l);
        }
    }

    public void fertilize(World world, int i, int j, int k) {
        world.setBlockMetadataWithNotify(i, j, k, 7);
    }

    private float getGrowthRate(World world, int i, int j, int k) {
        float f = 1.0f;
        int l = world.getBlockId(i, j, k - 1);
        int i1 = world.getBlockId(i, j, k + 1);
        int j1 = world.getBlockId(i - 1, j, k);
        int k1 = world.getBlockId(i + 1, j, k);
        int l1 = world.getBlockId(i - 1, j, k - 1);
        int i2 = world.getBlockId(i + 1, j, k - 1);
        int j2 = world.getBlockId(i + 1, j, k + 1);
        int k2 = world.getBlockId(i - 1, j, k + 1);
        boolean flag = j1 == this.id || k1 == this.id;
        boolean flag1 = l == this.id || i1 == this.id;
        boolean flag2 = l1 == this.id || i2 == this.id || j2 == this.id || k2 == this.id;
        for (int l2 = i - 1; l2 <= i + 1; ++l2) {
            for (int i3 = k - 1; i3 <= k + 1; ++i3) {
                int j3 = world.getBlockId(l2, j - 1, i3);
                float f1 = 0.0f;
                if (j3 == Block.farmlandDirt.id) {
                    f1 = 1.0f;
                    if (world.getBlockMetadata(l2, j - 1, i3) > 0) {
                        f1 = 3.0f;
                    }
                }
                if (l2 != i || i3 != k) {
                    f1 /= 4.0f;
                }
                f += f1;
            }
        }
        if (flag2 || flag && flag1) {
            f /= 2.0f;
        }
        if (world.seasonManager.getCurrentSeason() != null) {
            f *= world.seasonManager.getCurrentSeason().cropGrowthFactor;
        }
        return f;
    }

    @Override
    public int getBlockTextureFromSideAndMetadata(Side side, int j) {
        if (j < 0 || j > 7) {
            j = 7;
        }
        return this.growthStageTextures[j];
    }

    @Override
    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int x, int y, int z, int meta, TileEntity tileEntity) {
        if (meta != 7) {
            return new ItemStack[]{new ItemStack(Item.seedsWheat)};
        }
        return new ItemStack[]{new ItemStack(Item.seedsWheat, world.rand.nextInt(3) + 1), new ItemStack(Item.wheat)};
    }
}

