/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;

public class BlockLamp
extends Block {
    boolean isActive;

    public BlockLamp(String key, int id, boolean isActivated) {
        super(key, id, Material.stone);
        this.isActive = isActivated;
        this.setTickOnLoad(true);
    }

    @Override
    public int tickRate() {
        return 2;
    }

    @Override
    public void onBlockAdded(World world, int i, int j, int k) {
        super.onBlockAdded(world, i, j, k);
        world.scheduleBlockUpdate(i, j, k, this.id, this.tickRate());
    }

    @Override
    public int getBlockTexture(WorldSource blockAccess, int x, int y, int z, Side side) {
        return this.atlasIndices[side.getId()];
    }

    @Override
    public int getBlockTextureFromSideAndMetadata(Side side, int j) {
        return BlockLamp.texCoordToIndex(5, 12);
    }

    public static int func_21034_c(int i) {
        return ~i & 0xF;
    }

    public static int getMetadataForColour(int i) {
        return ~i & 0xF;
    }

    @Override
    public void updateTick(World world, int x, int y, int z, Random rand) {
        boolean isPoweredByBlock;
        boolean bl = isPoweredByBlock = world.isBlockGettingPowered(x, y, z) || world.isBlockIndirectlyGettingPowered(x, y, z);
        if (this.isActive) {
            if (!isPoweredByBlock) {
                world.setBlockAndMetadataWithNotify(x, y, z, Block.lampIdle.id, world.getBlockMetadata(x, y, z));
            }
        } else if (isPoweredByBlock) {
            world.setBlockAndMetadataWithNotify(x, y, z, Block.lampActive.id, world.getBlockMetadata(x, y, z));
        }
    }

    @Override
    public void onNeighborBlockChange(World world, int x, int y, int z, int blockId) {
        world.scheduleBlockUpdate(x, y, z, this.id, this.tickRate());
    }

    @Override
    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int x, int y, int z, int meta, TileEntity tileEntity) {
        return new ItemStack[]{new ItemStack(Block.lampIdle, 1, meta)};
    }
}

