/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.entity.animal.EntityFireflyCluster;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.enums.EnumFireflyColor;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;

public class BlockLanternFirefly
extends Block {
    public Item item;
    private final EnumFireflyColor color;

    public BlockLanternFirefly(String key, int id, EnumFireflyColor colour) {
        super(key, id, Material.glass);
        this.color = colour;
        this.setBlockBounds(0.3125f, 0.0f, 0.3125f, 0.6875f, 0.5f, 0.6875f);
    }

    @Override
    public AABB getCollisionBoundingBoxFromPool(World world, int x, int y, int z) {
        int metadata = world.getBlockMetadata(x, y, z);
        float offset = 0.0f;
        if (metadata == 1) {
            offset = 0.3875f;
        }
        return AABB.getBoundingBoxFromPool((float)x + 0.3125f, (float)y + offset, (float)z + 0.3125f, (float)(x + 1) - 0.3125f, (float)y + 0.5f + offset, (float)(z + 1) - 0.3125f);
    }

    @Override
    public AABB getSelectedBoundingBoxFromPool(World world, int x, int y, int z) {
        return this.getCollisionBoundingBoxFromPool(world, x, y, z);
    }

    @Override
    public void setBlockBoundsBasedOnState(World world, int x, int y, int z) {
        AABB aabb = this.getCollisionBoundingBoxFromPool(world, x, y, z);
        this.minX = aabb.minX - (double)x;
        this.minY = aabb.minY - (double)y;
        this.minZ = aabb.minZ - (double)z;
        this.maxX = aabb.maxX - (double)x;
        this.maxY = aabb.maxY - (double)y;
        this.maxZ = aabb.maxZ - (double)z;
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public void randomDisplayTick(World world, int x, int y, int z, Random rand) {
        if (rand.nextInt(3) == 0) {
            world.spawnParticle(this.color.getParticleName(), (float)x + rand.nextFloat(), (float)y + rand.nextFloat(), (float)z + rand.nextFloat(), 0.0, 0.0, 0.0);
        }
    }

    @Override
    public boolean blockActivated(World world, int x, int y, int z, EntityPlayer player) {
        world.setBlockRaw(x, y, z, 0);
        world.playSoundAtEntity(player, "random.pop", 0.2f, 0.5f);
        if (!world.isClientSide) {
            world.dropItem(x, y, z, new ItemStack(this.item, 1, 0));
        }
        return true;
    }

    @Override
    public void onBlockAdded(World world, int x, int y, int z) {
        if (world.isBlockNormalCube(x, y + 1, z) || Block.hasTag(world.getBlockId(x, y + 1, z), BlockTags.CAN_HANG_OFF)) {
            world.setBlockMetadataWithNotify(x, y, z, 1);
        } else {
            world.setBlockMetadataWithNotify(x, y, z, 0);
        }
    }

    @Override
    public boolean canPlaceBlockAt(World world, int x, int y, int z) {
        if (world.isBlockNormalCube(x, y + 1, z) || Block.hasTag(world.getBlockId(x, y + 1, z), BlockTags.CAN_HANG_OFF)) {
            return true;
        }
        return world.canPlaceOnSurfaceOfBlock(x, y - 1, z);
    }

    @Override
    public void onNeighborBlockChange(World world, int x, int y, int z, int blockId) {
        if (!this.canBlockStay(world, x, y, z)) {
            this.dropBlockWithCause(world, EnumDropCause.WORLD, x, y, z, world.getBlockMetadata(x, y, z), null);
            world.setBlockWithNotify(x, y, z, 0);
        }
    }

    @Override
    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int x, int y, int z, int meta, TileEntity tileEntity) {
        switch (dropCause) {
            case PICK_BLOCK: 
            case SILK_TOUCH: 
            case WORLD: {
                return new ItemStack[]{new ItemStack(this.item)};
            }
        }
        return null;
    }

    @Override
    public boolean canBlockStay(World world, int x, int y, int z) {
        int meta = world.getBlockMetadata(x, y, z);
        if (meta == 1) {
            return world.isBlockNormalCube(x, y + 1, z) || Block.hasTag(world.getBlockId(x, y + 1, z), BlockTags.CAN_HANG_OFF);
        }
        return world.canPlaceOnSurfaceOfBlock(x, y - 1, z);
    }

    @Override
    public void onBlockDestroyedByPlayer(World world, int x, int y, int z, int meta, EntityPlayer player, Item item) {
        if (item != null && item.isSilkTouch()) {
            return;
        }
        if (!world.isClientSide) {
            EntityFireflyCluster entity = new EntityFireflyCluster(world);
            entity.setColor(this.color);
            entity.setFireflyCount(1);
            entity.setClusterSize(0);
            entity.setSizeBasedOnClusterSize(entity.getClusterSize());
            entity.setPos((float)x + 0.5f + (world.rand.nextFloat() - 0.5f) * 0.5f, (float)y + world.rand.nextFloat() * 0.5f, (float)z + 0.5f + (world.rand.nextFloat() - 0.5f) * 0.5f);
            world.entityJoinedWorld(entity);
        }
    }

    public void setItem(Item item) {
        this.item = item;
    }
}

