/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.BlockTransparent;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.sound.SoundType;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;

public class BlockPortal
extends BlockTransparent {
    public int targetDimension;
    public int portalFrameId;
    public int portalTriggerId;

    public BlockPortal(String key, int id, int targetDimension, int portalMaterialId, int portalTriggerId) {
        super(key, id, Material.portal, false);
        this.targetDimension = targetDimension;
        this.portalFrameId = portalMaterialId;
        this.portalTriggerId = portalTriggerId;
    }

    @Override
    public AABB getCollisionBoundingBoxFromPool(World world, int x, int y, int z) {
        return null;
    }

    @Override
    public void setBlockBoundsBasedOnState(World world, int x, int y, int z) {
        int meta = world.getBlockMetadata(x, y, z);
        if ((meta & 1) > 0) {
            float f1 = 0.125f;
            float f3 = 0.5f;
            this.setBlockBounds(0.5f - f1, 0.0f, 0.5f - f3, 0.5f + f1, 1.0f, 0.5f + f3);
        } else {
            float f = 0.5f;
            float f2 = 0.125f;
            this.setBlockBounds(0.5f - f, 0.0f, 0.5f - f2, 0.5f + f, 1.0f, 0.5f + f2);
        }
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public boolean renderFullbright() {
        return true;
    }

    public int[] getPortalDims(World world, int x, int y, int z, boolean expectMiddle) {
        return this.getPortalDims(world, x, y, z, false, expectMiddle);
    }

    public int[] getPortalDims(World world, int x, int y, int z, boolean swapOrientation, boolean expectMiddle) {
        int id;
        int ry;
        int ra;
        int rz;
        int rx;
        int ry2;
        int maxDims = 32;
        int ox = x;
        int oy = y;
        int oz = z;
        int maxBoundA = 0;
        int maxBoundY = 0;
        boolean foundBottom = false;
        boolean foundOrientation = false;
        boolean orientation = false;
        if (world.dimension.portalBlockId != -1 && world.dimension.portalBlockId != this.id) {
            return null;
        }
        for (ry2 = 0; ry2 > -maxDims; --ry2) {
            if (world.getBlockId(x, y + ry2, z) != this.portalFrameId) continue;
            foundBottom = true;
            y += ry2;
            break;
        }
        if (!foundBottom) {
            return null;
        }
        ++y;
        if (!swapOrientation) {
            for (rx = 0; rx > -maxDims; --rx) {
                if (world.getBlockId(x + rx, y, z) != this.portalFrameId) continue;
                foundOrientation = true;
                orientation = false;
                x += rx;
                break;
            }
            if (!foundOrientation) {
                for (rz = 0; rz > -maxDims; --rz) {
                    if (world.getBlockId(x, y, z + rz) != this.portalFrameId) continue;
                    foundOrientation = true;
                    orientation = true;
                    z += rz;
                    break;
                }
            }
        } else {
            for (rz = 0; rz > -maxDims; --rz) {
                if (world.getBlockId(x, y, z + rz) != this.portalFrameId) continue;
                foundOrientation = true;
                orientation = true;
                z += rz;
                break;
            }
            if (!foundOrientation) {
                for (rx = 0; rx > -maxDims; --rx) {
                    if (world.getBlockId(x + rx, y, z) != this.portalFrameId) continue;
                    foundOrientation = true;
                    orientation = false;
                    x += rx;
                    break;
                }
            }
        }
        if (!foundOrientation) {
            return null;
        }
        if (!orientation) {
            for (rx = 1; rx < maxDims; ++rx) {
                if (world.getBlockId(x + rx, y, z) != this.portalFrameId) continue;
                maxBoundA = rx;
                break;
            }
        } else {
            for (rz = 1; rz < maxDims; ++rz) {
                if (world.getBlockId(x, y, z + rz) != this.portalFrameId) continue;
                maxBoundA = rz;
                break;
            }
        }
        if (maxBoundA == 0) {
            return swapOrientation ? null : this.getPortalDims(world, ox, oy, oz, true, expectMiddle);
        }
        --y;
        for (ry2 = 1; ry2 < maxDims; ++ry2) {
            if (y + ry2 >= world.getHeightBlocks()) {
                return swapOrientation ? null : this.getPortalDims(world, ox, oy, oz, true, expectMiddle);
            }
            if (world.getBlockId(x + (!orientation ? 1 : 0), y + ry2, z + (orientation ? 1 : 0)) != this.portalFrameId) continue;
            maxBoundY = ry2;
            break;
        }
        if (maxBoundY == 0) {
            return swapOrientation ? null : this.getPortalDims(world, ox, oy, oz, true, expectMiddle);
        }
        for (ra = 0; ra <= maxBoundA; ++ra) {
            for (ry = 0; ry <= maxBoundY; ++ry) {
                if (!(ra == 0 || ra == maxBoundA || ry == 0 || ry == maxBoundY ? world.getBlockId(x + (!orientation ? ra : 0), y + ry, z + (orientation ? ra : 0)) != this.portalFrameId : (id = world.getBlockId(x + (!orientation ? ra : 0), y + ry, z + (orientation ? ra : 0))) != 0 && id != this.portalTriggerId && id != this.id)) continue;
                return swapOrientation ? null : this.getPortalDims(world, ox, oy, oz, true, expectMiddle);
            }
        }
        if (expectMiddle) {
            for (ra = 1; ra < maxBoundA; ++ra) {
                for (ry = 1; ry < maxBoundY; ++ry) {
                    id = world.getBlockId(x + (!orientation ? ra : 0), y + ry, z + (orientation ? ra : 0));
                    if (id == this.id) continue;
                    return swapOrientation ? null : this.getPortalDims(world, ox, oy, oz, true, true);
                }
            }
        }
        return new int[]{orientation ? 1 : 0, x, y, z, maxBoundA, maxBoundY};
    }

    public boolean tryToCreatePortal(World world, int x, int y, int z) {
        int[] bounds = this.getPortalDims(world, x, y, z, false);
        if (bounds == null) {
            return false;
        }
        x = bounds[1];
        y = bounds[2];
        z = bounds[3];
        world.editingBlocks = true;
        for (int ra = 1; ra < bounds[4]; ++ra) {
            for (int ry = 1; ry < bounds[5]; ++ry) {
                world.setBlockAndMetadata(x + (bounds[0] == 0 ? ra : 0), y + ry, z + (bounds[0] == 1 ? ra : 0), this.id, bounds[0] & 1);
            }
        }
        world.setBlockMetadata(x + (bounds[0] == 0 ? 1 : 0), y + 1, z + (bounds[0] == 1 ? 1 : 0), bounds[0] & 0xF | 2);
        world.markBlocksDirty(x + (bounds[0] == 0 ? 1 : 0), y + 1, z + (bounds[0] == 1 ? 1 : 0), x + (bounds[0] == 0 ? bounds[4] : 0), y + bounds[5], z + (bounds[0] == 1 ? bounds[4] : 0));
        world.editingBlocks = false;
        return true;
    }

    @Override
    public void onNeighborBlockChange(World world, int x, int y, int z, int blockId) {
        int[] bounds = this.getPortalDims(world, x, y, z, true);
        if (bounds == null) {
            world.setBlockWithNotify(x, y, z, 0);
            return;
        }
    }

    @Override
    public boolean shouldSideBeRendered(WorldSource blockAccess, int x, int y, int z, int side) {
        boolean flag5;
        if (blockAccess.getBlockId(x, y, z) == this.id) {
            return false;
        }
        boolean flag = blockAccess.getBlockId(x - 1, y, z) == this.id && blockAccess.getBlockId(x - 2, y, z) != this.id;
        boolean flag1 = blockAccess.getBlockId(x + 1, y, z) == this.id && blockAccess.getBlockId(x + 2, y, z) != this.id;
        boolean flag2 = blockAccess.getBlockId(x, y, z - 1) == this.id && blockAccess.getBlockId(x, y, z - 2) != this.id;
        boolean flag3 = blockAccess.getBlockId(x, y, z + 1) == this.id && blockAccess.getBlockId(x, y, z + 2) != this.id;
        boolean flag4 = flag || flag1;
        boolean bl = flag5 = flag2 || flag3;
        if (flag4 && side == 4) {
            return true;
        }
        if (flag4 && side == 5) {
            return true;
        }
        if (flag5 && side == 2) {
            return true;
        }
        return flag5 && side == 3;
    }

    @Override
    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int x, int y, int z, int meta, TileEntity tileEntity) {
        return null;
    }

    @Override
    public int getRenderBlockPass() {
        return 1;
    }

    @Override
    public void onEntityCollidedWithBlock(World world, int x, int y, int z, Entity entity) {
        if (entity.vehicle == null && entity.passenger == null) {
            entity.handlePortal(this.id);
        }
    }

    @Override
    public void randomDisplayTick(World world, int x, int y, int z, Random rand) {
        int meta = world.getBlockMetadata(x, y, z);
        if ((meta & 2) > 0 && rand.nextInt(20) == 0) {
            world.playSoundEffect(SoundType.WORLD_SOUNDS, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "portal.portal", 0.5f, rand.nextFloat() * 0.4f + 0.8f);
        }
        for (int l = 0; l < 4; ++l) {
            double d = (float)x + rand.nextFloat();
            double d1 = (float)y + rand.nextFloat();
            double d2 = (float)z + rand.nextFloat();
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = 0.0;
            int i1 = rand.nextInt(2) * 2 - 1;
            d3 = ((double)rand.nextFloat() - 0.5) * 0.5;
            d4 = ((double)rand.nextFloat() - 0.5) * 0.5;
            d5 = ((double)rand.nextFloat() - 0.5) * 0.5;
            if (world.getBlockId(x - 1, y, z) == this.id || world.getBlockId(x + 1, y, z) == this.id) {
                d2 = (double)z + 0.5 + 0.25 * (double)i1;
                d5 = rand.nextFloat() * 2.0f * (float)i1;
            } else {
                d = (double)x + 0.5 + 0.25 * (double)i1;
                d3 = rand.nextFloat() * 2.0f * (float)i1;
            }
            world.spawnParticle("portal", d, d1, d2, d3, d4, d5);
        }
    }
}

