/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockTorch;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.logic.RedstoneUpdateInfo;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.sound.SoundType;
import net.minecraft.core.util.helper.Color;
import net.minecraft.core.util.helper.Colors;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;

public class BlockRedstoneTorch
extends BlockTorch {
    private boolean torchActive;
    private static List torchUpdates = new ArrayList();

    @Override
    public int getBlockTextureFromSideAndMetadata(Side side, int meta) {
        if (side == Side.TOP) {
            return Block.wireRedstone.getBlockTextureFromSideAndMetadata(side, meta);
        }
        return super.getBlockTextureFromSideAndMetadata(side, meta);
    }

    private boolean checkForBurnout(World world, int i, int j, int k, boolean flag) {
        if (flag) {
            torchUpdates.add(new RedstoneUpdateInfo(i, j, k, world.getWorldTime()));
        }
        int l = 0;
        for (int i1 = 0; i1 < torchUpdates.size(); ++i1) {
            RedstoneUpdateInfo redstoneupdateinfo = (RedstoneUpdateInfo)torchUpdates.get(i1);
            if (redstoneupdateinfo.getXCoord() != i || redstoneupdateinfo.getYCoord() != j || redstoneupdateinfo.getZCoord() != k || ++l < 8) continue;
            return true;
        }
        return false;
    }

    protected BlockRedstoneTorch(String key, int id, boolean flag) {
        super(key, id);
        this.torchActive = flag;
        this.setTickOnLoad(true);
    }

    @Override
    public int tickRate() {
        return 2;
    }

    @Override
    public void onBlockAdded(World world, int i, int j, int k) {
        if (world.getBlockMetadata(i, j, k) == 0) {
            super.onBlockAdded(world, i, j, k);
        }
        if (this.torchActive) {
            world.notifyBlocksOfNeighborChange(i, j - 1, k, this.id);
            world.notifyBlocksOfNeighborChange(i, j + 1, k, this.id);
            world.notifyBlocksOfNeighborChange(i - 1, j, k, this.id);
            world.notifyBlocksOfNeighborChange(i + 1, j, k, this.id);
            world.notifyBlocksOfNeighborChange(i, j, k - 1, this.id);
            world.notifyBlocksOfNeighborChange(i, j, k + 1, this.id);
        }
    }

    @Override
    public void onBlockRemoval(World world, int x, int y, int z) {
        if (this.torchActive) {
            world.notifyBlocksOfNeighborChange(x, y - 1, z, this.id);
            world.notifyBlocksOfNeighborChange(x, y + 1, z, this.id);
            world.notifyBlocksOfNeighborChange(x - 1, y, z, this.id);
            world.notifyBlocksOfNeighborChange(x + 1, y, z, this.id);
            world.notifyBlocksOfNeighborChange(x, y, z - 1, this.id);
            world.notifyBlocksOfNeighborChange(x, y, z + 1, this.id);
        }
    }

    @Override
    public boolean isPoweringTo(WorldSource blockAccess, int x, int y, int z, int side) {
        if (!this.torchActive) {
            return false;
        }
        int i1 = blockAccess.getBlockMetadata(x, y, z);
        if (i1 == 5 && side == 1) {
            return false;
        }
        if (i1 == 3 && side == 3) {
            return false;
        }
        if (i1 == 4 && side == 2) {
            return false;
        }
        if (i1 == 1 && side == 5) {
            return false;
        }
        return i1 != 2 || side != 4;
    }

    private boolean isPoweredByBlock(World world, int i, int j, int k) {
        int l = world.getBlockMetadata(i, j, k);
        if (l == 5 && world.isBlockIndirectlyProvidingPowerTo(i, j - 1, k, 0)) {
            return true;
        }
        if (l == 3 && world.isBlockIndirectlyProvidingPowerTo(i, j, k - 1, 2)) {
            return true;
        }
        if (l == 4 && world.isBlockIndirectlyProvidingPowerTo(i, j, k + 1, 3)) {
            return true;
        }
        if (l == 1 && world.isBlockIndirectlyProvidingPowerTo(i - 1, j, k, 4)) {
            return true;
        }
        return l == 2 && world.isBlockIndirectlyProvidingPowerTo(i + 1, j, k, 5);
    }

    @Override
    public void updateTick(World world, int x, int y, int z, Random rand) {
        boolean flag = this.isPoweredByBlock(world, x, y, z);
        while (torchUpdates.size() > 0 && world.getWorldTime() - ((RedstoneUpdateInfo)torchUpdates.get(0)).getUpdateTime() > 100L) {
            torchUpdates.remove(0);
        }
        if (this.torchActive) {
            if (flag) {
                world.setBlockAndMetadataWithNotify(x, y, z, Block.torchRedstoneIdle.id, world.getBlockMetadata(x, y, z));
                if (this.checkForBurnout(world, x, y, z, true)) {
                    world.playSoundEffect(SoundType.WORLD_SOUNDS, (float)x + 0.5f, (float)y + 0.5f, (float)z + 0.5f, "random.fizz", 0.5f, 2.6f + (world.rand.nextFloat() - world.rand.nextFloat()) * 0.8f);
                    for (int l = 0; l < 5; ++l) {
                        double d = (double)x + rand.nextDouble() * 0.6 + 0.2;
                        double d1 = (double)y + rand.nextDouble() * 0.6 + 0.2;
                        double d2 = (double)z + rand.nextDouble() * 0.6 + 0.2;
                        world.spawnParticle("smoke", d, d1, d2, 0.0, 0.0, 0.0);
                    }
                }
            }
        } else if (!flag && !this.checkForBurnout(world, x, y, z, false)) {
            world.setBlockAndMetadataWithNotify(x, y, z, Block.torchRedstoneActive.id, world.getBlockMetadata(x, y, z));
        }
    }

    @Override
    public void onNeighborBlockChange(World world, int x, int y, int z, int blockId) {
        super.onNeighborBlockChange(world, x, y, z, blockId);
        world.scheduleBlockUpdate(x, y, z, this.id, this.tickRate());
    }

    @Override
    public boolean isIndirectlyPoweringTo(World world, int x, int y, int z, int side) {
        if (side == 0) {
            return this.isPoweringTo(world, x, y, z, side);
        }
        return false;
    }

    @Override
    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int x, int y, int z, int meta, TileEntity tileEntity) {
        return new ItemStack[]{new ItemStack(Block.torchRedstoneActive)};
    }

    @Override
    public boolean canProvidePower() {
        return true;
    }

    @Override
    public void randomDisplayTick(World world, int x, int y, int z, Random rand) {
        if (!this.torchActive) {
            return;
        }
        int meta = world.getBlockMetadata(x, y, z);
        double px = (double)((float)x + 0.5f) + (double)(rand.nextFloat() - 0.5f) * 0.2;
        double py = (double)((float)y + 0.7f) + (double)(rand.nextFloat() - 0.5f) * 0.2;
        double pz = (double)((float)z + 0.5f) + (double)(rand.nextFloat() - 0.5f) * 0.2;
        double verticalOffset = 0.22;
        double horizontalOffset = 0.27;
        Color color = Colors.allRedstoneColors[10];
        if (color == null) {
            return;
        }
        float red = (float)color.getRed() / 255.0f;
        float green = (float)color.getGreen() / 255.0f;
        float blue = (float)color.getBlue() / 255.0f;
        if (meta == 1) {
            world.spawnParticle("reddust", px - horizontalOffset, py + verticalOffset, pz, red, green, blue);
        } else if (meta == 2) {
            world.spawnParticle("reddust", px + horizontalOffset, py + verticalOffset, pz, red, green, blue);
        } else if (meta == 3) {
            world.spawnParticle("reddust", px, py + verticalOffset, pz - horizontalOffset, red, green, blue);
        } else if (meta == 4) {
            world.spawnParticle("reddust", px, py + verticalOffset, pz + horizontalOffset, red, green, blue);
        } else {
            world.spawnParticle("reddust", px, py, pz, red, green, blue);
        }
    }
}

