/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.achievement.AchievementList;
import net.minecraft.core.achievement.stat.StatList;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.world.World;
import net.minecraft.core.world.chunk.Chunk;

public class BlockStone
extends Block {
    public Block cobblestone;

    public BlockStone(String key, int id) {
        super(key, id, Material.stone);
    }

    @Override
    public void harvestBlock(World world, EntityPlayer player, int x, int y, int z, int meta, TileEntity tileEntity) {
        super.harvestBlock(world, player, x, y, z, meta, tileEntity);
        if (player.getStat(StatList.mineBlockStatArray[Block.basalt.id]) > 0 && player.getStat(StatList.mineBlockStatArray[Block.limestone.id]) > 0 && player.getStat(StatList.mineBlockStatArray[Block.granite.id]) > 0) {
            player.triggerAchievement(AchievementList.COLLECT_STONE);
        }
    }

    @Override
    public void randomDisplayTick(World world, int x, int y, int z, Random rand) {
        double x1 = x;
        double y1 = y;
        double z1 = z;
        Chunk chunk = world.getChunkFromBlockCoords(x, z);
        if (y <= 32 && chunk.getChunkRandom(987234911L).nextInt(10) == 0 && world.getBlockId(x, y - 1, z) == 0 && rand.nextInt(50) == 0) {
            world.spawnParticle("slimechunk", x1, y1, z1, 0.0, 0.0, 0.0);
        }
    }

    public void setCobblestoneType(Block block) {
        this.cobblestone = block;
    }

    @Override
    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int x, int y, int z, int meta, TileEntity tileEntity) {
        switch (dropCause) {
            case WORLD: 
            case EXPLOSION: 
            case PROPER_TOOL: {
                return new ItemStack[]{new ItemStack(this.cobblestone)};
            }
            case PICK_BLOCK: 
            case SILK_TOUCH: {
                return new ItemStack[]{new ItemStack(this)};
            }
        }
        return null;
    }
}

