/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block.entity;

import com.mojang.nbt.CompoundTag;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.world.World;

public class TileEntityNote
extends TileEntity {
    public byte note = 0;
    public boolean previousRedstoneState = false;

    @Override
    public void writeToNBT(CompoundTag nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.putByte("note", this.note);
    }

    @Override
    public void readFromNBT(CompoundTag nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.note = nbttagcompound.getByte("note");
        if (this.note < 0) {
            this.note = 0;
        }
        if (this.note > 24) {
            this.note = (byte)24;
        }
    }

    public void changePitch() {
        this.note = (byte)((this.note + 1) % 25);
        this.onInventoryChanged();
    }

    public void triggerNote(World world, int x, int y, int z) {
        if (world.isBlockOpaqueCube(x, y + 1, z)) {
            return;
        }
        Material material = world.getBlockMaterial(x, y - 1, z);
        int byte0 = 0;
        if (material == Material.stone) {
            byte0 = 1;
        }
        if (material == Material.sand) {
            byte0 = 2;
        }
        if (material == Material.glass) {
            byte0 = 3;
        }
        if (material == Material.wood) {
            byte0 = 4;
        }
        world.playNoteAt(x, y, z, byte0, this.note);
    }
}

