/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block.entity;

import com.mojang.nbt.CompoundTag;
import com.mojang.nbt.ListTag;
import java.util.HashMap;
import java.util.Random;
import net.minecraft.core.WeightedRandomBag;
import net.minecraft.core.WeightedRandomLootObject;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockChest;
import net.minecraft.core.block.BlockTrommel;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.crafting.LookupFuelFurnace;
import net.minecraft.core.entity.monster.EntitySlime;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.player.inventory.IInventory;
import net.minecraft.core.util.helper.MathHelper;

public class TileEntityTrommel
extends TileEntity
implements IInventory {
    private ItemStack[] itemStacks;
    private ItemStack[] trommellableItems = new ItemStack[]{new ItemStack(Block.dirt), new ItemStack(Block.sand), new ItemStack(Block.gravel), new ItemStack(Block.dirtScorchedRich), new ItemStack(Block.blockClay), new ItemStack(Block.soulsand)};
    public int burnTime = 0;
    public int currentItemBurnTime = 0;
    public int itemPopTime = 0;
    private final int maxBurnTime;
    private int nextToSieve = 1;
    private final Random rand;
    private static final WeightedRandomBag<WeightedRandomLootObject> trommelDropsDirt = new WeightedRandomBag();
    private static final WeightedRandomBag<WeightedRandomLootObject> trommelDropsGravel;
    private static final WeightedRandomBag<WeightedRandomLootObject> trommelDropsClay;
    private static final WeightedRandomBag<WeightedRandomLootObject> trommelDropsSand;
    private static final WeightedRandomBag<WeightedRandomLootObject> trommelDropsRichDirt;
    private static final WeightedRandomBag<WeightedRandomLootObject> trommelDropsSoulSand;

    public TileEntityTrommel() {
        this.itemStacks = new ItemStack[5];
        this.maxBurnTime = 50;
        this.rand = new Random();
    }

    @Override
    public int getSizeInventory() {
        return this.itemStacks.length;
    }

    @Override
    public ItemStack getStackInSlot(int i) {
        return this.itemStacks[i];
    }

    @Override
    public ItemStack decrStackSize(int i, int j) {
        if (this.itemStacks[i] != null) {
            if (this.itemStacks[i].stackSize <= j) {
                ItemStack itemstack = this.itemStacks[i];
                this.itemStacks[i] = null;
                return itemstack;
            }
            ItemStack itemstack1 = this.itemStacks[i].splitStack(j);
            if (this.itemStacks[i].stackSize <= 0) {
                this.itemStacks[i] = null;
            }
            return itemstack1;
        }
        return null;
    }

    @Override
    public void setInventorySlotContents(int i, ItemStack itemstack) {
        this.itemStacks[i] = itemstack;
        if (itemstack != null && itemstack.stackSize > this.getInventoryStackLimit()) {
            itemstack.stackSize = this.getInventoryStackLimit();
        }
    }

    @Override
    public String getInvName() {
        return "Trommel";
    }

    @Override
    public void readFromNBT(CompoundTag nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        ListTag nbttaglist = nbttagcompound.getList("Items");
        this.itemStacks = new ItemStack[this.getSizeInventory()];
        for (int i = 0; i < nbttaglist.tagCount(); ++i) {
            CompoundTag nbttagcompound1 = (CompoundTag)nbttaglist.tagAt(i);
            byte byte0 = nbttagcompound1.getByte("Slot");
            if (byte0 < 0 || byte0 >= this.itemStacks.length) continue;
            this.itemStacks[byte0] = ItemStack.readItemStackFromNbt(nbttagcompound1);
        }
        this.burnTime = nbttagcompound.getShort("BurnTime");
        this.itemPopTime = nbttagcompound.getShort("CookTime");
        this.currentItemBurnTime = this.getItemBurnTime(this.itemStacks[1]);
    }

    @Override
    public void writeToNBT(CompoundTag nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.putShort("BurnTime", (short)this.burnTime);
        nbttagcompound.putShort("CookTime", (short)this.itemPopTime);
        ListTag nbttaglist = new ListTag();
        for (int i = 0; i < this.itemStacks.length; ++i) {
            if (this.itemStacks[i] == null) continue;
            CompoundTag nbttagcompound1 = new CompoundTag();
            nbttagcompound1.putByte("Slot", (byte)i);
            this.itemStacks[i].writeToNBT(nbttagcompound1);
            nbttaglist.addTag(nbttagcompound1);
        }
        nbttagcompound.put("Items", nbttaglist);
    }

    @Override
    public int getInventoryStackLimit() {
        return 64;
    }

    public float getCookProgressPercent(int i) {
        return (float)this.itemPopTime / (float)this.maxBurnTime * (float)i;
    }

    public int getBurnTimeRemainingScaled(int i) {
        if (this.currentItemBurnTime == 0) {
            this.currentItemBurnTime = this.maxBurnTime;
        }
        return this.burnTime * i / this.currentItemBurnTime;
    }

    public boolean isBurning() {
        return this.burnTime > 0;
    }

    @Override
    public void updateEntity() {
        if (this.nextToSieve > 4) {
            this.nextToSieve = 1;
        }
        boolean isBurning = this.burnTime > 0;
        boolean flag1 = false;
        if (isBurning) {
            --this.burnTime;
        }
        if (!this.worldObj.isClientSide) {
            if (this.worldObj.getBlockId(this.xCoord, this.yCoord, this.zCoord) == Block.trommelIdle.id && this.currentItemBurnTime == 0 && this.itemStacks[0] == null && this.itemStacks[4] != null && this.itemStacks[4].itemID == Block.netherrack.id) {
                --this.itemStacks[4].stackSize;
                if (this.itemStacks[4].stackSize <= 0) {
                    this.itemStacks[4] = null;
                }
                BlockTrommel.updateTrommelBlockState(true, this.worldObj, this.xCoord, this.yCoord, this.zCoord);
                flag1 = true;
            }
            if (!this.canProduce(this.nextToSieve)) {
                this.nextToSieve = (this.nextToSieve + 1) % 4;
            }
            if (this.burnTime == 0 && this.canProduce(this.nextToSieve)) {
                this.currentItemBurnTime = this.burnTime = this.getItemBurnTime(this.itemStacks[4]);
                if (this.burnTime > 0) {
                    flag1 = true;
                    if (this.itemStacks[4] != null) {
                        if (this.itemStacks[4].getItem() == Item.bucketLava) {
                            this.itemStacks[4] = new ItemStack(Item.bucket);
                        } else {
                            --this.itemStacks[4].stackSize;
                            if (this.itemStacks[4].stackSize <= 0) {
                                this.itemStacks[4] = null;
                            }
                        }
                    }
                }
            }
            if (this.isBurning() && this.canProduce(this.nextToSieve)) {
                ++this.itemPopTime;
                if (this.itemPopTime >= this.maxBurnTime) {
                    this.itemPopTime = 0;
                    this.sieveItem(this.nextToSieve);
                    this.nextToSieve = (this.nextToSieve + 1) % 4;
                    flag1 = true;
                }
            } else {
                this.itemPopTime = 0;
            }
            if (isBurning != this.burnTime > 0) {
                flag1 = true;
                BlockTrommel.updateTrommelBlockState(this.burnTime > 0, this.worldObj, this.xCoord, this.yCoord, this.zCoord);
            }
        }
        if (flag1) {
            this.onInventoryChanged();
        }
    }

    private boolean canProduce(int slotIndex) {
        return this.itemStacks[slotIndex] != null && this.canItemBeTrommeled(this.itemStacks[slotIndex]);
    }

    public void sieveItem(int slotIndex) {
        if (!this.canProduce(slotIndex)) {
            return;
        }
        ItemStack itemResult = this.getItemResult(this.itemStacks[slotIndex]);
        --this.itemStacks[slotIndex].stackSize;
        if (this.itemStacks[slotIndex].stackSize <= 0) {
            this.itemStacks[slotIndex] = null;
        }
        if (itemResult != null) {
            int xOffset = 0;
            int zOffset = 0;
            int meta = this.worldObj.getBlockMetadata(this.xCoord, this.yCoord, this.zCoord) & 7;
            if (meta == 2) {
                xOffset = -1;
            } else if (meta == 5) {
                zOffset = -1;
            } else if (meta == 3) {
                xOffset = 1;
            } else if (meta == 4) {
                zOffset = 1;
            }
            int adjacentId = this.worldObj.getBlockId(this.xCoord + xOffset, this.yCoord, this.zCoord + zOffset);
            IInventory chest = null;
            if (Block.blocksList[adjacentId] instanceof BlockChest) {
                chest = BlockChest.getInventory(this.worldObj, this.xCoord + xOffset, this.yCoord, this.zCoord + zOffset);
            }
            if (chest != null) {
                ItemStack slot;
                int i;
                for (i = 0; i < chest.getSizeInventory(); ++i) {
                    slot = chest.getStackInSlot(i);
                    if (slot == null || slot.itemID != itemResult.itemID || slot.getMetadata() != itemResult.getMetadata()) continue;
                    while (slot.stackSize + 1 <= slot.getMaxStackSize()) {
                        ++slot.stackSize;
                        chest.setInventorySlotContents(i, slot);
                        if (itemResult.stackSize <= 0) {
                            return;
                        }
                        --itemResult.stackSize;
                    }
                }
                if (itemResult.stackSize <= 0) {
                    return;
                }
                for (i = 0; i < chest.getSizeInventory(); ++i) {
                    slot = chest.getStackInSlot(i);
                    if (slot != null) continue;
                    chest.setInventorySlotContents(i, itemResult);
                    return;
                }
            }
            if (itemResult.stackSize > 0) {
                this.worldObj.dropItem(this.xCoord, this.yCoord, this.zCoord, itemResult);
            }
        }
        if (this.rand.nextInt(4000) == 0) {
            float f = 0.125f;
            float f1 = 0.125f;
            EntitySlime entityslime = new EntitySlime(this.worldObj);
            entityslime.setSlimeSize(1);
            entityslime.moveTo((double)this.xCoord + (double)f, (double)this.yCoord + 1.0, (double)this.zCoord + (double)f1, this.rand.nextFloat() * 360.0f, 0.0f);
            float f3 = 0.05f;
            entityslime.xd = (float)this.rand.nextGaussian() * f3;
            entityslime.yd = (float)this.rand.nextGaussian() * f3 + 0.2f;
            entityslime.zd = (float)this.rand.nextGaussian() * f3;
            this.worldObj.entityJoinedWorld(entityslime);
        }
    }

    private ItemStack getItemResult(ItemStack slotItem) {
        if (this.rand.nextInt(2) != 0) {
            return null;
        }
        int i = slotItem.getItem().id;
        if (i == Block.dirt.id || i == Block.dirtScorched.id || i == Block.grass.id || i == Block.grassRetro.id || i == Block.pathDirt.id || i == Block.farmlandDirt.id) {
            return trommelDropsDirt.getRandom().getItemStack();
        }
        if (i == Block.sand.id) {
            return trommelDropsSand.getRandom().getItemStack();
        }
        if (i == Block.gravel.id) {
            return trommelDropsGravel.getRandom().getItemStack();
        }
        if (i == Block.blockClay.id) {
            return trommelDropsClay.getRandom().getItemStack();
        }
        if (i == Block.dirtScorchedRich.id) {
            return trommelDropsRichDirt.getRandom().getItemStack();
        }
        if (i == Block.soulsand.id) {
            return trommelDropsSoulSand.getRandom().getItemStack();
        }
        return null;
    }

    private boolean canItemBeTrommeled(ItemStack itemstack) {
        if (itemstack == null) {
            return false;
        }
        int i = itemstack.getItem().id;
        if (i == Block.dirt.id || i == Block.grass.id || i == Block.grassRetro.id || i == Block.pathDirt.id || i == Block.farmlandDirt.id) {
            return true;
        }
        if (i == Block.sand.id) {
            return true;
        }
        if (i == Block.dirtScorchedRich.id) {
            return true;
        }
        if (i == Block.dirtScorched.id) {
            return true;
        }
        if (i == Block.soulsand.id) {
            return true;
        }
        return i == Block.gravel.id;
    }

    private int getItemBurnTime(ItemStack itemStack) {
        if (itemStack == null) {
            return 0;
        }
        return LookupFuelFurnace.instance.getFuelYield(itemStack.getItem().id);
    }

    @Override
    public boolean canInteractWith(EntityPlayer entityplayer) {
        if (this.worldObj.getBlockTileEntity(this.xCoord, this.yCoord, this.zCoord) != this) {
            return false;
        }
        return entityplayer.distanceToSqr((double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5) <= 64.0;
    }

    private void simulateTrommelDrops(int passes, ItemStack blockToTest) {
        HashMap<Item, Integer> trommelDropMap = new HashMap<Item, Integer>();
        System.out.println();
        System.out.println("Generating simulation of Trommel loot for block: " + blockToTest.getItem().getKey());
        for (int i = 0; i < passes; ++i) {
            ItemStack itemStack = this.getItemResult(blockToTest);
            if (itemStack == null) continue;
            Item item = itemStack.getItem();
            trommelDropMap.put(item, trommelDropMap.getOrDefault(item, 0) + 1);
        }
        System.out.println("Trommel loot sampling " + passes + " passes:");
        for (Item item : Item.itemsList) {
            float percentage;
            if (trommelDropMap.containsKey(item)) {
                percentage = (float)((Integer)trommelDropMap.get(item)).intValue() / (float)passes;
                percentage *= 100.0f;
            } else {
                percentage = 0.0f;
            }
            if (!trommelDropMap.containsKey(item) || item == null) continue;
            System.out.println("        " + item.getKey() + " yield: " + trommelDropMap.get(item) + " (" + MathHelper.floor_float((float)((Integer)trommelDropMap.get(item)).intValue() / 64.0f) + " stacks) - " + String.format("%.2f", Float.valueOf(percentage)) + "%");
        }
    }

    static {
        trommelDropsDirt.addEntry(new WeightedRandomLootObject(new ItemStack(Item.ammoPebble), 1, 3), 50.0);
        trommelDropsDirt.addEntry(new WeightedRandomLootObject(new ItemStack(Item.clay), 1, 5), 20.0);
        trommelDropsDirt.addEntry(new WeightedRandomLootObject(new ItemStack(Item.flint), 1, 3), 10.0);
        trommelDropsDirt.addEntry(new WeightedRandomLootObject(new ItemStack(Item.sulphur)), 2.0);
        trommelDropsDirt.addEntry(new WeightedRandomLootObject(new ItemStack(Item.oreRawIron), 1), 0.5);
        trommelDropsDirt.addEntry(new WeightedRandomLootObject(new ItemStack(Item.olivine)), 0.25);
        trommelDropsDirt.addEntry(new WeightedRandomLootObject(new ItemStack(Item.quartz)), 0.25);
        trommelDropsGravel = new WeightedRandomBag();
        trommelDropsGravel.addEntry(new WeightedRandomLootObject(new ItemStack(Item.flint), 1, 2), 25.0);
        trommelDropsGravel.addEntry(new WeightedRandomLootObject(new ItemStack(Item.olivine), 1, 3), 30.0);
        trommelDropsGravel.addEntry(new WeightedRandomLootObject(new ItemStack(Item.ammoPebble), 1, 6), 25.0);
        trommelDropsGravel.addEntry(new WeightedRandomLootObject(new ItemStack(Item.oreRawIron), 1, 2), 10.0);
        trommelDropsGravel.addEntry(new WeightedRandomLootObject(new ItemStack(Item.dye, 1, 4), 2, 6), 5.0);
        trommelDropsGravel.addEntry(new WeightedRandomLootObject(new ItemStack(Item.sulphur)), 5.0);
        trommelDropsGravel.addEntry(new WeightedRandomLootObject(new ItemStack(Item.quartz)), 0.5);
        trommelDropsClay = new WeightedRandomBag();
        trommelDropsClay.addEntry(new WeightedRandomLootObject(new ItemStack(Item.clay), 4, 8), 30.0);
        trommelDropsClay.addEntry(new WeightedRandomLootObject(new ItemStack(Item.ammoPebble), 1, 3), 20.0);
        trommelDropsClay.addEntry(new WeightedRandomLootObject(new ItemStack(Item.sulphur)), 10.0);
        trommelDropsClay.addEntry(new WeightedRandomLootObject(new ItemStack(Item.oreRawGold), 1), 1.0);
        trommelDropsSand = new WeightedRandomBag();
        trommelDropsSand.addEntry(new WeightedRandomLootObject(new ItemStack(Item.quartz), 1, 3), 50.0);
        trommelDropsSand.addEntry(new WeightedRandomLootObject(new ItemStack(Item.clay), 4, 8), 30.0);
        trommelDropsSand.addEntry(new WeightedRandomLootObject(new ItemStack(Item.ammoPebble), 1, 5), 25.0);
        trommelDropsSand.addEntry(new WeightedRandomLootObject(new ItemStack(Item.bone), 1, 3), 10.0);
        trommelDropsSand.addEntry(new WeightedRandomLootObject(new ItemStack(Item.flint), 1, 3), 10.0);
        trommelDropsSand.addEntry(new WeightedRandomLootObject(new ItemStack(Item.sulphur)), 5.0);
        trommelDropsSand.addEntry(new WeightedRandomLootObject(new ItemStack(Item.oreRawGold), 1), 1.0);
        trommelDropsSand.addEntry(new WeightedRandomLootObject(new ItemStack(Item.olivine)), 5.0);
        trommelDropsRichDirt = new WeightedRandomBag();
        trommelDropsRichDirt.addEntry(new WeightedRandomLootObject(new ItemStack(Item.oreRawGold), 1), 10.0);
        trommelDropsRichDirt.addEntry(new WeightedRandomLootObject(new ItemStack(Item.oreRawIron), 1, 2), 15.0);
        trommelDropsRichDirt.addEntry(new WeightedRandomLootObject(new ItemStack(Item.quartz), 1, 4), 25.0);
        trommelDropsRichDirt.addEntry(new WeightedRandomLootObject(new ItemStack(Item.olivine), 1, 4), 25.0);
        trommelDropsRichDirt.addEntry(new WeightedRandomLootObject(new ItemStack(Item.dye, 1, 4), 2, 4), 20.0);
        trommelDropsRichDirt.addEntry(new WeightedRandomLootObject(new ItemStack(Item.clay), 4, 8), 10.0);
        trommelDropsRichDirt.addEntry(new WeightedRandomLootObject(new ItemStack(Item.ammoPebble), 1, 5), 5.0);
        trommelDropsSoulSand = new WeightedRandomBag();
        trommelDropsSoulSand.addEntry(new WeightedRandomLootObject(new ItemStack(Item.flint), 1, 3), 20.0);
        trommelDropsSoulSand.addEntry(new WeightedRandomLootObject(new ItemStack(Item.bone), 1, 6), 10.0);
        trommelDropsSoulSand.addEntry(new WeightedRandomLootObject(new ItemStack(Item.oreRawGold), 1), 2.0);
        trommelDropsSoulSand.addEntry(new WeightedRandomLootObject(new ItemStack(Item.oreRawIron), 1), 1.0);
        trommelDropsSoulSand.addEntry(new WeightedRandomLootObject(new ItemStack(Item.dustGlowstone), 1, 6), 5.0);
        trommelDropsSoulSand.addEntry(new WeightedRandomLootObject(new ItemStack(Item.quartz), 1, 3), 5.0);
        trommelDropsSoulSand.addEntry(new WeightedRandomLootObject(new ItemStack(Item.nethercoal)), 0.5);
    }
}

