/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block.material;

import net.minecraft.core.block.material.MaterialColor;
import net.minecraft.core.block.material.MaterialLiquid;
import net.minecraft.core.block.material.MaterialLogic;
import net.minecraft.core.block.material.MaterialPortal;
import net.minecraft.core.block.material.MaterialTransparent;

public class Material {
    public static final Material air = new MaterialTransparent(MaterialColor.none);
    public static final Material grass = new Material(MaterialColor.grass);
    public static final Material dirt = new Material(MaterialColor.dirt);
    public static final Material wood = new Material(MaterialColor.wood).flammable();
    public static final Material stone = new Material(MaterialColor.stone).notAlwaysDestroyable();
    public static final Material metal = new Material(MaterialColor.metal).notAlwaysDestroyable();
    public static final Material water = new MaterialLiquid(MaterialColor.water).destroyOnPush();
    public static final Material lava = new MaterialLiquid(MaterialColor.fire).destroyOnPush();
    public static final Material leaves = new Material(MaterialColor.plant).flammable().notSolidBlocking().destroyOnPush();
    public static final Material plant = new MaterialLogic(MaterialColor.plant).destroyOnPush().replaceable();
    public static final Material sponge = new Material(MaterialColor.wool);
    public static final Material cloth = new Material(MaterialColor.wool).flammable();
    public static final Material fire = new MaterialTransparent(MaterialColor.none).destroyOnPush();
    public static final Material sand = new Material(MaterialColor.sand);
    public static final Material decoration = new MaterialLogic(MaterialColor.none).destroyOnPush();
    public static final Material glass = new Material(MaterialColor.none).notSolidBlocking();
    public static final Material explosive = new Material(MaterialColor.fire).flammable().notSolidBlocking();
    public static final Material coral = new Material(MaterialColor.plant).destroyOnPush();
    public static final Material ice = new Material(MaterialColor.ice).notSolidBlocking();
    public static final Material topSnow = new MaterialLogic(MaterialColor.snow).replaceable().notSolidBlocking().notAlwaysDestroyable().destroyOnPush();
    public static final Material snow = new Material(MaterialColor.snow).notAlwaysDestroyable();
    public static final Material cactus = new Material(MaterialColor.plant).notSolidBlocking().destroyOnPush();
    public static final Material clay = new Material(MaterialColor.clay);
    public static final Material vegetable = new Material(MaterialColor.plant).destroyOnPush();
    public static final Material portal = new MaterialPortal(MaterialColor.none).notPushable();
    public static final Material cake = new Material(MaterialColor.none).destroyOnPush();
    public static final Material web = new Material(MaterialColor.wool).notAlwaysDestroyable().destroyOnPush();
    public static final Material piston = new Material(MaterialColor.stone).notPushable();
    public static final Material moss = new Material(MaterialColor.grass).flammable().notAlwaysDestroyable();
    public static final Material woodWet = new Material(MaterialColor.grass);
    private boolean flammable;
    private boolean replaceable;
    private boolean notSolidBlocking;
    public final MaterialColor color;
    private boolean alwaysDestroyable = true;
    private int pushReaction;

    public Material(MaterialColor color) {
        this.color = color;
    }

    public boolean isLiquid() {
        return false;
    }

    public boolean isSolid() {
        return true;
    }

    public boolean blocksLight() {
        return true;
    }

    public boolean blocksMotion() {
        return true;
    }

    private Material notSolidBlocking() {
        this.notSolidBlocking = true;
        return this;
    }

    private Material notAlwaysDestroyable() {
        this.alwaysDestroyable = false;
        return this;
    }

    private Material flammable() {
        this.flammable = true;
        return this;
    }

    public boolean isFlammable() {
        return this.flammable;
    }

    public Material replaceable() {
        this.replaceable = true;
        return this;
    }

    public boolean isReplaceable() {
        return this.replaceable;
    }

    public boolean isSolidBlocking() {
        if (this.notSolidBlocking) {
            return false;
        }
        return this.blocksMotion();
    }

    public boolean isAlwaysDestroyable() {
        return this.alwaysDestroyable;
    }

    public int getPushReaction() {
        return this.pushReaction;
    }

    protected Material destroyOnPush() {
        this.pushReaction = 1;
        return this;
    }

    protected Material notPushable() {
        this.pushReaction = 2;
        return this;
    }
}

