/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.crafting;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.block.Block;
import net.minecraft.core.crafting.recipe.IRecipe;
import net.minecraft.core.crafting.recipe.RecipeRepairable;
import net.minecraft.core.crafting.recipe.RecipeRepairableStackable;
import net.minecraft.core.crafting.recipe.RecipeScrap;
import net.minecraft.core.crafting.recipe.RecipeShaped;
import net.minecraft.core.crafting.recipe.RecipeShapeless;
import net.minecraft.core.crafting.recipe.RecipeSorter;
import net.minecraft.core.crafting.recipe.RecipesArmor;
import net.minecraft.core.crafting.recipe.RecipesCrafting;
import net.minecraft.core.crafting.recipe.RecipesDyes;
import net.minecraft.core.crafting.recipe.RecipesFood;
import net.minecraft.core.crafting.recipe.RecipesIngots;
import net.minecraft.core.crafting.recipe.RecipesRepairs;
import net.minecraft.core.crafting.recipe.RecipesScrappable;
import net.minecraft.core.crafting.recipe.RecipesTools;
import net.minecraft.core.crafting.recipe.RecipesWeapons;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.player.inventory.InventoryCrafting;
import net.minecraft.core.util.helper.DyeColor;

public class CraftingManager {
    private static final CraftingManager instance = new CraftingManager();
    private List<IRecipe> recipes = new ArrayList<IRecipe>();
    public static Block[][] blockAlternatives = new Block[][]{{Block.stone, Block.basalt, Block.limestone, Block.granite}, {Block.cobbleStone, Block.cobbleBasalt, Block.cobbleLimestone, Block.cobbleGranite, Block.cobblePermafrost}, {Block.planksOak, Block.planksOakPainted}, {Block.grass, Block.grassRetro}, {Block.dirt, Block.dirtScorched}, {Block.mossStone, Block.mossBasalt, Block.mossLimestone, Block.mossGranite}, {Block.logOak, Block.logPine, Block.logBirch, Block.logCherry, Block.logEucalyptus, Block.logOakMossy}, {Block.leavesOak, Block.leavesOakRetro, Block.leavesPine, Block.leavesBirch, Block.leavesCherry, Block.leavesEucalyptus, Block.leavesShrub}, {Block.oreCoalStone, Block.oreCoalBasalt, Block.oreCoalLimestone, Block.oreCoalGranite}, {Block.oreIronStone, Block.oreIronBasalt, Block.oreIronLimestone, Block.oreIronGranite}, {Block.oreGoldStone, Block.oreGoldBasalt, Block.oreGoldLimestone, Block.oreGoldGranite}, {Block.oreLapisStone, Block.oreLapisBasalt, Block.oreLapisLimestone, Block.oreLapisGranite}, {Block.oreRedstoneStone, Block.oreRedstoneBasalt, Block.oreRedstoneLimestone, Block.oreRedstoneGranite, Block.oreRedstoneGlowingStone, Block.oreRedstoneGlowingBasalt, Block.oreRedstoneGlowingLimestone, Block.oreRedstoneGlowingGranite}, {Block.chestPlanksOak, Block.chestPlanksOakPainted}};

    public static CraftingManager getInstance() {
        return instance;
    }

    private CraftingManager() {
        new RecipesTools().addRecipes(this);
        new RecipesWeapons().addRecipes(this);
        new RecipesIngots().addRecipes(this);
        new RecipesFood().addRecipes(this);
        new RecipesCrafting().addRecipes(this);
        new RecipesArmor().addRecipes(this);
        new RecipesDyes().addRecipes(this);
        new RecipesRepairs().addRecipes(this);
        new RecipesScrappable().addRecipes(this);
        this.addRecipe(new ItemStack(Block.pillarMarble, 2), "#", "#", Character.valueOf('#'), Block.marble);
        this.addRecipe(new ItemStack(Block.sandstone, 2), "##", "##", Character.valueOf('#'), Block.sand);
        this.addRecipe(new ItemStack(Block.torchCoal, 4), "X", "#", Character.valueOf('X'), Item.coal, Character.valueOf('#'), Item.stick);
        this.addRecipe(new ItemStack(Block.planksOak, 4), false, new Object[]{"#", Character.valueOf('#'), Block.logOak});
        this.addRecipe(new ItemStack(Block.planksOakPainted, 4, DyeColor.DYE_BROWN.blockMeta), false, new Object[]{"#", Character.valueOf('#'), Block.logPine});
        this.addRecipe(new ItemStack(Block.planksOakPainted, 4, DyeColor.DYE_WHITE.blockMeta), false, new Object[]{"#", Character.valueOf('#'), Block.logBirch});
        this.addRecipe(new ItemStack(Block.planksOakPainted, 4, DyeColor.DYE_GREEN.blockMeta), false, new Object[]{"#", Character.valueOf('#'), Block.logOakMossy});
        this.addRecipe(new ItemStack(Block.planksOakPainted, 4, DyeColor.DYE_ORANGE.blockMeta), false, new Object[]{"#", Character.valueOf('#'), Block.logEucalyptus});
        this.addRecipe(new ItemStack(Block.planksOakPainted, 4, DyeColor.DYE_PINK.blockMeta), false, new Object[]{"#", Character.valueOf('#'), Block.logCherry});
        this.addRecipe(new ItemStack(Block.ladderOak, 2), "# #", "###", "# #", Character.valueOf('#'), Item.stick);
        this.addRecipe(new ItemStack(Block.fencePlanksOak, 6), true, new Object[]{"#X#", "#X#", Character.valueOf('X'), Item.stick, Character.valueOf('#'), Block.planksOak});
        this.addRecipe(new ItemStack(Block.fencegatePlanksOak, 3), true, new Object[]{"#X#", "#X#", Character.valueOf('X'), Block.planksOak, Character.valueOf('#'), Item.stick});
        this.addRecipe(new ItemStack(Block.bookshelfPlanksOak, 1), true, false, new Object[]{"###", "XXX", "###", Character.valueOf('#'), Block.planksOak, Character.valueOf('X'), Item.book});
        this.addRecipe(new ItemStack(Block.wool, 1), "##", "##", Character.valueOf('#'), Item.string);
        this.addRecipe(new ItemStack(Block.brickClay, 4), "##", "##", Character.valueOf('#'), Item.brickClay);
        this.addRecipe(new ItemStack(Block.brickGold, 4), "##", "##", Character.valueOf('#'), Item.ingotGold);
        this.addRecipe(new ItemStack(Block.brickIron, 4), "##", "##", Character.valueOf('#'), Item.ingotIron);
        this.addRecipe(new ItemStack(Block.brickStonePolished, 4), "##", "##", Character.valueOf('#'), Block.stonePolished);
        this.addRecipe(new ItemStack(Block.brickStone, 4), "##", "##", Character.valueOf('#'), Block.stone);
        this.addRecipe(new ItemStack(Block.brickSandstone, 4), "##", "##", Character.valueOf('#'), Block.sandstone);
        this.addRecipe(new ItemStack(Block.brickLapis, 4), "##", "##", Character.valueOf('#'), new ItemStack(Item.dye, 1, 4));
        this.addRecipe(new ItemStack(Block.brickBasalt, 4), "##", "##", Character.valueOf('#'), Block.basalt);
        this.addRecipe(new ItemStack(Block.brickLimestone, 4), "##", "##", Character.valueOf('#'), Block.limestone);
        this.addRecipe(new ItemStack(Block.brickGranite, 4), "##", "##", Character.valueOf('#'), Block.granite);
        this.addRecipe(new ItemStack(Block.brickMarble, 4), "##", "##", Character.valueOf('#'), Block.marble);
        this.addRecipe(new ItemStack(Block.brickSlate, 4), "##", "##", Character.valueOf('#'), Block.slate);
        this.addRecipe(new ItemStack(Block.brickPermafrost, 4), "##", "##", Character.valueOf('#'), Block.permafrost);
        this.addRecipe(new ItemStack(Block.slabPlanksOak, 6), true, new Object[]{"###", Character.valueOf('#'), Block.planksOak});
        this.addRecipe(new ItemStack(Block.slabCobbleStone, 6), "###", Character.valueOf('#'), Block.cobbleStone);
        this.addRecipe(new ItemStack(Block.slabSandstone, 6), "###", Character.valueOf('#'), Block.sandstone);
        this.addRecipe(new ItemStack(Block.slabBrickStonePolished, 6), "###", Character.valueOf('#'), Block.brickStonePolished);
        this.addRecipe(new ItemStack(Block.slabStonePolished, 6), "###", Character.valueOf('#'), Block.stonePolished);
        this.addRecipe(new ItemStack(Block.slabGranitePolished, 6), "###", Character.valueOf('#'), Block.granitePolished);
        this.addRecipe(new ItemStack(Block.slabBasaltPolished, 6), "###", Character.valueOf('#'), Block.basaltPolished);
        this.addRecipe(new ItemStack(Block.slabLimestonePolished, 6), "###", Character.valueOf('#'), Block.limestonePolished);
        this.addRecipe(new ItemStack(Block.slabBrickMarble, 6), "###", Character.valueOf('#'), Block.brickMarble);
        this.addRecipe(new ItemStack(Block.slabBrickClay, 6), "###", Character.valueOf('#'), Block.brickClay);
        this.addRecipe(new ItemStack(Block.slabCapstoneMarble, 6), "###", Character.valueOf('#'), Block.marble);
        this.addRecipe(new ItemStack(Block.slabCobbleBasalt, 6), "###", Character.valueOf('#'), Block.cobbleBasalt);
        this.addRecipe(new ItemStack(Block.slabCobbleLimestone, 6), "###", Character.valueOf('#'), Block.cobbleLimestone);
        this.addRecipe(new ItemStack(Block.slabCobbleGranite, 6), "###", Character.valueOf('#'), Block.cobbleGranite);
        this.addRecipe(new ItemStack(Block.slabBrickBasalt, 6), "###", Character.valueOf('#'), Block.brickBasalt);
        this.addRecipe(new ItemStack(Block.slabBrickLimestone, 6), "###", Character.valueOf('#'), Block.brickLimestone);
        this.addRecipe(new ItemStack(Block.slabBrickGranite, 6), "###", Character.valueOf('#'), Block.brickGranite);
        this.addRecipe(new ItemStack(Block.slabBrickStone, 6), "###", Character.valueOf('#'), Block.brickStone);
        this.addRecipe(new ItemStack(Block.slabBrickSlate, 6), "###", Character.valueOf('#'), Block.brickSlate);
        this.addRecipe(new ItemStack(Block.stairsPlanksOak, 6), true, new Object[]{"#  ", "## ", "###", Character.valueOf('#'), Block.planksOak});
        this.addRecipe(new ItemStack(Block.stairsCobbleStone, 6), "#  ", "## ", "###", Character.valueOf('#'), Block.cobbleStone);
        this.addRecipe(new ItemStack(Block.stairsBrickStonePolished, 6), "#  ", "## ", "###", Character.valueOf('#'), Block.brickStonePolished);
        this.addRecipe(new ItemStack(Block.stairsBrickMarble, 6), "#  ", "## ", "###", Character.valueOf('#'), Block.brickMarble);
        this.addRecipe(new ItemStack(Block.stairsCobbleBasalt, 6), "#  ", "## ", "###", Character.valueOf('#'), Block.cobbleBasalt);
        this.addRecipe(new ItemStack(Block.stairsCobbleLimestone, 6), "#  ", "## ", "###", Character.valueOf('#'), Block.cobbleLimestone);
        this.addRecipe(new ItemStack(Block.stairsCobbleGranite, 6), "#  ", "## ", "###", Character.valueOf('#'), Block.cobbleGranite);
        this.addRecipe(new ItemStack(Block.stairsBrickBasalt, 6), "#  ", "## ", "###", Character.valueOf('#'), Block.brickBasalt);
        this.addRecipe(new ItemStack(Block.stairsBrickLimestone, 6), "#  ", "## ", "###", Character.valueOf('#'), Block.brickLimestone);
        this.addRecipe(new ItemStack(Block.stairsBrickGranite, 6), "#  ", "## ", "###", Character.valueOf('#'), Block.brickGranite);
        this.addRecipe(new ItemStack(Block.stairsBrickClay, 6), "#  ", "## ", "###", Character.valueOf('#'), Block.brickClay);
        this.addRecipe(new ItemStack(Block.stairsBrickStone, 6), "#  ", "## ", "###", Character.valueOf('#'), Block.brickStone);
        this.addRecipe(new ItemStack(Block.stairsBrickSlate, 6), "#  ", "## ", "###", Character.valueOf('#'), Block.brickSlate);
        this.addRecipe(new ItemStack(Block.torchRedstoneActive, 1), "X", "#", Character.valueOf('#'), Item.stick, Character.valueOf('X'), Item.dustRedstone);
        this.addRecipe(new ItemStack(Block.buttonStone, 4), true, new Object[]{"#", Character.valueOf('#'), Block.stone});
        this.addRecipe(new ItemStack(Block.leverCobbleStone, 2), true, new Object[]{"X", "#", Character.valueOf('#'), Block.cobbleStone, Character.valueOf('X'), Item.stick});
        this.addRecipe(new ItemStack(Block.pressureplateStone, 1), true, new Object[]{"##", Character.valueOf('#'), Block.stone});
        this.addRecipe(new ItemStack(Block.pressureplatePlanksOak, 1), true, false, new Object[]{"##", Character.valueOf('#'), Block.planksOak});
        this.addRecipe(new ItemStack(Block.pressureplateCobbleStone, 1), true, new Object[]{"##", Character.valueOf('#'), Block.cobbleStone});
        this.addRecipe(new ItemStack(Block.pistonBase, 1), true, false, new Object[]{"TTT", "#X#", "#R#", Character.valueOf('#'), Block.cobbleStone, Character.valueOf('X'), Item.ingotIron, Character.valueOf('R'), Item.dustRedstone, Character.valueOf('T'), Block.planksOak});
        this.addRecipe(new ItemStack(Block.pistonBaseSticky, 1), true, new Object[]{"S", "P", Character.valueOf('S'), Item.slimeball, Character.valueOf('P'), Block.pistonBase});
        this.addRecipe(new ItemStack(Block.noteblock, 1), true, false, new Object[]{"###", "#X#", "###", Character.valueOf('#'), Block.planksOak, Character.valueOf('X'), Item.dustRedstone});
        this.addRecipe(new ItemStack(Block.rail, 16), "X X", "X#X", "X X", Character.valueOf('X'), Item.ingotIron, Character.valueOf('#'), Item.stick);
        this.addRecipe(new ItemStack(Block.railPowered, 8), "X X", "X#X", "XRX", Character.valueOf('X'), Item.ingotGold, Character.valueOf('R'), Item.dustRedstone, Character.valueOf('#'), Item.stick);
        this.addRecipe(new ItemStack(Block.railDetector, 8), "X X", "X#X", "XRX", Character.valueOf('X'), Item.ingotIron, Character.valueOf('R'), Item.dustRedstone, Character.valueOf('#'), Block.pressureplateStone);
        this.addRecipe(new ItemStack(Block.spikes, 4), true, new Object[]{" # ", "#X#", "YYY", Character.valueOf('#'), Item.ingotIron, Character.valueOf('X'), Item.dustRedstone, Character.valueOf('Y'), Block.cobbleStone});
        this.addRecipe(new ItemStack(Block.dispenserCobbleStone, 1), true, new Object[]{"###", "#X#", "#R#", Character.valueOf('#'), Block.cobbleStone, Character.valueOf('X'), Item.toolBow, Character.valueOf('R'), Item.dustRedstone});
        this.addRecipe(new ItemStack(Block.trapdoorPlanksOak, 6), true, false, new Object[]{"###", "###", Character.valueOf('#'), Block.planksOak});
        this.addRecipe(new ItemStack(Block.trapdoorIron, 6), true, false, new Object[]{"###", "###", Character.valueOf('#'), Item.ingotIron});
        this.addRecipe(new ItemStack(Block.trapdoorGlass, 6), true, false, new Object[]{"###", "###", Character.valueOf('#'), Block.glass});
        this.addRecipe(new ItemStack(Block.tnt, 1), "X#X", "#X#", "X#X", Character.valueOf('X'), Item.sulphur, Character.valueOf('#'), Block.sand);
        this.addRecipe(new ItemStack(Block.mesh, 8), "###", "# #", "###", Character.valueOf('#'), Item.ingotIron);
        this.addRecipe(new ItemStack(Block.cobweb, 1), "###", "###", "###", Character.valueOf('#'), Item.string);
        this.addRecipe(new ItemStack(Block.blockSnow, 1), "##", "##", Character.valueOf('#'), Item.ammoSnowball);
        this.addRecipe(new ItemStack(Block.blockClay, 1), "##", "##", Character.valueOf('#'), Item.clay);
        this.addRecipe(new ItemStack(Block.jukebox, 1), true, false, new Object[]{"###", "#X#", "###", Character.valueOf('#'), Block.planksOak, Character.valueOf('X'), Item.diamond});
        this.addRecipe(new ItemStack(Item.paper, 6), "###", Character.valueOf('#'), Item.sugarcane);
        this.addRecipe(new ItemStack(Item.book, 1), "#", "#", "#", Character.valueOf('#'), Item.paper);
        this.addRecipe(new ItemStack(Block.pumpkinCarvedIdle, 1), "A", Character.valueOf('A'), Block.pumpkin);
        this.addRecipe(new ItemStack(Block.pumpkinCarvedActive, 1), "A", "B", Character.valueOf('A'), Block.pumpkinCarvedIdle, Character.valueOf('B'), Block.torchCoal);
        this.addRecipe(new ItemStack(Block.glowstone, 1), "##", "##", Character.valueOf('#'), Item.dustGlowstone);
        this.addRecipe(new ItemStack(Item.doorOak, 2), true, false, new Object[]{"##", "##", "##", Character.valueOf('#'), Block.planksOak});
        this.addRecipe(new ItemStack(Item.doorIron, 2), "##", "##", "##", Character.valueOf('#'), Item.ingotIron);
        this.addRecipe(new ItemStack(Item.sign, 4), true, false, new Object[]{"###", "###", " X ", Character.valueOf('#'), Block.planksOak, Character.valueOf('X'), Item.stick});
        this.addRecipe(new ItemStack(Item.foodCake, 1), false, false, false, new Object[]{"AAA", "BEB", "CCC", Character.valueOf('A'), Item.bucketMilk, Character.valueOf('B'), Item.dustSugar, Character.valueOf('C'), Item.wheat, Character.valueOf('E'), Item.eggChicken});
        this.addRecipe(new ItemStack(Item.dustSugar, 3), "#", Character.valueOf('#'), Item.sugarcane);
        this.addRecipe(new ItemStack(Item.stick, 4), true, false, new Object[]{"#", "#", Character.valueOf('#'), Block.planksOak});
        this.addRecipe(new ItemStack(Block.torchCoal, 4), "X", "#", Character.valueOf('X'), new ItemStack(Item.coal, 1, 1), Character.valueOf('#'), Item.stick);
        this.addRecipe(new ItemStack(Block.torchCoal, 8), "X", "#", Character.valueOf('X'), new ItemStack(Item.nethercoal, 1, 0), Character.valueOf('#'), Item.stick);
        this.addRecipe(new ItemStack(Item.bowl, 4), true, false, new Object[]{"# #", " # ", Character.valueOf('#'), Block.planksOak});
        this.addRecipe(new ItemStack(Item.minecart, 1), "# #", "###", Character.valueOf('#'), Item.ingotIron);
        this.addRecipe(new ItemStack(Item.minecartChest, 1), true, false, new Object[]{"A", "B", Character.valueOf('A'), Block.chestPlanksOak, Character.valueOf('B'), Item.minecart});
        this.addRecipe(new ItemStack(Item.minecartFurnace, 1), "A", "B", Character.valueOf('A'), Block.furnaceStoneIdle, Character.valueOf('B'), Item.minecart);
        this.addRecipe(new ItemStack(Item.boat, 1), true, false, new Object[]{"# #", "###", Character.valueOf('#'), Block.planksOak});
        this.addRecipe(new ItemStack(Item.bucket, 1), "# #", " # ", Character.valueOf('#'), Item.ingotIron);
        this.addShapelessRecipe(new ItemStack(Item.toolFirestriker), new ItemStack(Item.ingotIron), new ItemStack(Item.flint));
        this.addShapelessRecipe(new ItemStack(Item.toolFirestrikerSteel), new ItemStack(Item.ingotSteel), new ItemStack(Item.flint));
        this.addRecipe(new ItemStack(Item.foodBread, 1), "###", Character.valueOf('#'), Item.wheat);
        this.addRecipe(new ItemStack(Item.toolFishingrod, 1), "  #", " #X", "# X", Character.valueOf('#'), Item.stick, Character.valueOf('X'), Item.string);
        this.addRecipe(new ItemStack(Item.painting, 1), false, false, new Object[]{"###", "#X#", "###", Character.valueOf('#'), Item.stick, Character.valueOf('X'), Block.wool});
        this.addRecipe(new ItemStack(Item.foodAppleGold, 1), "###", "#X#", "###", Character.valueOf('#'), Block.blockGold, Character.valueOf('X'), Item.foodApple);
        this.addRecipe(new ItemStack(Item.repeater, 1), true, new Object[]{"#X#", "III", Character.valueOf('#'), Block.torchRedstoneActive, Character.valueOf('X'), Item.dustRedstone, Character.valueOf('I'), Block.stone});
        this.addRecipe(new ItemStack(Item.toolClock, 1), " # ", "#X#", " # ", Character.valueOf('#'), Item.ingotGold, Character.valueOf('X'), Item.dustRedstone);
        this.addRecipe(new ItemStack(Item.toolCompass, 1), " # ", "#X#", " # ", Character.valueOf('#'), Item.ingotIron, Character.valueOf('X'), Item.dustRedstone);
        this.addRecipe(new ItemStack(Item.toolCalendar, 1), true, false, new Object[]{" # ", "#X#", " # ", Character.valueOf('#'), Block.planksOak, Character.valueOf('X'), Item.dustRedstone});
        this.addRecipe(new ItemStack(Item.map, 1), "###", "#X#", "###", Character.valueOf('#'), Item.paper, Character.valueOf('X'), Item.toolCompass);
        this.addRecipe(new ItemStack(Item.bed, 1), true, false, new Object[]{"YY#", "XXX", Character.valueOf('#'), Block.wool, Character.valueOf('X'), Block.planksOak, Character.valueOf('Y'), Item.cloth});
        this.addRecipe(new ItemStack(Block.stairsBrickStonePolished, 6), "#  ", "## ", "###", Character.valueOf('#'), Block.brickStonePolished);
        this.addRecipe(new ItemStack(Item.ingotSteel, 1), "###", Character.valueOf('#'), Item.ingotSteelCrude);
        this.addRecipe(new ItemStack(Block.lampIdle, 4), "###", "#O#", "#X#", Character.valueOf('#'), Block.glass, Character.valueOf('O'), Item.quartz, Character.valueOf('X'), Item.dustRedstone);
        this.addRecipe(new ItemStack(Block.glassTinted, 4), "#X", "X#", Character.valueOf('#'), Block.glass, Character.valueOf('X'), Item.olivine);
        this.addRecipe(new ItemStack(Block.layerSlate, 8), "#", Character.valueOf('#'), Block.slate);
        this.addRecipe(new ItemStack(Block.layerSnow, 2), "##", Character.valueOf('#'), Item.ammoSnowball);
        this.addRecipe(new ItemStack(Block.layerLeavesOak, 8), "#", Character.valueOf('#'), Block.leavesOak);
        this.addRecipe(new ItemStack(Block.cobbleStone, 2), "##", "##", Character.valueOf('#'), Item.ammoPebble);
        this.addRecipe(new ItemStack(Block.cobbleBasalt, 2), "#X", "X#", Character.valueOf('#'), Item.ammoPebble, Character.valueOf('X'), Item.coal);
        this.addRecipe(new ItemStack(Block.cobbleLimestone, 2), "#X", "X#", Character.valueOf('#'), Item.ammoPebble, Character.valueOf('X'), Block.sand);
        this.addRecipe(new ItemStack(Block.cobbleGranite, 2), "#X", "X#", Character.valueOf('#'), Item.ammoPebble, Character.valueOf('X'), Item.quartz);
        this.addRecipe(new ItemStack(Block.slatePolished, 2), "#", "#", Character.valueOf('#'), Block.slate);
        this.addRecipe(new ItemStack(Block.stonePolished, 2), "#", "#", Character.valueOf('#'), Block.stone);
        this.addRecipe(new ItemStack(Block.granitePolished, 2), "#", "#", Character.valueOf('#'), Block.granite);
        this.addRecipe(new ItemStack(Block.limestonePolished, 2), "#", "#", Character.valueOf('#'), Block.limestone);
        this.addRecipe(new ItemStack(Block.basaltPolished, 2), "#", "#", Character.valueOf('#'), Block.basalt);
        this.addShapelessRecipe(new ItemStack(Block.spongeWet, 1), new ItemStack(Block.spongeDry, 1), new ItemStack(Item.bucketWater, 1, 0));
        this.addShapelessRecipe(new ItemStack(Item.label), Item.string, Item.paper, new ItemStack(Item.dye, 1, 0));
        this.addRecipe(new ItemStack(Block.gravel), "FPF", "PFP", "FPF", Character.valueOf('P'), Item.ammoPebble, Character.valueOf('F'), Item.flint);
        this.addRecipe(new ItemStack(Item.jar, 4), false, false, new Object[]{"# #", " # ", Character.valueOf('#'), Block.glass});
        this.addRecipe(new ItemStack(Block.permaice, 2), "#X", "X#", Character.valueOf('#'), Block.permafrost, Character.valueOf('X'), Block.ice);
        this.addRecipe(new ItemStack(Block.fenceChainlink, 8), "I#I", "I#I", Character.valueOf('#'), Item.chainlink, Character.valueOf('I'), Item.ingotIron);
        this.addRecipe(new ItemStack(Item.basket), "YYY", "X X", "XXX", Character.valueOf('X'), Item.wheat, Character.valueOf('Y'), Item.leather);
        this.addRecipe(new ItemStack(Item.flag), "XYY", "XYY", "X  ", Character.valueOf('X'), Item.stick, Character.valueOf('Y'), Item.cloth);
        Collections.sort(this.recipes, new RecipeSorter(this));
        System.out.println(this.recipes.size() + " recipes");
    }

    public void addRecipe(ItemStack itemstack, Object ... aobj) {
        this.addRecipe(itemstack, false, true, aobj);
    }

    public void addRecipe(ItemStack itemstack, boolean useAlternatives, Object ... aobj) {
        this.addRecipe(itemstack, useAlternatives, true, aobj);
    }

    public void addRecipe(ItemStack itemstack, boolean useAlternatives, boolean countForMetadata, Object ... aobj) {
        this.addRecipe(itemstack, useAlternatives, countForMetadata, true, aobj);
    }

    public void addRecipe(ItemStack itemstack, boolean useAlternatives, boolean countForMetadata, boolean consumeContainerItem, Object ... aobj) {
        StringBuilder s = new StringBuilder();
        int i = 0;
        int j = 0;
        int k = 0;
        if (aobj[i] instanceof String[]) {
            String[] as;
            for (String s2 : as = (String[])aobj[i++]) {
                ++k;
                j = s2.length();
                s.append(s2);
            }
        } else {
            while (aobj[i] instanceof String) {
                String s1 = (String)aobj[i++];
                ++k;
                j = s1.length();
                s = new StringBuilder(s + s1);
            }
        }
        HashMap<Character, ItemStack> map = new HashMap<Character, ItemStack>();
        while (i < aobj.length) {
            Character character = (Character)aobj[i];
            ItemStack itemstack1 = null;
            if (aobj[i + 1] instanceof Item) {
                itemstack1 = new ItemStack((Item)aobj[i + 1]);
            } else if (aobj[i + 1] instanceof Block) {
                itemstack1 = new ItemStack((Block)aobj[i + 1]);
            } else if (aobj[i + 1] instanceof ItemStack) {
                itemstack1 = (ItemStack)aobj[i + 1];
            }
            map.put(character, itemstack1);
            i += 2;
        }
        ItemStack[] aitemstack = new ItemStack[j * k];
        for (int i1 = 0; i1 < j * k; ++i1) {
            char c = s.charAt(i1);
            aitemstack[i1] = map.containsKey(Character.valueOf(c)) ? ((ItemStack)map.get(Character.valueOf(c))).copy() : null;
        }
        this.recipes.add(new RecipeShaped(j, k, aitemstack, itemstack, useAlternatives, countForMetadata, consumeContainerItem));
    }

    public void addShapelessRecipe(ItemStack result, Object ... ingredients) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (int i = 0; i < ingredients.length; ++i) {
            Object obj = ingredients[i];
            if (obj instanceof ItemStack) {
                list.add(((ItemStack)obj).copy());
                continue;
            }
            if (obj instanceof Item) {
                list.add(new ItemStack((Item)obj));
                continue;
            }
            if (obj instanceof Block) {
                list.add(new ItemStack((Block)obj));
                continue;
            }
            throw new RuntimeException("Invalid object " + obj + " at index " + i);
        }
        this.recipes.add(new RecipeShapeless(result, list));
    }

    public void addRepairableRecipe(Item inItem, Item repairMaterial) {
        this.recipes.add(new RecipeRepairable(inItem, repairMaterial));
    }

    public void addRepairableStackableRecipe(Item inItem, ItemStack materialStack) {
        this.recipes.add(new RecipeRepairableStackable(inItem, materialStack));
    }

    public void addScrappableRecipe(Item itemToScrap, Item scrapYield) {
        this.recipes.add(new RecipeScrap(itemToScrap, scrapYield));
    }

    public ItemStack findMatchingRecipe(InventoryCrafting inventorycrafting) {
        for (int i = 0; i < this.recipes.size(); ++i) {
            IRecipe irecipe = this.recipes.get(i);
            if (!irecipe.matches(inventorycrafting)) continue;
            return irecipe.getCraftingResult(inventorycrafting);
        }
        return null;
    }

    public ItemStack[] onCraftResult(InventoryCrafting inventorycrafting) {
        for (int i = 0; i < this.recipes.size(); ++i) {
            IRecipe irecipe = this.recipes.get(i);
            if (!irecipe.matches(inventorycrafting)) continue;
            return irecipe.onCraftResult(inventorycrafting);
        }
        return null;
    }

    public List<IRecipe> getRecipeList() {
        return this.recipes;
    }
}

