/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.crafting.recipe;

import net.minecraft.core.crafting.recipe.IRecipe;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.player.inventory.InventoryCrafting;

public class RecipeLabel
implements IRecipe {
    @Override
    public ItemStack getCraftingResult(InventoryCrafting inventorycrafting) {
        ItemStack labelStack = null;
        ItemStack otherItem = null;
        block0: for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                ItemStack stack = inventorycrafting.getItemStackAt(x, y);
                if (stack == null) continue;
                if (stack.itemID == Item.label.id && labelStack == null) {
                    labelStack = stack;
                } else if (otherItem == null) {
                    otherItem = stack;
                }
                if (labelStack != null && otherItem != null) break block0;
            }
        }
        if (labelStack != null && otherItem != null) {
            ItemStack outStack = otherItem.copy();
            if (labelStack.hasCustomName()) {
                outStack.setCustomName(labelStack.getCustomName());
            }
            if (labelStack.hasCustomColor()) {
                outStack.setCustomColor(labelStack.getCustomColor());
            }
            outStack.stackSize = 1;
            return outStack;
        }
        return null;
    }

    @Override
    public ItemStack getRecipeOutput() {
        return new ItemStack(Item.label);
    }

    @Override
    public int getRecipeSize() {
        return 2;
    }

    @Override
    public boolean matches(InventoryCrafting crafting) {
        ItemStack labelStack = null;
        ItemStack otherStack = null;
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                ItemStack stack = crafting.getItemStackAt(x, y);
                if (stack == null) continue;
                if (stack.itemID == Item.label.id) {
                    if (labelStack != null || !stack.hasCustomName()) {
                        return false;
                    }
                    labelStack = stack;
                    continue;
                }
                if (otherStack != null) {
                    return false;
                }
                otherStack = stack;
            }
        }
        if (labelStack == null || otherStack == null) {
            return false;
        }
        if (otherStack.itemID == Item.dye.id && !labelStack.hasCustomColor()) {
            return false;
        }
        if (!labelStack.hasCustomName()) {
            return false;
        }
        if (otherStack.hasCustomName() && otherStack.getCustomName().equals(labelStack.getCustomName())) {
            if (labelStack.hasCustomColor()) {
                if (!otherStack.hasCustomColor()) {
                    return true;
                }
                return otherStack.getCustomColor() != labelStack.getCustomColor();
            }
            if (!otherStack.hasCustomColor() && !labelStack.hasCustomColor()) {
                return false;
            }
        }
        return true;
    }

    @Override
    public ItemStack[] onCraftResult(InventoryCrafting crafting) {
        ItemStack[] returnStack = new ItemStack[9];
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                ItemStack stack = crafting.getItemStackAt(x, y);
                if (stack == null || stack.itemID == Item.label.id) continue;
                --stack.stackSize;
                if (stack.stackSize > 0) continue;
                crafting.setSlotContentsAt(x, y, null);
            }
        }
        return returnStack;
    }
}

