/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.entity;

import com.mojang.nbt.CompoundTag;
import java.util.List;
import net.minecraft.core.HitResult;
import net.minecraft.core.achievement.stat.StatList;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityItem;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.DamageType;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.util.phys.Vec3d;
import net.minecraft.core.world.World;

public class EntityBobber
extends Entity {
    private int xTile = -1;
    private int yTile = -1;
    private int zTile = -1;
    private int inTile = 0;
    private boolean inGround = false;
    public int shake = 0;
    public EntityPlayer angler;
    private int ticksInGround;
    private int ticksInAir = 0;
    private int ticksCatchable = 0;
    public Entity bobber = null;
    private int field_6388_l;
    private double field_6387_m;
    private double field_6386_n;
    private double field_6385_o;
    private double field_6384_p;
    private double field_6383_q;
    private double velocityX;
    private double velocityY;
    private double velocityZ;

    public EntityBobber(World world) {
        super(world);
        this.setSize(0.25f, 0.25f);
        this.ignoreFrustumCheck = true;
    }

    public EntityBobber(World world, double d, double d1, double d2) {
        this(world);
        this.setPos(d, d1, d2);
        this.ignoreFrustumCheck = true;
    }

    public EntityBobber(World world, EntityPlayer entityplayer) {
        super(world);
        this.ignoreFrustumCheck = true;
        this.angler = entityplayer;
        this.angler.fishEntity = this;
        this.setSize(0.25f, 0.25f);
        this.moveTo(entityplayer.x, entityplayer.y + 1.62 - (double)entityplayer.heightOffset, entityplayer.z, entityplayer.yRot, entityplayer.xRot);
        this.x -= (double)(MathHelper.cos(this.yRot / 180.0f * 3.141593f) * 0.16f);
        this.y -= (double)0.1f;
        this.z -= (double)(MathHelper.sin(this.yRot / 180.0f * 3.141593f) * 0.16f);
        this.setPos(this.x, this.y, this.z);
        this.heightOffset = 0.0f;
        float f = 0.4f;
        this.xd = -MathHelper.sin(this.yRot / 180.0f * 3.141593f) * MathHelper.cos(this.xRot / 180.0f * 3.141593f) * f;
        this.zd = MathHelper.cos(this.yRot / 180.0f * 3.141593f) * MathHelper.cos(this.xRot / 180.0f * 3.141593f) * f;
        this.yd = -MathHelper.sin(this.xRot / 180.0f * 3.141593f) * f;
        this.func_4042_a(this.xd, this.yd, this.zd, 1.5f, 1.0f);
    }

    @Override
    protected void init() {
    }

    @Override
    public boolean shouldRenderAtSqrDistance(double distance) {
        double d1 = this.bb.getAverageEdgeLength() * 4.0;
        return distance < (d1 *= 64.0) * d1;
    }

    public void func_4042_a(double d, double d1, double d2, float f, float f1) {
        float f2 = MathHelper.sqrt_double(d * d + d1 * d1 + d2 * d2);
        d /= (double)f2;
        d1 /= (double)f2;
        d2 /= (double)f2;
        d += this.random.nextGaussian() * (double)0.0075f * (double)f1;
        d1 += this.random.nextGaussian() * (double)0.0075f * (double)f1;
        d2 += this.random.nextGaussian() * (double)0.0075f * (double)f1;
        this.xd = d *= (double)f;
        this.yd = d1 *= (double)f;
        this.zd = d2 *= (double)f;
        float f3 = MathHelper.sqrt_double(d * d + d2 * d2);
        this.yRotO = this.yRot = (float)(Math.atan2(d, d2) * 180.0 / 3.1415927410125732);
        this.xRotO = this.xRot = (float)(Math.atan2(d1, f3) * 180.0 / 3.1415927410125732);
        this.ticksInGround = 0;
    }

    @Override
    public void lerpTo(double x, double y, double z, float yRot, float xRot, int i) {
        this.field_6387_m = x;
        this.field_6386_n = y;
        this.field_6385_o = z;
        this.field_6384_p = yRot;
        this.field_6383_q = xRot;
        this.field_6388_l = i;
        this.xd = this.velocityX;
        this.yd = this.velocityY;
        this.zd = this.velocityZ;
    }

    @Override
    public void lerpMotion(double xd, double yd, double zd) {
        this.velocityX = this.xd = xd;
        this.velocityY = this.yd = yd;
        this.velocityZ = this.zd = zd;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void tick() {
        block34: {
            super.tick();
            if (this.field_6388_l > 0) {
                double d4;
                double d = this.x + (this.field_6387_m - this.x) / (double)this.field_6388_l;
                double d1 = this.y + (this.field_6386_n - this.y) / (double)this.field_6388_l;
                double d2 = this.z + (this.field_6385_o - this.z) / (double)this.field_6388_l;
                for (d4 = this.field_6384_p - (double)this.yRot; d4 < -180.0; d4 += 360.0) {
                }
                while (true) {
                    if (!(d4 >= 180.0)) {
                        this.yRot = (float)((double)this.yRot + d4 / (double)this.field_6388_l);
                        this.xRot = (float)((double)this.xRot + (this.field_6383_q - (double)this.xRot) / (double)this.field_6388_l);
                        --this.field_6388_l;
                        this.setPos(d, d1, d2);
                        this.setRot(this.yRot, this.xRot);
                        return;
                    }
                    d4 -= 360.0;
                }
            }
            if (!this.world.isClientSide) {
                ItemStack itemstack = this.angler.getCurrentEquippedItem();
                if (this.angler.removed || !this.angler.isAlive() || itemstack == null || itemstack.getItem() != Item.toolFishingrod || this.distanceToSqr(this.angler) > 1024.0) {
                    this.remove();
                    this.angler.fishEntity = null;
                    return;
                }
                if (this.bobber != null) {
                    if (!this.bobber.removed) {
                        this.x = this.bobber.x;
                        this.y = this.bobber.bb.minY + (double)this.bobber.bbHeight * 0.8;
                        this.z = this.bobber.z;
                        return;
                    }
                    this.bobber = null;
                }
            }
            if (this.shake > 0) {
                --this.shake;
            }
            if (this.inGround) {
                int i = this.world.getBlockId(this.xTile, this.yTile, this.zTile);
                if (i != this.inTile) {
                    this.inGround = false;
                    this.xd *= (double)(this.random.nextFloat() * 0.2f);
                    this.yd *= (double)(this.random.nextFloat() * 0.2f);
                    this.zd *= (double)(this.random.nextFloat() * 0.2f);
                    this.ticksInGround = 0;
                    this.ticksInAir = 0;
                    break block34;
                } else {
                    ++this.ticksInGround;
                    if (this.ticksInGround == 1200) {
                        this.remove();
                    }
                    return;
                }
            }
            ++this.ticksInAir;
        }
        Vec3d vec3d = Vec3d.createVector(this.x, this.y, this.z);
        Vec3d vec3d1 = Vec3d.createVector(this.x + this.xd, this.y + this.yd, this.z + this.zd);
        HitResult movingobjectposition = this.world.checkBlockCollisionBetweenPoints(vec3d, vec3d1);
        vec3d = Vec3d.createVector(this.x, this.y, this.z);
        vec3d1 = Vec3d.createVector(this.x + this.xd, this.y + this.yd, this.z + this.zd);
        if (movingobjectposition != null) {
            vec3d1 = Vec3d.createVector(movingobjectposition.location.xCoord, movingobjectposition.location.yCoord, movingobjectposition.location.zCoord);
        }
        Entity entity = null;
        List<Entity> list = this.world.getEntitiesWithinAABBExcludingEntity(this, this.bb.addCoord(this.xd, this.yd, this.zd).expand(1.0, 1.0, 1.0));
        double d3 = 0.0;
        for (int j = 0; j < list.size(); ++j) {
            double d6;
            float f2;
            AABB axisalignedbb;
            HitResult movingobjectposition1;
            Entity entity1 = list.get(j);
            if (!entity1.isPickable() || entity1 == this.angler && this.ticksInAir < 5 || (movingobjectposition1 = (axisalignedbb = entity1.bb.expand(f2 = 0.3f, f2, f2)).func_1169_a(vec3d, vec3d1)) == null || !((d6 = vec3d.distanceTo(movingobjectposition1.location)) < d3) && d3 != 0.0) continue;
            entity = entity1;
            d3 = d6;
        }
        if (entity != null) {
            movingobjectposition = new HitResult(entity);
        }
        if (movingobjectposition != null && movingobjectposition.entity != null && movingobjectposition.entity.hurt(this.angler, 0, DamageType.COMBAT)) {
            this.bobber = movingobjectposition.entity;
        }
        if (this.inGround) {
            return;
        }
        this.move(this.xd, this.yd, this.zd);
        float f = MathHelper.sqrt_double(this.xd * this.xd + this.zd * this.zd);
        this.yRot = (float)(Math.atan2(this.xd, this.zd) * 180.0 / 3.1415927410125732);
        this.xRot = (float)(Math.atan2(this.yd, f) * 180.0 / 3.1415927410125732);
        while (this.xRot - this.xRotO < -180.0f) {
            this.xRotO -= 360.0f;
        }
        while (this.xRot - this.xRotO >= 180.0f) {
            this.xRotO += 360.0f;
        }
        while (this.yRot - this.yRotO < -180.0f) {
            this.yRotO -= 360.0f;
        }
        while (this.yRot - this.yRotO >= 180.0f) {
            this.yRotO += 360.0f;
        }
        this.xRot = this.xRotO + (this.xRot - this.xRotO) * 0.2f;
        this.yRot = this.yRotO + (this.yRot - this.yRotO) * 0.2f;
        float f1 = 0.92f;
        if (this.onGround || this.horizontalCollision) {
            f1 = 0.5f;
        }
        int k = 5;
        double d5 = 0.0;
        for (int l = 0; l < k; ++l) {
            double d8 = this.bb.minY + (this.bb.maxY - this.bb.minY) * (double)(l + 0) / (double)k - 0.125 + 0.125;
            double d9 = this.bb.minY + (this.bb.maxY - this.bb.minY) * (double)(l + 1) / (double)k - 0.125 + 0.125;
            AABB axisalignedbb1 = AABB.getBoundingBoxFromPool(this.bb.minX, d8, this.bb.minZ, this.bb.maxX, d9, this.bb.maxZ);
            if (!this.world.isAABBInMaterial(axisalignedbb1, Material.water)) continue;
            d5 += 1.0 / (double)k;
        }
        if (d5 > 0.0) {
            if (this.ticksCatchable > 0) {
                --this.ticksCatchable;
            } else {
                int catchRate = 500;
                int rainRate = 0;
                int algaeRate = 0;
                if (this.world.canBlockBeRainedOn(MathHelper.floor_double(this.x), MathHelper.floor_double(this.y) + 1, MathHelper.floor_double(this.z))) {
                    rainRate = 200;
                }
                if (this.world.getBlockId(MathHelper.floor_double(this.x), MathHelper.floor_double(this.y) + 1, MathHelper.floor_double(this.z)) == Block.algae.id) {
                    algaeRate = 100;
                }
                if (this.random.nextInt(catchRate = catchRate - rainRate - algaeRate) == 0) {
                    this.ticksCatchable = this.random.nextInt(30) + 10;
                    this.yd -= (double)0.2f;
                    this.world.playSoundAtEntity(this, "random.splash", 0.25f, 1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.4f);
                    float f3 = MathHelper.floor_double(this.bb.minY);
                    int i1 = 0;
                    while ((float)i1 < 1.0f + this.bbWidth * 20.0f) {
                        float f4 = (this.random.nextFloat() * 2.0f - 1.0f) * this.bbWidth;
                        float f6 = (this.random.nextFloat() * 2.0f - 1.0f) * this.bbWidth;
                        this.world.spawnParticle("bubble", this.x + (double)f4, f3 + 1.0f, this.z + (double)f6, this.xd, this.yd - (double)(this.random.nextFloat() * 0.2f), this.zd);
                        ++i1;
                    }
                    int j1 = 0;
                    while ((float)j1 < 1.0f + this.bbWidth * 20.0f) {
                        float f5 = (this.random.nextFloat() * 2.0f - 1.0f) * this.bbWidth;
                        float f7 = (this.random.nextFloat() * 2.0f - 1.0f) * this.bbWidth;
                        this.world.spawnParticle("splash", this.x + (double)f5, f3 + 1.0f, this.z + (double)f7, this.xd, this.yd, this.zd);
                        ++j1;
                    }
                }
            }
        }
        if (this.ticksCatchable > 0) {
            this.yd -= (double)(this.random.nextFloat() * this.random.nextFloat() * this.random.nextFloat()) * 0.2;
        }
        double d7 = d5 * 2.0 - 1.0;
        this.yd += (double)0.04f * d7;
        if (d5 > 0.0) {
            f1 = (float)((double)f1 * 0.9);
            this.yd *= 0.8;
        }
        this.xd *= (double)f1;
        this.yd *= (double)f1;
        this.zd *= (double)f1;
        this.setPos(this.x, this.y, this.z);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        tag.putShort("xTile", (short)this.xTile);
        tag.putShort("yTile", (short)this.yTile);
        tag.putShort("zTile", (short)this.zTile);
        tag.putShort("inTile", (short)this.inTile);
        tag.putByte("shake", (byte)this.shake);
        tag.putByte("inGround", (byte)(this.inGround ? 1 : 0));
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        this.xTile = tag.getShort("xTile");
        this.yTile = tag.getShort("yTile");
        this.zTile = tag.getShort("zTile");
        this.inTile = tag.getShort("inTile") & 0x3FFF;
        this.shake = tag.getByte("shake") & 0xFF;
        this.inGround = tag.getByte("inGround") == 1;
    }

    @Override
    public float getShadowHeightOffs() {
        return 0.0f;
    }

    public int catchFish() {
        int byte0 = 0;
        if (this.bobber != null) {
            double d = this.angler.x - this.x;
            double d2 = this.angler.y - this.y;
            double d4 = this.angler.z - this.z;
            double d6 = MathHelper.sqrt_double(d * d + d2 * d2 + d4 * d4);
            double d8 = 0.1;
            this.bobber.xd += d * d8;
            this.bobber.yd += d2 * d8 + (double)MathHelper.sqrt_double(d6) * 0.08;
            this.bobber.zd += d4 * d8;
            byte0 = 3;
        } else if (this.ticksCatchable > 0) {
            EntityItem entityitem = new EntityItem(this.world, this.x, this.y, this.z, new ItemStack(Item.foodFishRaw));
            double d1 = this.angler.x - this.x;
            double d3 = this.angler.y - this.y;
            double d5 = this.angler.z - this.z;
            double d7 = MathHelper.sqrt_double(d1 * d1 + d3 * d3 + d5 * d5);
            double d9 = 0.1;
            entityitem.xd = d1 * d9;
            entityitem.yd = d3 * d9 + (double)MathHelper.sqrt_double(d7) * 0.08;
            entityitem.zd = d5 * d9;
            this.world.entityJoinedWorld(entityitem);
            this.angler.addStat(StatList.fishCaughtStat, 1);
            byte0 = 1;
        }
        if (this.inGround) {
            byte0 = 2;
        }
        this.remove();
        this.angler.fishEntity = null;
        return byte0;
    }
}

