/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.entity.animal;

import com.mojang.nbt.CompoundTag;
import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityItem;
import net.minecraft.core.entity.animal.EntityAnimal;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.enums.EnumBlockSoundEffectType;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.DamageType;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;

public class EntitySheep
extends EntityAnimal {
    public static final float[][] fleeceColorTable = new float[][]{{1.0f, 1.0f, 1.0f}, {0.95f, 0.7f, 0.2f}, {0.9f, 0.5f, 0.85f}, {0.6f, 0.7f, 0.95f}, {0.9f, 0.9f, 0.2f}, {0.5f, 0.8f, 0.1f}, {0.95f, 0.7f, 0.8f}, {0.3f, 0.3f, 0.3f}, {0.6f, 0.6f, 0.6f}, {0.3f, 0.6f, 0.7f}, {0.7f, 0.4f, 0.9f}, {0.2f, 0.4f, 0.8f}, {0.5f, 0.4f, 0.3f}, {0.4f, 0.5f, 0.2f}, {0.8f, 0.3f, 0.3f}, {0.1f, 0.1f, 0.1f}};
    private int growthTimer;
    public int timeSheepEating;
    public int prevTimeSheepEating;

    public EntitySheep(World world) {
        super(world);
        this.skinName = "sheep";
        this.setSize(0.9f, 1.3f);
    }

    @Override
    protected void init() {
        super.init();
        this.entityData.define(16, (byte)0);
        this.entityData.define(17, (byte)0);
    }

    @Override
    public void spawnInit() {
        super.init();
        this.setFleeceColor(EntitySheep.getRandomFleeceColor(this.random));
    }

    @Override
    public boolean hurt(Entity entity, int i, DamageType type) {
        return super.hurt(entity, i, type);
    }

    @Override
    protected void dropFewItems() {
        if (!this.getSheared()) {
            this.spawnAtLocation(new ItemStack(Block.wool.id, 1, this.getFleeceColor()), 0.0f);
        }
    }

    @Override
    protected int getDropItemId() {
        return Block.wool.id;
    }

    @Override
    public boolean interact(EntityPlayer entityplayer) {
        if (super.interact(entityplayer)) {
            return true;
        }
        ItemStack itemstack = entityplayer.inventory.getCurrentItem();
        if (!(itemstack == null || itemstack.itemID != Item.toolShears.id && itemstack.itemID != Item.toolShearsSteel.id || this.getSheared())) {
            if (!this.world.isClientSide) {
                this.setSheared(true);
                int count = 2 + this.random.nextInt(3);
                for (int j = 0; j < count; ++j) {
                    EntityItem entityitem = this.spawnAtLocation(new ItemStack(Block.wool.id, 1, this.getFleeceColor()), 1.0f);
                    entityitem.yd += (double)(this.random.nextFloat() * 0.05f);
                    entityitem.xd += (double)((this.random.nextFloat() - this.random.nextFloat()) * 0.1f);
                    entityitem.zd += (double)((this.random.nextFloat() - this.random.nextFloat()) * 0.1f);
                }
            }
            itemstack.damageItem(1, entityplayer);
        }
        return false;
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putBoolean("Sheared", this.getSheared());
        tag.putByte("Color", (byte)this.getFleeceColor());
        tag.putShort("GrowthTimer", (short)this.growthTimer);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setSheared(tag.getBoolean("Sheared"));
        this.setFleeceColor(tag.getByte("Color"));
        this.setGrowthTimer(tag.getShort("GrowthTimer"));
    }

    @Override
    protected boolean isMovementBlocked() {
        return super.isMovementBlocked() || this.getIsSheepEating();
    }

    public boolean getIsSheepEating() {
        return this.entityData.getByte(17) != 0;
    }

    protected void setIsSheepEating(boolean value) {
        this.entityData.set(17, (byte)(value ? 1 : 0));
    }

    @Override
    public void onLivingUpdate() {
        Block blockBelow;
        int blockZ;
        int blockY;
        int blockX;
        super.onLivingUpdate();
        if (this.getSheared()) {
            ++this.growthTimer;
        }
        if (this.growthTimer > 400) {
            blockX = MathHelper.floor_double(this.x);
            blockY = MathHelper.floor_double(this.y);
            blockZ = MathHelper.floor_double(this.z);
            blockBelow = this.world.getBlock(blockX, blockY - 1, blockZ);
            this.growthTimer = 0;
            if (!(blockBelow != Block.grass && blockBelow != Block.grassRetro || this.world.isClientSide)) {
                this.setIsSheepEating(true);
            }
            this.timeSheepEating = 0;
            this.prevTimeSheepEating = 0;
        }
        if (this.getIsSheepEating()) {
            blockX = MathHelper.floor_double(this.x);
            blockY = MathHelper.floor_double(this.y);
            blockZ = MathHelper.floor_double(this.z);
            blockBelow = this.world.getBlock(blockX, blockY - 1, blockZ);
            if (this.timeSheepEating >= 5 && this.timeSheepEating <= 35 && this.timeSheepEating % 5 == 0) {
                this.world.playBlockSoundEffect(this.x + 0.5, this.y + 0.5, this.z + 0.5, Block.grass, EnumBlockSoundEffectType.DIG);
            }
            this.prevTimeSheepEating = this.timeSheepEating++;
            if (!(this.prevTimeSheepEating != 35 || blockBelow != Block.grass && blockBelow != Block.grassRetro || this.world.isClientSide)) {
                this.world.playSoundEffectForPlayer(null, 2001, (int)this.x, (int)this.y - 1, (int)this.z, this.world.getBlockId((int)this.x, (int)this.y - 1, (int)this.z));
                this.world.setBlockWithNotify(blockX, blockY - 1, blockZ, Block.dirt.id);
                this.setSheared(false);
            }
            if (this.prevTimeSheepEating >= 40) {
                this.prevTimeSheepEating = 0;
                this.timeSheepEating = 0;
                if (!this.world.isClientSide) {
                    this.setIsSheepEating(false);
                }
            }
        }
    }

    @Override
    protected String getLivingSound() {
        return "mob.sheep";
    }

    @Override
    protected String getHurtSound() {
        return "mob.sheep";
    }

    @Override
    protected String getDeathSound() {
        return "mob.sheep";
    }

    public int getFleeceColor() {
        return this.entityData.getByte(16) & 0xF;
    }

    public void setFleeceColor(int i) {
        byte byte0 = this.entityData.getByte(16);
        this.entityData.set(16, (byte)(byte0 & 0xF0 | i & 0xF));
    }

    public boolean getSheared() {
        return (this.entityData.getByte(16) & 0x10) != 0;
    }

    public void setSheared(boolean flag) {
        byte byte0 = this.entityData.getByte(16);
        if (flag) {
            this.entityData.set(16, (byte)(byte0 | 0x10));
        } else {
            this.entityData.set(16, (byte)(byte0 & 0xFFFFFFEF));
        }
    }

    public static int getRandomFleeceColor(Random random) {
        int i = random.nextInt(100);
        if (i < 5) {
            return 15;
        }
        if (i < 10) {
            return 7;
        }
        if (i < 15) {
            return 8;
        }
        if (i < 18) {
            return 12;
        }
        return random.nextInt(500) != 0 ? 0 : 6;
    }

    public void setGrowthTimer(int growthTimer) {
        this.growthTimer = growthTimer;
    }
}

