/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.entity.animal;

import com.mojang.nbt.CompoundTag;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.animal.EntityWaterAnimal;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;

public class EntitySquid
extends EntityWaterAnimal {
    public float field_21089_a = 0.0f;
    public float field_21088_b = 0.0f;
    public float field_21087_c = 0.0f;
    public float field_21086_f = 0.0f;
    public float field_21085_g = 0.0f;
    public float field_21084_h = 0.0f;
    public float field_21083_i = 0.0f;
    public float field_21082_j = 0.0f;
    private float randomMotionSpeed = 0.0f;
    private float field_21080_l = 0.0f;
    private float field_21079_m = 0.0f;
    private float randomMotionVecX = 0.0f;
    private float randomMotionVecY = 0.0f;
    private float randomMotionVecZ = 0.0f;

    public EntitySquid(World world) {
        super(world);
        this.skinName = "squid";
        this.highestSkinVariant = 3;
        this.setSize(0.95f, 0.95f);
        this.field_21080_l = 1.0f / (this.random.nextFloat() + 1.0f) * 0.2f;
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
    }

    @Override
    protected String getLivingSound() {
        return null;
    }

    @Override
    protected String getHurtSound() {
        return null;
    }

    @Override
    protected String getDeathSound() {
        return null;
    }

    @Override
    protected float getSoundVolume() {
        return 0.4f;
    }

    @Override
    protected int getDropItemId() {
        return 0;
    }

    @Override
    protected void dropFewItems() {
        int i = this.random.nextInt(3) + 1;
        for (int j = 0; j < i; ++j) {
            this.spawnAtLocation(new ItemStack(Item.dye, 1, 0), 0.0f);
        }
    }

    @Override
    public boolean interact(EntityPlayer entityplayer) {
        return super.interact(entityplayer);
    }

    @Override
    public boolean isInWater() {
        return this.world.handleMaterialAcceleration(this.bb.expand(0.0, -0.6f, 0.0), Material.water, this);
    }

    @Override
    public void onLivingUpdate() {
        super.onLivingUpdate();
        this.field_21088_b = this.field_21089_a;
        this.field_21086_f = this.field_21087_c;
        this.field_21084_h = this.field_21085_g;
        this.field_21082_j = this.field_21083_i;
        this.field_21085_g += this.field_21080_l;
        if (this.field_21085_g > 6.283185f) {
            this.field_21085_g -= 6.283185f;
            if (this.random.nextInt(10) == 0) {
                this.field_21080_l = 1.0f / (this.random.nextFloat() + 1.0f) * 0.2f;
            }
        }
        if (this.isInWater()) {
            if (this.field_21085_g < 3.141593f) {
                float f = this.field_21085_g / 3.141593f;
                this.field_21083_i = MathHelper.sin(f * f * 3.141593f) * 3.141593f * 0.25f;
                if ((double)f > 0.75) {
                    this.randomMotionSpeed = 1.0f;
                    this.field_21079_m = 1.0f;
                } else {
                    this.field_21079_m *= 0.8f;
                }
            } else {
                this.field_21083_i = 0.0f;
                this.randomMotionSpeed *= 0.9f;
                this.field_21079_m *= 0.99f;
            }
            if (!this.isMultiplayerEntity) {
                this.xd = this.randomMotionVecX * this.randomMotionSpeed;
                this.yd = this.randomMotionVecY * this.randomMotionSpeed;
                this.zd = this.randomMotionVecZ * this.randomMotionSpeed;
            }
            float f1 = MathHelper.sqrt_double(this.xd * this.xd + this.zd * this.zd);
            this.renderYawOffset += (-((float)Math.atan2(this.xd, this.zd)) * 180.0f / 3.141593f - this.renderYawOffset) * 0.1f;
            this.yRot = this.renderYawOffset;
            this.field_21087_c += 3.141593f * this.field_21079_m * 1.5f;
            this.field_21089_a += (-((float)Math.atan2(f1, this.yd)) * 180.0f / 3.141593f - this.field_21089_a) * 0.1f;
        } else {
            this.field_21083_i = MathHelper.abs(MathHelper.sin(this.field_21085_g)) * 3.141593f * 0.25f;
            if (!this.isMultiplayerEntity) {
                this.xd = 0.0;
                this.yd -= 0.08;
                this.yd *= (double)0.98f;
                this.zd = 0.0;
            }
            this.field_21089_a = (float)((double)this.field_21089_a + (double)(-90.0f - this.field_21089_a) * 0.02);
        }
    }

    @Override
    public void moveEntityWithHeading(float moveStrafing, float moveForward) {
        this.move(this.xd, this.yd, this.zd);
    }

    @Override
    protected void updatePlayerActionState() {
        if (this.random.nextInt(50) == 0 || !this.wasInWater || this.randomMotionVecX == 0.0f && this.randomMotionVecY == 0.0f && this.randomMotionVecZ == 0.0f) {
            float f = this.random.nextFloat() * 3.141593f * 2.0f;
            this.randomMotionVecX = MathHelper.cos(f) * 0.2f;
            this.randomMotionVecY = -0.1f + this.random.nextFloat() * 0.2f;
            this.randomMotionVecZ = MathHelper.sin(f) * 0.2f;
        }
        this.tryToDespawn();
    }
}

