/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.entity.fx;

import net.minecraft.client.render.Tessellator;
import net.minecraft.client.render.block.color.BlockColor;
import net.minecraft.client.render.block.color.BlockColorDispatcher;
import net.minecraft.core.Global;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLeavesBase;
import net.minecraft.core.entity.fx.EntityFX;
import net.minecraft.core.world.World;

public class EntityLeafFX
extends EntityFX {
    public EntityLeafFX(World world, double d, double d1, double d2, double d3, double d4, double d5) {
        super(world, d, d1, d2, d3, d4, d5);
        this.particleTextureIndex = Block.texCoordToIndex(2, 20);
        this.particleGravity = 0.125f;
        this.particleScale /= 2.0f;
        this.particleMaxAge = (int)((float)this.particleMaxAge * 16.0f);
        this.yd = 0.0;
        this.xd = 0.0;
        this.zd = 0.0;
    }

    public EntityLeafFX func_4041_a(int i, int j, int k) {
        Block block = Block.blocksList[this.world.getBlockId(i, j, k)];
        if (!(block instanceof BlockLeavesBase)) {
            this.remove();
        }
        int l = ((BlockColor)BlockColorDispatcher.getInstance().getDispatch(block)).getWorldColor(this.world, i, j, k);
        this.particleRed *= (float)(l >> 16 & 0xFF) / 255.0f;
        this.particleGreen *= (float)(l >> 8 & 0xFF) / 255.0f;
        this.particleBlue *= (float)(l & 0xFF) / 255.0f;
        return this;
    }

    @Override
    public void tick() {
        float windDirection = this.world.worldType.getWindManager().getWindDirection(this.world, (float)this.x, (float)this.y, (float)this.z);
        float windIntensity = this.world.worldType.getWindManager().getWindIntensity(this.world, (float)this.x, (float)this.y, (float)this.z) * 0.01f;
        float dx = (float)(Math.cos((double)windDirection * Math.PI * 2.0) * (double)windIntensity);
        float dz = (float)(Math.sin((double)windDirection * Math.PI * 2.0) * (double)windIntensity);
        this.xd += (double)dx;
        this.zd += (double)dz;
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.particleAge++ >= this.particleMaxAge) {
            this.remove();
        }
        this.yd -= 0.04 * (double)this.particleGravity;
        if (this.onGround) {
            this.xd *= 0.0;
            this.zd *= 0.0;
        }
        this.move(this.xd, this.yd, this.zd);
    }

    @Override
    public int getFXLayer() {
        return 1;
    }

    @Override
    public void renderParticle(Tessellator t, float renderPartialTicks, float rotationX, float rotationXZ, float rotationZ, float rotationYZ, float rotationXY) {
        float f6 = ((float)(this.particleTextureIndex % Global.TEXTURE_ATLAS_WIDTH_TILES) + this.particleTextureJitterX / 4.0f) / (float)Global.TEXTURE_ATLAS_WIDTH_TILES;
        float f7 = f6 + 0.25f / (float)Global.TEXTURE_ATLAS_WIDTH_TILES;
        float f8 = ((float)(this.particleTextureIndex / Global.TEXTURE_ATLAS_WIDTH_TILES) + this.particleTextureJitterY / 4.0f) / (float)Global.TEXTURE_ATLAS_WIDTH_TILES;
        float f9 = f8 + 0.25f / (float)Global.TEXTURE_ATLAS_WIDTH_TILES;
        float f10 = 0.1f * this.particleScale;
        float f11 = (float)(this.xo + (this.x - this.xo) * (double)renderPartialTicks - lerpPosX);
        float f12 = (float)(this.yo + (this.y - this.yo) * (double)renderPartialTicks - lerpPosY);
        float f13 = (float)(this.zo + (this.z - this.zo) * (double)renderPartialTicks - lerpPosZ);
        float f14 = this.getBrightness(renderPartialTicks);
        t.setColorOpaque_F(f14 * this.particleRed, f14 * this.particleGreen, f14 * this.particleBlue);
        t.addVertexWithUV(f11 - rotationX * f10 - rotationYZ * f10, f12 - rotationXZ * f10, f13 - rotationZ * f10 - rotationXY * f10, f6, f9);
        t.addVertexWithUV(f11 - rotationX * f10 + rotationYZ * f10, f12 + rotationXZ * f10, f13 - rotationZ * f10 + rotationXY * f10, f6, f8);
        t.addVertexWithUV(f11 + rotationX * f10 + rotationYZ * f10, f12 + rotationXZ * f10, f13 + rotationZ * f10 + rotationXY * f10, f7, f8);
        t.addVertexWithUV(f11 + rotationX * f10 - rotationYZ * f10, f12 - rotationXZ * f10, f13 + rotationZ * f10 - rotationXY * f10, f7, f9);
    }
}

