/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.entity.monster;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityItem;
import net.minecraft.core.entity.monster.EntityZombie;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.DamageType;
import net.minecraft.core.world.World;

public class EntityArmoredZombie
extends EntityZombie {
    private final boolean isHoldingSword;
    public final int[] armorBreakOrder = new int[4];
    public final int[] armorBreakPoints = new int[4];
    private static final ItemStack defaultHeldItem = new ItemStack(Item.toolSwordIron, 1);

    public EntityArmoredZombie(World world) {
        super(world);
        int i;
        this.skinName = "zombie_armored";
        this.highestSkinVariant = 0;
        Random rand = new Random();
        this.isHoldingSword = rand.nextInt(5) == 0;
        this.attackStrength = this.isHoldingSword ? 4 : 2;
        this.health = 40;
        ArrayList<Integer> armorItems = new ArrayList<Integer>();
        armorItems.add(0);
        armorItems.add(1);
        armorItems.add(2);
        armorItems.add(3);
        for (i = 0; i < 4; ++i) {
            int index = rand.nextInt(armorItems.size());
            this.armorBreakOrder[i] = (Integer)armorItems.get(index);
            armorItems.remove(index);
        }
        for (i = 0; i < 4; ++i) {
            this.armorBreakPoints[i] = 30 - 10 * i + rand.nextInt(10);
        }
    }

    @Override
    protected int getDropItemId() {
        return Item.cloth.id;
    }

    @Override
    public void onLivingUpdate() {
        super.onLivingUpdate();
    }

    @Override
    public boolean hurt(Entity entity, int i, DamageType type) {
        int lastHealth = this.health;
        boolean result = super.hurt(entity, i, type);
        for (int j = 0; j < 4; ++j) {
            if (this.health > this.armorBreakPoints[j] || lastHealth <= this.armorBreakPoints[j]) continue;
            int numChainlinks = this.random.nextInt(2);
            for (int k = 0; k < numChainlinks; ++k) {
                EntityItem entityitem = this.spawnAtLocation(new ItemStack(Item.chainlink), 1.0f);
                entityitem.yd += (double)(this.random.nextFloat() * 0.05f);
                entityitem.xd += (double)((this.random.nextFloat() - this.random.nextFloat()) * 0.1f);
                entityitem.zd += (double)((this.random.nextFloat() - this.random.nextFloat()) * 0.1f);
            }
        }
        return result;
    }

    @Override
    public ItemStack getHeldItem() {
        if (this.isHoldingSword) {
            return defaultHeldItem;
        }
        return null;
    }
}

