/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.entity.projectile;

import net.minecraft.core.entity.EntityLiving;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.entity.projectile.EntityArrow;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.world.World;

public class EntityArrowGolden
extends EntityArrow {
    public EntityArrowGolden(World world) {
        super(world, 2);
        this.noPhysics = true;
        this.stack = new ItemStack(Item.ammoArrowGold);
    }

    public EntityArrowGolden(World world, double d, double d1, double d2) {
        super(world, d, d1, d2, 2);
        this.noPhysics = true;
        this.stack = new ItemStack(Item.ammoArrowGold);
    }

    public EntityArrowGolden(World world, EntityLiving entityliving, boolean doesArrowBelongToPlayer) {
        super(world, entityliving, doesArrowBelongToPlayer, 2);
        this.noPhysics = true;
        this.stack = new ItemStack(Item.ammoArrowGold);
    }

    @Override
    protected void init() {
        this.arrowGravity = 0.02f;
        this.arrowSpeed = 1.0f;
        this.arrowDamage = 2;
    }

    @Override
    public void playerTouch(EntityPlayer player) {
        if (this.world.isClientSide) {
            return;
        }
        if (this.inGround && this.arrowShake <= 0) {
            player.inventory.insertItem(this.stack, true);
            if (this.stack.stackSize <= 0) {
                this.world.playSoundAtEntity(this, "random.pop", 0.2f, ((this.random.nextFloat() - this.random.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                player.onItemPickup(this, Item.ammoArrowGold.id);
                this.remove();
            }
        }
    }
}

