/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.entity.projectile;

import com.mojang.nbt.CompoundTag;
import java.util.List;
import net.minecraft.core.HitResult;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityLiving;
import net.minecraft.core.entity.animal.EntityChicken;
import net.minecraft.core.util.helper.DamageType;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.util.phys.Vec3d;
import net.minecraft.core.world.World;

public class EntityEgg
extends Entity {
    private int field_20056_b = -1;
    private int field_20055_c = -1;
    private int field_20054_d = -1;
    private int field_20053_e = 0;
    private boolean field_20052_f = false;
    public int field_20057_a = 0;
    private EntityLiving field_20051_g;
    private int field_20050_h;
    private int field_20049_i = 0;

    public EntityEgg(World world) {
        super(world);
        this.setSize(0.25f, 0.25f);
    }

    @Override
    protected void init() {
    }

    @Override
    public boolean shouldRenderAtSqrDistance(double distance) {
        double d1 = this.bb.getAverageEdgeLength() * 4.0;
        return distance < (d1 *= 64.0) * d1;
    }

    public EntityEgg(World world, EntityLiving entityliving) {
        super(world);
        this.field_20051_g = entityliving;
        this.setSize(0.25f, 0.25f);
        this.moveTo(entityliving.x, entityliving.y + (double)entityliving.getHeadHeight(), entityliving.z, entityliving.yRot, entityliving.xRot);
        this.x -= (double)(MathHelper.cos(this.yRot / 180.0f * 3.141593f) * 0.16f);
        this.y -= (double)0.1f;
        this.z -= (double)(MathHelper.sin(this.yRot / 180.0f * 3.141593f) * 0.16f);
        this.setPos(this.x, this.y, this.z);
        this.heightOffset = 0.0f;
        float f = 0.4f;
        this.xd = -MathHelper.sin(this.yRot / 180.0f * 3.141593f) * MathHelper.cos(this.xRot / 180.0f * 3.141593f) * f;
        this.zd = MathHelper.cos(this.yRot / 180.0f * 3.141593f) * MathHelper.cos(this.xRot / 180.0f * 3.141593f) * f;
        this.yd = -MathHelper.sin(this.xRot / 180.0f * 3.141593f) * f;
        this.setEggHeading(this.xd, this.yd, this.zd, 1.5f, 1.0f);
    }

    public EntityEgg(World world, double d, double d1, double d2) {
        super(world);
        this.field_20050_h = 0;
        this.setSize(0.25f, 0.25f);
        this.setPos(d, d1, d2);
        this.heightOffset = 0.0f;
    }

    public void setEggHeading(double d, double d1, double d2, float f, float f1) {
        float f2 = MathHelper.sqrt_double(d * d + d1 * d1 + d2 * d2);
        d /= (double)f2;
        d1 /= (double)f2;
        d2 /= (double)f2;
        d += this.random.nextGaussian() * (double)0.0075f * (double)f1;
        d1 += this.random.nextGaussian() * (double)0.0075f * (double)f1;
        d2 += this.random.nextGaussian() * (double)0.0075f * (double)f1;
        this.xd = d *= (double)f;
        this.yd = d1 *= (double)f;
        this.zd = d2 *= (double)f;
        float f3 = MathHelper.sqrt_double(d * d + d2 * d2);
        this.yRotO = this.yRot = (float)(Math.atan2(d, d2) * 180.0 / 3.1415927410125732);
        this.xRotO = this.xRot = (float)(Math.atan2(d1, f3) * 180.0 / 3.1415927410125732);
        this.field_20050_h = 0;
    }

    @Override
    public void lerpMotion(double xd, double yd, double zd) {
        this.xd = xd;
        this.yd = yd;
        this.zd = zd;
        if (this.xRotO == 0.0f && this.yRotO == 0.0f) {
            float f = MathHelper.sqrt_double(xd * xd + zd * zd);
            this.yRotO = this.yRot = (float)(Math.atan2(xd, zd) * 180.0 / 3.1415927410125732);
            this.xRotO = this.xRot = (float)(Math.atan2(yd, f) * 180.0 / 3.1415927410125732);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void tick() {
        block21: {
            this.xOld = this.x;
            this.yOld = this.y;
            this.zOld = this.z;
            super.tick();
            if (this.field_20057_a > 0) {
                --this.field_20057_a;
            }
            if (this.field_20052_f) {
                int i = this.world.getBlockId(this.field_20056_b, this.field_20055_c, this.field_20054_d);
                if (i != this.field_20053_e) {
                    this.field_20052_f = false;
                    this.xd *= (double)(this.random.nextFloat() * 0.2f);
                    this.yd *= (double)(this.random.nextFloat() * 0.2f);
                    this.zd *= (double)(this.random.nextFloat() * 0.2f);
                    this.field_20050_h = 0;
                    this.field_20049_i = 0;
                    break block21;
                } else {
                    ++this.field_20050_h;
                    if (this.field_20050_h == 1200) {
                        this.remove();
                    }
                    return;
                }
            }
            ++this.field_20049_i;
        }
        Vec3d vec3d = Vec3d.createVector(this.x, this.y, this.z);
        Vec3d vec3d1 = Vec3d.createVector(this.x + this.xd, this.y + this.yd, this.z + this.zd);
        HitResult movingobjectposition = this.world.checkBlockCollisionBetweenPoints(vec3d, vec3d1);
        vec3d = Vec3d.createVector(this.x, this.y, this.z);
        vec3d1 = Vec3d.createVector(this.x + this.xd, this.y + this.yd, this.z + this.zd);
        if (movingobjectposition != null) {
            vec3d1 = Vec3d.createVector(movingobjectposition.location.xCoord, movingobjectposition.location.yCoord, movingobjectposition.location.zCoord);
        }
        if (!this.world.isClientSide) {
            Entity entity = null;
            List<Entity> list = this.world.getEntitiesWithinAABBExcludingEntity(this, this.bb.addCoord(this.xd, this.yd, this.zd).expand(1.0, 1.0, 1.0));
            double d = 0.0;
            for (int i1 = 0; i1 < list.size(); ++i1) {
                double d1;
                float f4;
                AABB axisalignedbb;
                HitResult movingobjectposition1;
                Entity entity1 = list.get(i1);
                if (!entity1.isPickable() || entity1 == this.field_20051_g && this.field_20049_i < 5 || (movingobjectposition1 = (axisalignedbb = entity1.bb.expand(f4 = 0.3f, f4, f4)).func_1169_a(vec3d, vec3d1)) == null || !((d1 = vec3d.distanceTo(movingobjectposition1.location)) < d) && d != 0.0) continue;
                entity = entity1;
                d = d1;
            }
            if (entity != null) {
                movingobjectposition = new HitResult(entity);
            }
        }
        if (movingobjectposition != null) {
            if (movingobjectposition.entity == null || !movingobjectposition.entity.hurt(this.field_20051_g, 0, DamageType.COMBAT)) {
                // empty if block
            }
            if (!this.world.isClientSide && this.random.nextInt(8) == 0) {
                int byte0 = 1;
                if (this.random.nextInt(32) == 0) {
                    byte0 = 4;
                }
                for (int k = 0; k < byte0; ++k) {
                    EntityChicken entitychicken = new EntityChicken(this.world);
                    entitychicken.moveTo(this.x, this.y, this.z, this.yRot, 0.0f);
                    this.world.entityJoinedWorld(entitychicken);
                }
            }
            for (int j = 0; j < 8; ++j) {
                this.world.spawnParticle("snowballpoof", this.x, this.y, this.z, 0.0, 0.0, 0.0);
            }
            this.remove();
        }
        this.x += this.xd;
        this.y += this.yd;
        this.z += this.zd;
        float f = MathHelper.sqrt_double(this.xd * this.xd + this.zd * this.zd);
        this.yRot = (float)(Math.atan2(this.xd, this.zd) * 180.0 / 3.1415927410125732);
        this.xRot = (float)(Math.atan2(this.yd, f) * 180.0 / 3.1415927410125732);
        while (this.xRot - this.xRotO < -180.0f) {
            this.xRotO -= 360.0f;
        }
        while (this.xRot - this.xRotO >= 180.0f) {
            this.xRotO += 360.0f;
        }
        while (this.yRot - this.yRotO < -180.0f) {
            this.yRotO -= 360.0f;
        }
        while (this.yRot - this.yRotO >= 180.0f) {
            this.yRotO += 360.0f;
        }
        this.xRot = this.xRotO + (this.xRot - this.xRotO) * 0.2f;
        this.yRot = this.yRotO + (this.yRot - this.yRotO) * 0.2f;
        float f1 = 0.99f;
        float f2 = 0.03f;
        if (this.isInWater()) {
            for (int l = 0; l < 4; ++l) {
                float f3 = 0.25f;
                this.world.spawnParticle("bubble", this.x - this.xd * (double)f3, this.y - this.yd * (double)f3, this.z - this.zd * (double)f3, this.xd, this.yd, this.zd);
            }
            f1 = 0.8f;
        }
        this.xd *= (double)f1;
        this.yd *= (double)f1;
        this.zd *= (double)f1;
        this.yd -= (double)f2;
        this.setPos(this.x, this.y, this.z);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        tag.putShort("xTile", (short)this.field_20056_b);
        tag.putShort("yTile", (short)this.field_20055_c);
        tag.putShort("zTile", (short)this.field_20054_d);
        tag.putShort("inTile", (short)this.field_20053_e);
        tag.putByte("shake", (byte)this.field_20057_a);
        tag.putByte("inGround", (byte)(this.field_20052_f ? 1 : 0));
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        this.field_20056_b = tag.getShort("xTile");
        this.field_20055_c = tag.getShort("yTile");
        this.field_20054_d = tag.getShort("zTile");
        this.field_20053_e = tag.getShort("inTile") & 0x3FFF;
        this.field_20057_a = tag.getByte("shake") & 0xFF;
        this.field_20052_f = tag.getByte("inGround") == 1;
    }

    @Override
    public float getShadowHeightOffs() {
        return 0.0f;
    }
}

