/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.item;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.entity.TileEntityFlag;
import net.minecraft.core.block.material.MaterialColor;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemComplex;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.net.packet.Packet;
import net.minecraft.core.net.packet.Packet131MapData;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.chunk.Chunk;
import net.minecraft.core.world.saveddata.maps.ItemMapSavedData;

public class ItemMap
extends ItemComplex {
    protected ItemMap(String name, int id) {
        super(name, id);
        this.setMaxStackSize(1);
    }

    public static ItemMapSavedData getOrCreateSavedData(short word0, World world) {
        String s = "map_" + word0;
        ItemMapSavedData mapData = (ItemMapSavedData)world.getSavedData(ItemMapSavedData.class, "map_" + word0);
        if (mapData == null) {
            int mapId = world.getUniqueDataId("map");
            String stringId = "map_" + mapId;
            mapData = new ItemMapSavedData(stringId);
            world.setSavedData(stringId, mapData);
        }
        return mapData;
    }

    public ItemMapSavedData getOrCreateSavedData(ItemStack stack, World world) {
        String s = "map_" + stack.getMetadata();
        ItemMapSavedData mapData = (ItemMapSavedData)world.getSavedData(ItemMapSavedData.class, "map_" + stack.getMetadata());
        if (mapData == null) {
            stack.setMetadata(world.getUniqueDataId("map"));
            String s1 = "map_" + stack.getMetadata();
            mapData = new ItemMapSavedData(s1);
            mapData.x = world.getLevelData().getSpawnX();
            mapData.z = world.getLevelData().getSpawnZ();
            mapData.scale = (byte)3;
            mapData.dimension = (byte)world.dimension.id;
            mapData.setDirty();
            world.setSavedData(s1, mapData);
        }
        return mapData;
    }

    @Override
    public boolean onItemUse(ItemStack itemstack, EntityPlayer entityplayer, World world, int blockX, int blockY, int blockZ, Side side, double xPlaced, double yPlaced) {
        if (world.getBlockId(blockX, blockY, blockZ) == Block.flag.id) {
            TileEntityFlag flag;
            ItemMapSavedData mapData = (ItemMapSavedData)world.getSavedData(ItemMapSavedData.class, "map_" + itemstack.getMetadata());
            boolean canCreateMap = mapData.createNewWaypoint(flag = (TileEntityFlag)world.getBlockTileEntity(blockX, blockY, blockZ));
            if (!canCreateMap) {
                entityplayer.addChatMessage("flag.full");
            }
            return canCreateMap;
        }
        return false;
    }

    public void update(World world, Entity entity, ItemMapSavedData data) {
        if (world.dimension.id != data.dimension) {
            return;
        }
        int width = 128;
        int height = 128;
        int scale = 1 << data.scale;
        int centerX = data.x;
        int centerZ = data.z;
        int posX = MathHelper.floor_double(entity.x - (double)centerX) / scale + width / 2;
        int posZ = MathHelper.floor_double(entity.z - (double)centerZ) / scale + height / 2;
        int a = 128 / scale;
        if (world.worldType.hasCeiling()) {
            a /= 2;
        }
        ++data.step;
        for (int x = posX - a + 1; x < posX + a; ++x) {
            if ((x & 0xF) != (data.step & 0xF)) continue;
            int l1 = 255;
            int i2 = 0;
            double d = 0.0;
            for (int z = posZ - a - 1; z < posZ + a; ++z) {
                byte finalColor;
                byte currentColor;
                if (x < 0 || z < -1 || x >= width || z >= height) continue;
                int k2 = x - posX;
                int l2 = z - posZ;
                boolean flag = k2 * k2 + l2 * l2 > (a - 2) * (a - 2);
                int blockX = (centerX / scale + x - width / 2) * scale;
                int blockZ = (centerZ / scale + z - height / 2) * scale;
                int[] blockCounts = new int[Block.blocksList.length];
                Chunk chunk = world.getChunkFromBlockCoords(blockX, blockZ);
                int blockXInChunk = blockX & 0xF;
                int blockZInChunk = blockZ & 0xF;
                int l4 = 0;
                double d1 = 0.0;
                if (world.worldType.hasCeiling()) {
                    int i5 = blockX + blockZ * 231871;
                    if (((i5 = i5 * i5 * 31287121 + i5 * 11) >> 20 & 1) == 0) {
                        int n = Block.dirt.id;
                        blockCounts[n] = blockCounts[n] + 10;
                    } else {
                        int n = Block.stone.id;
                        blockCounts[n] = blockCounts[n] + 10;
                    }
                    d1 = 100.0;
                } else {
                    for (int i = 0; i < scale; ++i) {
                        for (int j = 0; j < scale; ++j) {
                            int height2 = chunk.getHeightValue(i + blockXInChunk, j + blockZInChunk) + 1;
                            int id = 0;
                            if (height2 > 1) {
                                boolean flag1 = false;
                                do {
                                    flag1 = true;
                                    id = chunk.getBlockID(i + blockXInChunk, height2 - 1, j + blockZInChunk);
                                    if (id == 0) {
                                        flag1 = false;
                                    } else if (height2 > 0 && id > 0 && Block.blocksList[id].blockMaterial.color == MaterialColor.none) {
                                        flag1 = false;
                                    }
                                    if (flag1) continue;
                                    id = chunk.getBlockID(i + blockXInChunk, --height2 - 1, j + blockZInChunk);
                                } while (!flag1);
                                if (id != 0 && Block.blocksList[id].blockMaterial.isLiquid()) {
                                    int i7 = height2 - 1;
                                    int k7 = 0;
                                    do {
                                        k7 = chunk.getBlockID(i + blockXInChunk, i7--, j + blockZInChunk);
                                        ++l4;
                                    } while (i7 > 0 && k7 != 0 && Block.blocksList[k7].blockMaterial.isLiquid());
                                }
                            }
                            d1 += (double)height2 / (double)(scale * scale);
                            int n = id;
                            blockCounts[n] = blockCounts[n] + 1;
                        }
                    }
                }
                l4 /= scale * scale;
                int max = 0;
                int id = 0;
                for (int i = 0; i < Block.blocksList.length; ++i) {
                    if (blockCounts[i] <= max) continue;
                    id = i;
                    max = blockCounts[i];
                }
                double d2 = (d1 - d) * 4.0 / (double)(scale + 4) + ((double)(x + z & 1) - 0.5) * 0.4;
                int byte0 = 1;
                if (d2 > 0.6) {
                    byte0 = 2;
                }
                if (d2 < -0.6) {
                    byte0 = 0;
                }
                int j7 = 0;
                if (id > 0) {
                    MaterialColor mapcolor = Block.blocksList[id].blockMaterial.color;
                    if (mapcolor == MaterialColor.water) {
                        double d3 = (double)l4 * 0.1 + (double)(x + z & 1) * 0.2;
                        byte0 = 1;
                        if (d3 < 0.5) {
                            byte0 = 2;
                        }
                        if (d3 > 0.9) {
                            byte0 = 0;
                        }
                    }
                    j7 = mapcolor.id;
                }
                d = d1;
                if (z < 0 || k2 * k2 + l2 * l2 >= a * a || flag && (x + z & 1) == 0 || (currentColor = data.colors[x + z * width]) == (finalColor = (byte)(j7 * 4 + byte0))) continue;
                if (l1 > z) {
                    l1 = z;
                }
                if (i2 < z) {
                    i2 = z;
                }
                data.colors[x + z * width] = finalColor;
            }
            if (l1 > i2) continue;
            data.setDirty(x, l1, i2);
        }
    }

    @Override
    public void inventoryTick(ItemStack itemstack, World world, Entity entity, int i, boolean flag) {
        if (world.isClientSide) {
            return;
        }
        ItemMapSavedData mapData = this.getOrCreateSavedData(itemstack, world);
        if (entity instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)entity;
            mapData.tickCarriedBy(entityplayer, itemstack);
        }
        if (flag) {
            this.update(world, entity, mapData);
        }
    }

    @Override
    public void onCraftedBy(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        itemstack.setMetadata(world.getUniqueDataId("map"));
        String s = "map_" + itemstack.getMetadata();
        ItemMapSavedData mapdata = new ItemMapSavedData(s);
        world.setSavedData(s, mapdata);
        mapdata.x = MathHelper.floor_double(entityplayer.x);
        mapdata.z = MathHelper.floor_double(entityplayer.z);
        mapdata.scale = (byte)3;
        mapdata.dimension = (byte)world.dimension.id;
        mapdata.setDirty();
    }

    @Override
    public Packet sendPacketData(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        byte[] abyte0 = this.getOrCreateSavedData(itemstack, world).getMapDataBytes(itemstack, world, entityplayer);
        if (abyte0 == null) {
            return null;
        }
        return new Packet131MapData((short)Item.map.id, (short)itemstack.getMetadata(), abyte0);
    }
}

