/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.lang.text;

import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.core.lang.text.Text;

public class TextGroup
extends Text {
    private final Text[] elements;

    private static Text[] flattenArray(Text[] elements) {
        ArrayList<Text> newElements = new ArrayList<Text>();
        for (Text element : elements) {
            if (element instanceof TextGroup) {
                Text[] flatGroupElements = TextGroup.flattenArray(((TextGroup)element).elements);
                newElements.addAll(Arrays.asList(flatGroupElements));
                continue;
            }
            newElements.add(element);
        }
        return newElements.toArray(new Text[0]);
    }

    public TextGroup(Text ... elements) {
        this.elements = TextGroup.flattenArray(elements);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Text element : this.elements) {
            sb.append(element.toString());
        }
        return sb.toString();
    }

    @Override
    public String toDebugString() {
        StringBuilder sb = new StringBuilder();
        sb.append("G{");
        for (int i = 0; i < this.elements.length - 2; ++i) {
            sb.append(this.elements[i].toDebugString()).append(",");
        }
        sb.append(this.elements[this.elements.length - 1].toDebugString());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public Text copy() {
        Text[] newArray = new Text[this.elements.length];
        for (int i = 0; i < this.elements.length; ++i) {
            newArray[i] = this.elements[i].copy();
        }
        return new TextGroup(newArray);
    }
}

