/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net;

import com.mojang.nbt.CompoundTag;
import java.time.LocalDateTime;
import java.time.ZoneOffset;

public class SavedServer {
    public String nickname;
    public String address;
    public LocalDateTime lastPlayed;

    public SavedServer(String nickname, String address, LocalDateTime lastPlayed) {
        this.nickname = nickname;
        this.address = address;
        this.lastPlayed = lastPlayed;
    }

    public static SavedServer readFromTag(CompoundTag tag) {
        return new SavedServer(tag.getString("nickname"), tag.getString("address"), LocalDateTime.ofEpochSecond(tag.getLong("lastPlayed"), 0, ZoneOffset.UTC));
    }

    public void writeToTag(CompoundTag tag, int index) {
        CompoundTag subTag = new CompoundTag();
        subTag.putString("nickname", this.nickname);
        subTag.putString("address", this.address);
        subTag.putLong("lastPlayed", this.lastPlayed.toEpochSecond(ZoneOffset.UTC));
        tag.putCompound(Integer.toString(index), subTag);
    }
}

