/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.command.commands;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Global;
import net.minecraft.core.net.command.Command;
import net.minecraft.core.net.command.CommandError;
import net.minecraft.core.net.command.CommandHandler;
import net.minecraft.core.net.command.CommandSender;
import net.minecraft.core.net.command.PlayerCommandSender;
import net.minecraft.core.net.command.ServerCommandHandler;
import net.minecraft.core.world.LevelListener;
import net.minecraft.core.world.World;
import net.minecraft.core.world.season.Season;
import net.minecraft.core.world.season.SeasonManager;
import net.minecraft.core.world.season.SeasonManagerCycle;
import net.minecraft.core.world.season.Seasons;

public class TimeCommand
extends Command {
    public static Map<String, Integer> dayTimeStrings = new HashMap<String, Integer>();
    public static Map<String, Season> seasonStrings;

    public TimeCommand() {
        super("time", new String[0]);
    }

    @Override
    public boolean execute(CommandHandler handler, CommandSender sender, String[] args) {
        String timeStr;
        if (args.length == 0) {
            return false;
        }
        World world = null;
        if (sender instanceof PlayerCommandSender) {
            world = sender.getPlayer().world;
        }
        if (handler instanceof ServerCommandHandler) {
            ServerCommandHandler server = (ServerCommandHandler)handler;
            if (args[0].equalsIgnoreCase("get") && args.length > 1) {
                world = server.minecraftServer.getWorldManager(Integer.parseInt(args[1]));
            }
            if ((args[0].equalsIgnoreCase("set") || args[0].equalsIgnoreCase("add")) && args.length > 2) {
                world = server.minecraftServer.getWorldManager(Integer.parseInt(args[2]));
            }
        }
        if (world == null) {
            throw new CommandError("Must be used by a player, or a dimension must be defined.");
        }
        if (args[0].equalsIgnoreCase("get")) {
            sender.sendMessage("The time in dimension " + world.dimension.id + " is " + world.getWorldTime());
            return true;
        }
        if (args[0].equalsIgnoreCase("set")) {
            timeStr = args[1];
            long time = TimeCommand.parseTime(timeStr, world);
            if (time < 0L) {
                time = 0L;
            }
            world.setWorldTime(time);
            handler.sendCommandFeedback(sender, "Set the time to " + time + " in dimension " + world.dimension.id);
            for (LevelListener listener : world.listeners) {
                listener.allChanged();
            }
            return true;
        }
        if (args[0].equalsIgnoreCase("add")) {
            timeStr = args[1];
            long time = Long.parseLong(timeStr);
            world.setWorldTime(world.getWorldTime() + time);
            handler.sendCommandFeedback(sender, "Set the time to " + time + " in dimension " + world.dimension.id);
            for (LevelListener listener : world.listeners) {
                listener.allChanged();
            }
            return true;
        }
        return false;
    }

    @Override
    public void sendCommandSyntax(CommandHandler handler, CommandSender sender) {
        sender.sendMessage("/time get [dimension]");
        sender.sendMessage("/time set <time> [dimension]");
        sender.sendMessage("/time add <time> [dimension]");
    }

    @Override
    public boolean opRequired(String[] args) {
        return true;
    }

    public static long parseTime(String timeString, World world) {
        Map.Entry<String, Integer> dayTimeEntry;
        int daylength = Global.DAY_LENGTH_TICKS;
        long time = world.getWorldTime() / (long)daylength * (long)daylength;
        if (TimeCommand.isNumber(timeString)) {
            return Long.parseLong(timeString);
        }
        if (timeString.startsWith("day") && TimeCommand.isNumber(timeString = timeString.substring(3))) {
            return Long.parseLong(timeString) * (long)Global.DAY_LENGTH_TICKS;
        }
        SeasonManager seasonManager = world.seasonManager;
        if (seasonManager instanceof SeasonManagerCycle) {
            SeasonManagerCycle cycleManager = (SeasonManagerCycle)seasonManager;
            Map.Entry<String, Season> seasonEntry = TimeCommand.getEntryStartsWithIgnoreCase(seasonStrings, timeString);
            if (seasonEntry != null) {
                timeString = timeString.substring(seasonEntry.getKey().length());
                int yearLength = 0;
                Integer seasonStart = null;
                List<Season> seasons = world.seasonManager.getSeasons();
                for (Season season : seasons) {
                    if (season == seasonEntry.getValue()) {
                        seasonStart = yearLength;
                    }
                    yearLength += cycleManager.getConfig().getSeasonLength(season) * Global.DAY_LENGTH_TICKS;
                }
                if (seasonStart == null) {
                    throw new CommandError("Invalid Season " + seasonEntry.getValue().getTranslatedName() + " for dimension " + world.dimension.getTranslatedName());
                }
                time = time / (long)yearLength * (long)yearLength;
                time += (long)seasonStart.intValue();
                if (TimeCommand.isNumber(timeString)) {
                    int seasonDays;
                    int i = Integer.parseInt(timeString);
                    if (i >= (seasonDays = cycleManager.getConfig().getSeasonLength(seasonEntry.getValue()))) {
                        throw new CommandError("Season " + seasonEntry.getValue().getTranslatedName() + " only has " + seasonDays + " days!");
                    }
                    time += (long)i * (long)daylength;
                }
            }
        }
        if ((dayTimeEntry = TimeCommand.getEntryStartsWithIgnoreCase(dayTimeStrings, timeString)) != null) {
            timeString = timeString.substring(dayTimeEntry.getKey().length());
            time += (long)dayTimeEntry.getValue().intValue();
        }
        return time;
    }

    public static boolean startsWithIgnoreCase(String a, String b) {
        if (a.length() < b.length()) {
            return false;
        }
        return a.substring(0, b.length()).equalsIgnoreCase(b);
    }

    public static boolean isNumber(String s) {
        if (s == null || s.length() < 1) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (TimeCommand.isNumber(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNumber(char c) {
        return c >= '0' && c <= '9';
    }

    public static <E> Map.Entry<String, E> getEntryStartsWithIgnoreCase(Map<String, E> map, String str) {
        for (Map.Entry<String, E> entry : map.entrySet()) {
            if (!TimeCommand.startsWithIgnoreCase(str, entry.getKey())) continue;
            return entry;
        }
        return null;
    }

    static {
        dayTimeStrings.put("sunrise", 0);
        dayTimeStrings.put("day", 1000);
        dayTimeStrings.put("noon", 6000);
        dayTimeStrings.put("evening", 12000);
        dayTimeStrings.put("dusk", 12000);
        dayTimeStrings.put("sunset", 12000);
        dayTimeStrings.put("night", 15000);
        dayTimeStrings.put("midnight", 18000);
        seasonStrings = new HashMap<String, Season>();
        seasonStrings.put("spring", Seasons.OVERWORLD_SPRING);
        seasonStrings.put("summer", Seasons.OVERWORLD_SUMMER);
        seasonStrings.put("autumn", Seasons.OVERWORLD_FALL);
        seasonStrings.put("fall", Seasons.OVERWORLD_FALL);
        seasonStrings.put("winter", Seasons.OVERWORLD_WINTER);
    }
}

