/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.packet;

import com.mojang.nbt.CompoundTag;
import com.mojang.nbt.NbtIo;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.net.handler.NetHandler;
import net.minecraft.core.net.packet.Packet0KeepAlive;
import net.minecraft.core.net.packet.Packet100OpenWindow;
import net.minecraft.core.net.packet.Packet101CloseWindow;
import net.minecraft.core.net.packet.Packet102WindowClick;
import net.minecraft.core.net.packet.Packet103SetSlot;
import net.minecraft.core.net.packet.Packet104WindowItems;
import net.minecraft.core.net.packet.Packet105UpdateProgressbar;
import net.minecraft.core.net.packet.Packet106Transaction;
import net.minecraft.core.net.packet.Packet107UpdateCreativeInventory;
import net.minecraft.core.net.packet.Packet108SetHotbarOffset;
import net.minecraft.core.net.packet.Packet10Flying;
import net.minecraft.core.net.packet.Packet11PlayerPosition;
import net.minecraft.core.net.packet.Packet12PlayerLook;
import net.minecraft.core.net.packet.Packet130UpdateSign;
import net.minecraft.core.net.packet.Packet131MapData;
import net.minecraft.core.net.packet.Packet132SetMobSpawner;
import net.minecraft.core.net.packet.Packet133OpenGuidebook;
import net.minecraft.core.net.packet.Packet134ItemData;
import net.minecraft.core.net.packet.Packet135PlacementMode;
import net.minecraft.core.net.packet.Packet136SendKey;
import net.minecraft.core.net.packet.Packet138PlayerList;
import net.minecraft.core.net.packet.Packet139SetPaintingMotive;
import net.minecraft.core.net.packet.Packet13PlayerLookMove;
import net.minecraft.core.net.packet.Packet140TileEntityData;
import net.minecraft.core.net.packet.Packet141UpdateFlag;
import net.minecraft.core.net.packet.Packet142OpenFlagWindow;
import net.minecraft.core.net.packet.Packet143PhotoMode;
import net.minecraft.core.net.packet.Packet14BlockDig;
import net.minecraft.core.net.packet.Packet15Place;
import net.minecraft.core.net.packet.Packet16BlockItemSwitch;
import net.minecraft.core.net.packet.Packet17Sleep;
import net.minecraft.core.net.packet.Packet18Animation;
import net.minecraft.core.net.packet.Packet19EntityAction;
import net.minecraft.core.net.packet.Packet1Login;
import net.minecraft.core.net.packet.Packet200Statistic;
import net.minecraft.core.net.packet.Packet20NamedEntitySpawn;
import net.minecraft.core.net.packet.Packet21PickupSpawn;
import net.minecraft.core.net.packet.Packet22Collect;
import net.minecraft.core.net.packet.Packet23VehicleSpawn;
import net.minecraft.core.net.packet.Packet24MobSpawn;
import net.minecraft.core.net.packet.Packet255KickDisconnect;
import net.minecraft.core.net.packet.Packet25EntityPainting;
import net.minecraft.core.net.packet.Packet27Position;
import net.minecraft.core.net.packet.Packet28EntityVelocity;
import net.minecraft.core.net.packet.Packet29DestroyEntity;
import net.minecraft.core.net.packet.Packet2Handshake;
import net.minecraft.core.net.packet.Packet30Entity;
import net.minecraft.core.net.packet.Packet31RelEntityMove;
import net.minecraft.core.net.packet.Packet32EntityLook;
import net.minecraft.core.net.packet.Packet33RelEntityMoveLook;
import net.minecraft.core.net.packet.Packet34EntityTeleport;
import net.minecraft.core.net.packet.Packet35EntityNickname;
import net.minecraft.core.net.packet.Packet38EntityStatus;
import net.minecraft.core.net.packet.Packet39AttachEntity;
import net.minecraft.core.net.packet.Packet3Chat;
import net.minecraft.core.net.packet.Packet40EntityMetadata;
import net.minecraft.core.net.packet.Packet41EntityPlayerGamemode;
import net.minecraft.core.net.packet.Packet4UpdateTime;
import net.minecraft.core.net.packet.Packet50PreChunk;
import net.minecraft.core.net.packet.Packet51MapChunk;
import net.minecraft.core.net.packet.Packet52MultiBlockChange;
import net.minecraft.core.net.packet.Packet53BlockChange;
import net.minecraft.core.net.packet.Packet54PlayNoteBlock;
import net.minecraft.core.net.packet.Packet56RequestChunk;
import net.minecraft.core.net.packet.Packet5PlayerInventory;
import net.minecraft.core.net.packet.Packet60Explosion;
import net.minecraft.core.net.packet.Packet61PlaySoundEffect;
import net.minecraft.core.net.packet.Packet6SpawnPosition;
import net.minecraft.core.net.packet.Packet70Bed;
import net.minecraft.core.net.packet.Packet71Weather;
import net.minecraft.core.net.packet.Packet72UpdatePlayerProfile;
import net.minecraft.core.net.packet.Packet73WeatherStatus;
import net.minecraft.core.net.packet.Packet7UseEntity;
import net.minecraft.core.net.packet.Packet8UpdateHealth;
import net.minecraft.core.net.packet.Packet9Respawn;

public abstract class Packet {
    private static final Map<Integer, Class<? extends Packet>> packetIdToClassMap = new HashMap<Integer, Class<? extends Packet>>();
    private static final Map<Class<? extends Packet>, Integer> packetClassToIdMap = new HashMap<Class<? extends Packet>, Integer>();
    private static final Set<Integer> clientPacketIdList = new HashSet<Integer>();
    private static final Set<Integer> serverPacketIdList = new HashSet<Integer>();
    public final long creationTimeMillis = System.currentTimeMillis();
    public boolean isChunkDataPacket = false;

    static void addIdClassMapping(int id, boolean clientPacket, boolean serverPacket, Class<? extends Packet> packetClass) {
        if (packetIdToClassMap.containsKey(id)) {
            throw new IllegalArgumentException("Duplicate packet id:" + id);
        }
        if (packetClassToIdMap.containsKey(packetClass)) {
            throw new IllegalArgumentException("Duplicate packet class:" + packetClass);
        }
        packetIdToClassMap.put(id, packetClass);
        packetClassToIdMap.put(packetClass, id);
        if (clientPacket) {
            clientPacketIdList.add(id);
        }
        if (serverPacket) {
            serverPacketIdList.add(id);
        }
    }

    public static Packet getNewPacket(int id) {
        try {
            Class<? extends Packet> packetClass = packetIdToClassMap.get(id);
            if (packetClass == null) {
                return null;
            }
            return packetClass.newInstance();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Skipping packet with id " + id);
            return null;
        }
    }

    public final int getPacketId() {
        return packetClassToIdMap.get(this.getClass());
    }

    public static Packet readPacket(DataInputStream dis, boolean flag) throws IOException {
        int id = 0;
        Packet packet = null;
        try {
            id = dis.read();
            if (id == -1) {
                return null;
            }
            if (flag && !serverPacketIdList.contains(id) || !flag && !clientPacketIdList.contains(id)) {
                throw new IOException("Bad packet id " + id);
            }
            packet = Packet.getNewPacket(id);
            if (packet == null) {
                throw new IOException("Bad packet id " + id);
            }
            packet.readPacketData(dis);
        }
        catch (EOFException eofexception) {
            System.out.println("Reached end of stream");
            return null;
        }
        return packet;
    }

    public static void writePacket(Packet packet, DataOutputStream dos) throws IOException {
        dos.write(packet.getPacketId());
        packet.writePacketData(dos);
    }

    public static void writeString(String string, DataOutputStream dos) throws IOException {
        if (string.length() > Short.MAX_VALUE) {
            throw new IOException("String too big");
        }
        byte[] buf = string.getBytes(StandardCharsets.UTF_8);
        dos.writeShort(buf.length);
        dos.write(buf);
    }

    public static String readString(DataInputStream dis, int maxLength) throws IOException {
        short length = dis.readShort();
        if (length < 0) {
            throw new IOException("Received string length is less than zero! Weird string!");
        }
        byte[] data = new byte[length];
        dis.readFully(data);
        String result = new String(data, StandardCharsets.UTF_8);
        if (result.length() > maxLength) {
            throw new IOException("Received string length longer than maximum allowed (" + length + " > " + maxLength + ")");
        }
        return result;
    }

    public static void writeCompressedCompoundTag(CompoundTag tag, DataOutputStream dos) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        NbtIo.writeCompressed(tag, baos);
        byte[] buffer = baos.toByteArray();
        dos.writeShort((short)buffer.length);
        dos.write(buffer);
    }

    public static CompoundTag readCompressedCompoundTag(DataInputStream dis) throws IOException {
        short length = dis.readShort();
        if (length < 0) {
            throw new IOException("Received tag length is less than zero! Weird tag!");
        }
        if (length == 0) {
            return null;
        }
        byte[] data = new byte[length];
        dis.readFully(data);
        return NbtIo.readCompressed(new ByteArrayInputStream(data));
    }

    public abstract void readPacketData(DataInputStream var1) throws IOException;

    public abstract void writePacketData(DataOutputStream var1) throws IOException;

    public abstract void processPacket(NetHandler var1);

    public abstract int getPacketSize();

    static {
        Packet.addIdClassMapping(0, true, true, Packet0KeepAlive.class);
        Packet.addIdClassMapping(1, true, true, Packet1Login.class);
        Packet.addIdClassMapping(2, true, true, Packet2Handshake.class);
        Packet.addIdClassMapping(3, true, true, Packet3Chat.class);
        Packet.addIdClassMapping(4, true, false, Packet4UpdateTime.class);
        Packet.addIdClassMapping(5, true, false, Packet5PlayerInventory.class);
        Packet.addIdClassMapping(6, true, false, Packet6SpawnPosition.class);
        Packet.addIdClassMapping(7, false, true, Packet7UseEntity.class);
        Packet.addIdClassMapping(8, true, false, Packet8UpdateHealth.class);
        Packet.addIdClassMapping(9, true, true, Packet9Respawn.class);
        Packet.addIdClassMapping(10, true, true, Packet10Flying.class);
        Packet.addIdClassMapping(11, true, true, Packet11PlayerPosition.class);
        Packet.addIdClassMapping(12, true, true, Packet12PlayerLook.class);
        Packet.addIdClassMapping(13, true, true, Packet13PlayerLookMove.class);
        Packet.addIdClassMapping(14, false, true, Packet14BlockDig.class);
        Packet.addIdClassMapping(15, false, true, Packet15Place.class);
        Packet.addIdClassMapping(16, true, true, Packet16BlockItemSwitch.class);
        Packet.addIdClassMapping(17, true, false, Packet17Sleep.class);
        Packet.addIdClassMapping(18, true, true, Packet18Animation.class);
        Packet.addIdClassMapping(19, false, true, Packet19EntityAction.class);
        Packet.addIdClassMapping(20, true, false, Packet20NamedEntitySpawn.class);
        Packet.addIdClassMapping(21, true, false, Packet21PickupSpawn.class);
        Packet.addIdClassMapping(22, true, false, Packet22Collect.class);
        Packet.addIdClassMapping(23, true, false, Packet23VehicleSpawn.class);
        Packet.addIdClassMapping(24, true, false, Packet24MobSpawn.class);
        Packet.addIdClassMapping(25, true, false, Packet25EntityPainting.class);
        Packet.addIdClassMapping(27, false, true, Packet27Position.class);
        Packet.addIdClassMapping(28, true, false, Packet28EntityVelocity.class);
        Packet.addIdClassMapping(29, true, false, Packet29DestroyEntity.class);
        Packet.addIdClassMapping(30, true, false, Packet30Entity.class);
        Packet.addIdClassMapping(31, true, false, Packet31RelEntityMove.class);
        Packet.addIdClassMapping(32, true, false, Packet32EntityLook.class);
        Packet.addIdClassMapping(33, true, false, Packet33RelEntityMoveLook.class);
        Packet.addIdClassMapping(34, true, false, Packet34EntityTeleport.class);
        Packet.addIdClassMapping(35, true, true, Packet35EntityNickname.class);
        Packet.addIdClassMapping(38, true, false, Packet38EntityStatus.class);
        Packet.addIdClassMapping(39, true, false, Packet39AttachEntity.class);
        Packet.addIdClassMapping(40, true, false, Packet40EntityMetadata.class);
        Packet.addIdClassMapping(41, true, false, Packet41EntityPlayerGamemode.class);
        Packet.addIdClassMapping(50, true, false, Packet50PreChunk.class);
        Packet.addIdClassMapping(51, true, false, Packet51MapChunk.class);
        Packet.addIdClassMapping(52, true, false, Packet52MultiBlockChange.class);
        Packet.addIdClassMapping(53, true, false, Packet53BlockChange.class);
        Packet.addIdClassMapping(54, true, false, Packet54PlayNoteBlock.class);
        Packet.addIdClassMapping(56, false, true, Packet56RequestChunk.class);
        Packet.addIdClassMapping(60, true, false, Packet60Explosion.class);
        Packet.addIdClassMapping(61, true, false, Packet61PlaySoundEffect.class);
        Packet.addIdClassMapping(70, true, false, Packet70Bed.class);
        Packet.addIdClassMapping(71, true, false, Packet71Weather.class);
        Packet.addIdClassMapping(72, true, false, Packet72UpdatePlayerProfile.class);
        Packet.addIdClassMapping(73, true, false, Packet73WeatherStatus.class);
        Packet.addIdClassMapping(100, true, false, Packet100OpenWindow.class);
        Packet.addIdClassMapping(101, true, true, Packet101CloseWindow.class);
        Packet.addIdClassMapping(102, false, true, Packet102WindowClick.class);
        Packet.addIdClassMapping(103, true, false, Packet103SetSlot.class);
        Packet.addIdClassMapping(104, true, false, Packet104WindowItems.class);
        Packet.addIdClassMapping(105, true, false, Packet105UpdateProgressbar.class);
        Packet.addIdClassMapping(106, true, true, Packet106Transaction.class);
        Packet.addIdClassMapping(107, false, true, Packet107UpdateCreativeInventory.class);
        Packet.addIdClassMapping(108, false, true, Packet108SetHotbarOffset.class);
        Packet.addIdClassMapping(130, false, true, Packet130UpdateSign.class);
        Packet.addIdClassMapping(131, true, false, Packet131MapData.class);
        Packet.addIdClassMapping(132, true, false, Packet132SetMobSpawner.class);
        Packet.addIdClassMapping(133, false, true, Packet133OpenGuidebook.class);
        Packet.addIdClassMapping(134, false, true, Packet134ItemData.class);
        Packet.addIdClassMapping(135, false, true, Packet135PlacementMode.class);
        Packet.addIdClassMapping(136, true, false, Packet136SendKey.class);
        Packet.addIdClassMapping(138, true, false, Packet138PlayerList.class);
        Packet.addIdClassMapping(139, false, true, Packet139SetPaintingMotive.class);
        Packet.addIdClassMapping(140, true, false, Packet140TileEntityData.class);
        Packet.addIdClassMapping(141, false, true, Packet141UpdateFlag.class);
        Packet.addIdClassMapping(142, true, false, Packet142OpenFlagWindow.class);
        Packet.addIdClassMapping(143, true, false, Packet143PhotoMode.class);
        Packet.addIdClassMapping(200, true, false, Packet200Statistic.class);
        Packet.addIdClassMapping(255, true, true, Packet255KickDisconnect.class);
    }
}

