/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.packet;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.core.net.handler.NetHandler;
import net.minecraft.core.net.packet.Packet;

public class Packet138PlayerList
extends Packet {
    public String[] players;
    public int[] scores;
    public int count;

    public Packet138PlayerList() {
    }

    public Packet138PlayerList(int playerCount, String[] players, int[] scores) {
        this.count = playerCount;
        this.players = players;
        this.scores = scores;
    }

    @Override
    public void readPacketData(DataInputStream in) throws IOException {
        this.count = in.readInt();
        this.players = new String[this.count];
        this.scores = new int[this.count];
        for (int i = 0; i < this.count; ++i) {
            this.players[i] = Packet138PlayerList.readString(in, 32);
            this.scores[i] = in.readInt();
        }
    }

    @Override
    public void writePacketData(DataOutputStream out) throws IOException {
        out.writeInt(this.count);
        for (int i = 0; i < this.count; ++i) {
            Packet138PlayerList.writeString(this.players[i], out);
            out.writeInt(this.scores[i]);
        }
    }

    @Override
    public void processPacket(NetHandler netHandler) {
        netHandler.handlePlayerList(this);
    }

    @Override
    public int getPacketSize() {
        int size = 4;
        size += this.scores.length * 4;
        for (int i = 0; i < this.players.length; ++i) {
            size += this.players[i].length();
        }
        return size;
    }
}

