/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.player.inventory;

import java.util.List;
import net.minecraft.core.InventoryAction;
import net.minecraft.core.crafting.CraftingManager;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.player.inventory.Container;
import net.minecraft.core.player.inventory.IInventory;
import net.minecraft.core.player.inventory.InventoryCraftResult;
import net.minecraft.core.player.inventory.InventoryCrafting;
import net.minecraft.core.player.inventory.InventoryPlayer;
import net.minecraft.core.player.inventory.slot.Slot;
import net.minecraft.core.player.inventory.slot.SlotArmor;
import net.minecraft.core.player.inventory.slot.SlotCrafting;

public class ContainerPlayer
extends Container {
    public InventoryCrafting craftMatrix = new InventoryCrafting(this, 2, 2);
    public IInventory craftResult = new InventoryCraftResult();
    public boolean isSinglePlayer;
    public InventoryPlayer playerInv;

    public ContainerPlayer(InventoryPlayer inventory) {
        this(inventory, true);
    }

    public ContainerPlayer(InventoryPlayer inventory, boolean isSinglePlayer) {
        int i;
        this.isSinglePlayer = isSinglePlayer;
        this.playerInv = inventory;
        this.addSlot(new SlotCrafting(inventory.player, this.craftMatrix, this.craftResult, 0, 144, 36));
        for (i = 0; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                this.addSlot(new Slot(this.craftMatrix, j + i * 2, 88 + j * 18, 26 + i * 18));
            }
        }
        for (i = 0; i < 4; ++i) {
            int j1 = i;
            this.addSlot(new SlotArmor(this, inventory, inventory.getSizeInventory() - 1 - i, 8, 8 + i * 18, j1));
        }
        for (i = 0; i < 3; ++i) {
            for (int k1 = 0; k1 < 9; ++k1) {
                this.addSlot(new Slot(inventory, k1 + (i + 1) * 9, 8 + k1 * 18, 84 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot(inventory, i, 8 + i * 18, 142));
        }
        this.onCraftMatrixChanged(this.craftMatrix);
    }

    @Override
    public void onCraftMatrixChanged(IInventory iinventory) {
        this.craftResult.setInventorySlotContents(0, CraftingManager.getInstance().findMatchingRecipe(this.craftMatrix));
    }

    @Override
    public void onCraftGuiClosed(EntityPlayer player) {
        super.onCraftGuiClosed(player);
        boolean insert = false;
        for (int i = 0; i < 4; ++i) {
            ItemStack itemstack = this.craftMatrix.getStackInSlot(i);
            if (itemstack == null) continue;
            this.craftMatrix.setInventorySlotContents(i, null);
            this.storeOrDropItem(player, itemstack);
            insert = true;
        }
        if (insert) {
            player.world.playSoundAtEntity(player, "random.insert", 0.1f, 1.0f);
        }
    }

    @Override
    public boolean isUsableByPlayer(EntityPlayer entityplayer) {
        return true;
    }

    @Override
    public List<Integer> getMoveSlots(InventoryAction action, Slot slot, int target, EntityPlayer player) {
        if (slot.id == 0) {
            return this.getSlots(0, 1, false);
        }
        if (slot.id >= 1 && slot.id <= 4) {
            return this.getSlots(1, 4, false);
        }
        if (slot.id >= 5 && slot.id <= 8) {
            return this.getSlots(5, 4, false);
        }
        if (action == InventoryAction.MOVE_SIMILAR) {
            if (slot.id >= 9 && slot.id <= 44) {
                return this.getSlots(9, 36, false);
            }
        } else {
            if (slot.id >= 9 && slot.id <= 35) {
                return this.getSlots(9, 27, false);
            }
            if (slot.id >= 36 && slot.id <= 44) {
                return this.getSlots(36, 9, false);
            }
        }
        return null;
    }

    @Override
    public List<Integer> getTargetSlots(InventoryAction action, Slot slot, int target, EntityPlayer player) {
        if (slot.id >= 9 && slot.id <= 44) {
            if (target == 1) {
                return this.getSlots(1, 4, false);
            }
            if (target == 2) {
                return this.getSlots(5, 4, false);
            }
            if (slot.id < 36) {
                return this.getSlots(36, 9, false);
            }
            return this.getSlots(9, 27, false);
        }
        if (slot.id == 0) {
            return this.getSlots(9, 36, true);
        }
        return this.getSlots(9, 36, false);
    }
}

