/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.player.inventory;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.player.inventory.ContainerPlayer;
import net.minecraft.core.player.inventory.InventoryPlayer;
import net.minecraft.core.player.inventory.slot.SlotCreative;

public class ContainerPlayerCreative
extends ContainerPlayer {
    public int page = 0;
    public int maxPage;
    protected int creativeSlotsStart;
    protected List<ItemStack> searchedItems = new ArrayList<ItemStack>();
    public String searchText = "";
    public static List<ItemStack> creativeItems = new ArrayList<ItemStack>();
    public static int creativeItemsCount;

    public ContainerPlayerCreative(InventoryPlayer inventoryplayer) {
        this(inventoryplayer, true);
    }

    public ContainerPlayerCreative(InventoryPlayer inventoryplayer, boolean isSinglePlayer) {
        super(inventoryplayer, isSinglePlayer);
        this.creativeSlotsStart = this.inventorySlots.size();
        for (int i = 0; i < 36; ++i) {
            int x = i % 6;
            int y = i / 6;
            this.addSlot(new SlotCreative(this.creativeSlotsStart + i, 174 + x * 18, 30 + y * 18, creativeItems.get(i)));
        }
        this.searchPage("");
    }

    public void setInventoryStatus(int page, String searchText) {
        if (this.page != page) {
            this.page = page;
            this.updatePage();
        }
        if (!this.searchText.equals(searchText)) {
            this.searchText = searchText;
            this.searchPage(searchText);
        }
    }

    public void lastPage() {
        if (this.page == 0) {
            return;
        }
        --this.page;
        this.updatePage();
    }

    public void nextPage() {
        if (this.page == this.maxPage) {
            return;
        }
        ++this.page;
        this.updatePage();
    }

    public void searchPage(String search) {
        this.searchText = search;
        this.searchedItems.clear();
        this.page = 0;
        I18n t = I18n.getInstance();
        for (int i = 0; i < creativeItemsCount; ++i) {
            if (!t.translateNameKey(creativeItems.get(i).getItemName()).toLowerCase().contains(search.toLowerCase())) continue;
            this.searchedItems.add(creativeItems.get(i));
        }
        this.updatePage();
    }

    protected void updatePage() {
        this.maxPage = this.searchedItems.size() / 36;
        if (this.searchedItems.size() % 36 == 0) {
            --this.maxPage;
        }
        if (this.maxPage == -1) {
            this.maxPage = 0;
        }
        for (int i = 0; i < 36; ++i) {
            ((SlotCreative)this.inventorySlots.get((int)(this.creativeSlotsStart + i))).item = i + this.page * 36 >= this.searchedItems.size() ? null : this.searchedItems.get(i + this.page * 36);
        }
        this.playerInv.player.updateCreativeInventory(this.page, this.searchText);
    }

    public String getSearchText() {
        return this.searchText;
    }

    @Override
    public int getHotbarSlotId(int number) {
        return number + 8 + 27;
    }

    static {
        int count = 0;
        for (int id = 0; id < Block.blocksList.length; ++id) {
            int i;
            if (Block.blocksList[id] == null || Block.blocksList[id].hasTag(BlockTags.NOT_IN_CREATIVE_MENU)) continue;
            creativeItems.add(new ItemStack(Block.blocksList[id]));
            ++count;
            if (id == Block.wool.id || id == Block.planksOakPainted.id || id == Block.lampIdle.id || id == Block.fencePlanksOakPainted.id) {
                for (i = 1; i < 16; ++i) {
                    creativeItems.add(new ItemStack(Block.blocksList[id], 1, i));
                    ++count;
                }
                continue;
            }
            if (id != Block.chestPlanksOakPainted.id && id != Block.slabPlanksOakPainted.id && id != Block.fencegatePlanksOakPainted.id && id != Block.stairsPlanksOakPainted.id) continue;
            for (i = 16; i < 256; i += 16) {
                creativeItems.add(new ItemStack(Block.blocksList[id], 1, i));
                ++count;
            }
        }
        for (int i = Block.blocksList.length; i < Item.itemsList.length; ++i) {
            int j;
            if (Item.itemsList[i] == null || Item.itemsList[i].notInCreativeMenu) continue;
            creativeItems.add(new ItemStack(Item.itemsList[i]));
            ++count;
            if (i == Item.coal.id) {
                for (j = 1; j < 2; ++j) {
                    creativeItems.add(new ItemStack(Item.itemsList[i], 1, j));
                    ++count;
                }
            }
            if (i != Item.dye.id) continue;
            for (j = 1; j < 16; ++j) {
                creativeItems.add(new ItemStack(Item.itemsList[i], 1, j));
                ++count;
            }
        }
        creativeItemsCount = count;
    }
}

