/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.chunk;

import java.nio.ByteBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockTileEntity;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.data.registry.Registries;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.enums.LightLayer;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;
import net.minecraft.core.world.biome.Biome;
import net.minecraft.core.world.chunk.ChunkPosition;
import net.minecraft.core.world.chunk.MissingBlockFixer;
import net.minecraft.core.world.data.ChunkNibbleArray;
import net.minecraft.core.world.data.ChunkUnsignedByteArray;

public class Chunk {
    private final int heightBlocks;
    private final int heightBits;
    public static boolean isLit;
    public short[] blocks;
    public boolean isChunkLoaded;
    public World worldObj;
    public ChunkUnsignedByteArray data;
    public ChunkNibbleArray skylightMap;
    public ChunkNibbleArray blocklightMap;
    public short[] heightMap;
    public int lowestBlockHeight;
    public final int xPosition;
    public final int zPosition;
    public Map<ChunkPosition, TileEntity> tileEntityMap = new HashMap<ChunkPosition, TileEntity>();
    public List<Entity>[] entities;
    public double[] temperature;
    public double[] humidity;
    public double[] variety;
    public byte[] biome;
    public int averageBlockHeight;
    public boolean isTerrainPopulated;
    public boolean isModified;
    public boolean neverSave;
    public boolean hasEntities;
    public long lastSaveTime;
    public boolean receivedFromServer = false;
    public long ticksUnreceived = 0L;

    public Chunk(World world, int x, int z) {
        this.heightBlocks = world.getHeightBlocks();
        this.heightBits = world.getHeightBits();
        this.entities = new ArrayList[this.heightBlocks / 16];
        this.isTerrainPopulated = false;
        this.isModified = false;
        this.hasEntities = false;
        this.lastSaveTime = 0L;
        this.worldObj = world;
        this.xPosition = x;
        this.zPosition = z;
        this.heightMap = new short[256];
        this.biome = new byte[256 * (this.heightBlocks >> 3)];
        this.temperature = new double[256];
        this.humidity = new double[256];
        this.variety = new double[256];
        for (int i = 0; i < this.entities.length; ++i) {
            this.entities[i] = new ArrayList<Entity>();
        }
    }

    public Chunk(World world, short[] blocks, int x, int z) {
        this(world, x, z);
        if (blocks.length < 256 * this.heightBlocks) {
            this.blocks = new short[256 * this.heightBlocks];
            System.arraycopy(blocks, 0, this.blocks, 0, blocks.length);
        } else {
            this.blocks = blocks;
        }
        this.data = new ChunkUnsignedByteArray(16, this.heightBlocks, 16);
        this.skylightMap = new ChunkNibbleArray(16, this.heightBlocks, 16);
        this.blocklightMap = new ChunkNibbleArray(16, this.heightBlocks, 16);
        Arrays.fill(this.temperature, Double.NEGATIVE_INFINITY);
        Arrays.fill(this.humidity, Double.NEGATIVE_INFINITY);
        Arrays.fill(this.variety, Double.NEGATIVE_INFINITY);
        Arrays.fill(this.biome, (byte)-1);
    }

    public boolean isAtLocation(int x, int z) {
        return x == this.xPosition && z == this.zPosition;
    }

    public int getHeightValue(int x, int z) {
        return this.heightMap[z << 4 | x];
    }

    public void generateHeightMap() {
        int acc = 0;
        int lowestBlock = this.heightBlocks - 1;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int y;
                int i = x << this.heightBits + 4 | z << this.heightBits;
                for (y = this.heightBlocks - 1; y > 0 && Block.lightOpacity[this.blocks[i + y - 1] & 0x3FFF] == 0; --y) {
                }
                this.heightMap[z << 4 | x] = (short)y;
                acc += y;
                if (y >= lowestBlock) continue;
                lowestBlock = y;
            }
        }
        this.lowestBlockHeight = lowestBlock;
        this.isModified = true;
        this.averageBlockHeight = acc / 256;
    }

    public void generateMaps() {
        int i = this.heightBlocks - 1;
        for (int j = 0; j < 16; ++j) {
            for (int l = 0; l < 16; ++l) {
                int j1;
                int k1 = j << this.heightBits + 4 | l << this.heightBits;
                for (j1 = this.heightBlocks - 1; j1 > 0 && Block.lightOpacity[this.blocks[k1 + j1 - 1] & 0x3FFF] == 0; --j1) {
                }
                this.heightMap[l << 4 | j] = (short)j1;
                if (j1 < i) {
                    i = j1;
                }
                if (this.worldObj.worldType.hasCeiling()) continue;
                int l1 = 15;
                int i2 = this.heightBlocks - 1;
                do {
                    if ((l1 -= Block.lightOpacity[this.blocks[k1 + i2] & 0x3FFF]) <= 0) continue;
                    this.skylightMap.set(j, i2, l, l1);
                } while (--i2 > 0 && l1 > 0);
            }
        }
        this.lowestBlockHeight = i;
        for (int k = 0; k < 16; ++k) {
            for (int i1 = 0; i1 < 16; ++i1) {
                this.updateAdjacentLightColumns(k, i1);
            }
        }
        this.isModified = true;
    }

    private void updateAdjacentLightColumns(int x, int z) {
        int y = this.getHeightValue(x, z);
        int worldX = this.xPosition * 16 + x;
        int worldZ = this.zPosition * 16 + z;
        this.updateAdjacentLightColumn(worldX - 1, worldZ, y);
        this.updateAdjacentLightColumn(worldX + 1, worldZ, y);
        this.updateAdjacentLightColumn(worldX, worldZ - 1, y);
        this.updateAdjacentLightColumn(worldX, worldZ + 1, y);
    }

    private void updateAdjacentLightColumn(int x, int z, int localY) {
        int blockHeight = this.worldObj.getHeightValue(x, z);
        if (blockHeight > localY) {
            this.worldObj.scheduleLightingUpdate(LightLayer.Sky, x, localY, z, x, blockHeight, z);
            this.isModified = true;
        } else if (blockHeight < localY) {
            this.worldObj.scheduleLightingUpdate(LightLayer.Sky, x, blockHeight, z, x, localY, z);
            this.isModified = true;
        }
    }

    private void func_1003_g(int x, int y, int z) {
        int l;
        int i1 = l = this.heightMap[z << 4 | x];
        if (y > l) {
            i1 = y;
        }
        int j1 = x << this.heightBits + 4 | z << this.heightBits;
        while (i1 > 0 && Block.lightOpacity[this.blocks[j1 + i1 - 1] & 0x3FFF] == 0) {
            --i1;
        }
        if (i1 == l) {
            return;
        }
        this.worldObj.markBlocksDirtyVertical(x, z, i1, l);
        this.heightMap[z << 4 | x] = (short)i1;
        if (i1 < this.lowestBlockHeight) {
            this.lowestBlockHeight = i1;
        } else {
            int k1 = this.heightBlocks - 1;
            for (int i2 = 0; i2 < 16; ++i2) {
                for (int k2 = 0; k2 < 16; ++k2) {
                    if (this.heightMap[k2 << 4 | i2] >= k1) continue;
                    k1 = this.heightMap[k2 << 4 | i2];
                }
            }
            this.lowestBlockHeight = k1;
        }
        int l1 = this.xPosition * 16 + x;
        int j2 = this.zPosition * 16 + z;
        if (i1 < l) {
            for (int l2 = i1; l2 < l; ++l2) {
                this.skylightMap.set(x, l2, z, 15);
            }
        } else {
            this.worldObj.scheduleLightingUpdate(LightLayer.Sky, l1, l, j2, l1, i1, j2);
            for (int i3 = l; i3 < i1; ++i3) {
                this.skylightMap.set(x, i3, z, 0);
            }
        }
        int j3 = 15;
        int k3 = i1;
        while (i1 > 0 && j3 > 0) {
            int l3;
            if ((l3 = Block.lightOpacity[this.getBlockID(x, --i1, z)]) == 0) {
                l3 = 1;
            }
            if ((j3 -= l3) < 0) {
                j3 = 0;
            }
            this.skylightMap.set(x, i1, z, j3);
        }
        while (i1 > 0 && Block.lightOpacity[this.getBlockID(x, i1 - 1, z)] == 0) {
            --i1;
        }
        if (i1 != k3) {
            this.worldObj.scheduleLightingUpdate(LightLayer.Sky, l1 - 1, i1, j2 - 1, l1 + 1, k3, j2 + 1);
        }
        this.isModified = true;
    }

    public int getBlockID(int i, int j, int k) {
        if (i < 0 || i >= 16 || j < 0 || j >= this.heightBlocks || k < 0 || k >= 16) {
            return 0;
        }
        return this.blocks[i << this.heightBits + 4 | k << this.heightBits | j] & 0x3FFF;
    }

    public boolean setBlockIDWithMetadata(int x, int y, int z, int id, int meta) {
        short short0 = (short)id;
        short j1 = this.heightMap[z << 4 | x];
        int k1 = this.blocks[x << this.heightBits + 4 | z << this.heightBits | y] & 0x3FFF;
        if (k1 == id && this.data.get(x, y, z) == meta) {
            return false;
        }
        int l1 = this.xPosition * 16 + x;
        int i2 = this.zPosition * 16 + z;
        this.blocks[x << this.heightBits + 4 | z << this.heightBits | y] = (short)(short0 & 0x3FFF);
        if (k1 != 0 && !this.worldObj.isClientSide) {
            Block.blocksList[k1].onBlockRemoval(this.worldObj, l1, y, i2);
        }
        this.data.set(x, y, z, meta);
        if (!this.worldObj.worldType.hasCeiling()) {
            if (Block.lightOpacity[short0 & 0x3FFF] != 0) {
                if (y >= j1) {
                    this.func_1003_g(x, y + 1, z);
                }
            } else if (y == j1 - 1) {
                this.func_1003_g(x, y, z);
            }
            this.worldObj.scheduleLightingUpdate(LightLayer.Sky, l1, y, i2, l1, y, i2);
        }
        this.worldObj.scheduleLightingUpdate(LightLayer.Block, l1, y, i2, l1, y, i2);
        this.updateAdjacentLightColumns(x, z);
        this.data.set(x, y, z, meta);
        if (id != 0) {
            Block.blocksList[id].onBlockAdded(this.worldObj, l1, y, i2);
        }
        this.isModified = true;
        return true;
    }

    public boolean setBlockID(int x, int y, int z, int id) {
        short short0 = (short)id;
        short i1 = this.heightMap[z << 4 | x];
        int j1 = this.blocks[x << this.heightBits + 4 | z << this.heightBits | y] & 0x3FFF;
        if (j1 == id) {
            return false;
        }
        int k1 = this.xPosition * 16 + x;
        int l1 = this.zPosition * 16 + z;
        this.blocks[x << this.heightBits + 4 | z << this.heightBits | y] = (short)(short0 & 0x3FFF);
        if (j1 != 0) {
            Block.blocksList[j1].onBlockRemoval(this.worldObj, k1, y, l1);
        }
        this.data.set(x, y, z, 0);
        if (Block.lightOpacity[short0 & 0x3FFF] != 0) {
            if (y >= i1) {
                this.func_1003_g(x, y + 1, z);
            }
        } else if (y == i1 - 1) {
            this.func_1003_g(x, y, z);
        }
        this.worldObj.scheduleLightingUpdate(LightLayer.Sky, k1, y, l1, k1, y, l1);
        this.worldObj.scheduleLightingUpdate(LightLayer.Block, k1, y, l1, k1, y, l1);
        this.updateAdjacentLightColumns(x, z);
        if (id != 0 && !this.worldObj.isClientSide) {
            Block.blocksList[id].onBlockAdded(this.worldObj, k1, y, l1);
        }
        this.isModified = true;
        return true;
    }

    public boolean setBlockIDRaw(int x, int y, int z, int id) {
        short short0 = (short)id;
        int j1 = this.blocks[x << this.heightBits + 4 | z << this.heightBits | y] & 0x3FFF;
        if (j1 == id) {
            return false;
        }
        int worldX = this.xPosition * 16 + x;
        int worldZ = this.zPosition * 16 + z;
        this.blocks[x << this.heightBits + 4 | z << this.heightBits | y] = (short)(short0 & 0x3FFF);
        this.data.set(x, y, z, 0);
        this.worldObj.scheduleLightingUpdate(LightLayer.Block, worldX, y, worldZ, worldX, y, worldZ);
        this.updateAdjacentLightColumns(x, z);
        this.isModified = true;
        return true;
    }

    public int getBlockMetadata(int i, int j, int k) {
        return this.data.get(i, j, k);
    }

    public void setBlockMetadata(int i, int j, int k, int l) {
        this.isModified = true;
        this.data.set(i, j, k, l);
    }

    public Biome getBlockBiome(int x, int y, int z) {
        if (y < 0 || y >= this.heightBlocks) {
            return null;
        }
        byte b = this.biome[(y >>= 3) * 16 * 16 + x * 16 + z];
        if (b == -1) {
            return null;
        }
        return Registries.BIOMES.getItemByNumericId(b);
    }

    public boolean setBlockBiome(int x, int y, int z, Biome biome) {
        if (y < 0 || y >= this.heightBlocks) {
            return false;
        }
        byte presentBiome = this.biome[(y >>= 3) * 16 * 16 + x * 16 + z];
        if (presentBiome == Registries.BIOMES.getNumericIdOfItem(biome)) {
            return false;
        }
        this.biome[y * 16 * 16 + x * 16 + z] = (byte)Registries.BIOMES.getNumericIdOfItem(biome);
        return true;
    }

    public double getBlockTemperature(int x, int z) {
        return this.temperature[x * 16 + z];
    }

    public boolean setBlockTemperature(int x, int z, double temperature) {
        double presentTemperature = this.temperature[x * 16 + z];
        if (presentTemperature == temperature) {
            return false;
        }
        this.temperature[x * 16 + z] = temperature;
        return true;
    }

    public double getBlockHumidity(int x, int z) {
        return this.humidity[x * 16 + z];
    }

    public boolean setBlockHumidity(int x, int z, double humidity) {
        double presentHumidity = this.humidity[x * 16 + z];
        if (presentHumidity == humidity) {
            return false;
        }
        this.humidity[x * 16 + z] = humidity;
        return true;
    }

    public double getBlockVariety(int x, int z) {
        return this.variety[x * 16 + z];
    }

    public boolean setBlockVariety(int x, int z, double variety) {
        double presentVariety = this.variety[x * 16 + z];
        if (presentVariety == variety) {
            return false;
        }
        this.variety[x * 16 + z] = variety;
        return true;
    }

    public int getSavedLightValue(LightLayer lightType, int i, int j, int k) {
        if (lightType == LightLayer.Sky) {
            return this.skylightMap.get(i, j, k);
        }
        if (lightType == LightLayer.Block) {
            return this.blocklightMap.get(i, j, k);
        }
        return 0;
    }

    public void setLightValue(LightLayer layer, int x, int y, int z, int value) {
        this.isModified = true;
        if (layer == LightLayer.Sky) {
            this.skylightMap.set(x, y, z, value);
        } else if (layer == LightLayer.Block) {
            this.blocklightMap.set(x, y, z, value);
        }
    }

    public int getBlockLightValue(int i, int j, int k, int l) {
        int j1;
        int i1 = this.skylightMap.get(i, j, k);
        if (i1 > 0) {
            isLit = true;
        }
        if ((j1 = this.blocklightMap.get(i, j, k).intValue()) > (i1 -= l)) {
            i1 = j1;
        }
        return i1;
    }

    public void addEntity(Entity entity) {
        int k;
        this.hasEntities = true;
        int i = MathHelper.floor_double(entity.x / 16.0);
        int j = MathHelper.floor_double(entity.z / 16.0);
        if (i != this.xPosition || j != this.zPosition) {
            System.out.println("Wrong location! " + entity);
            Thread.dumpStack();
        }
        if ((k = MathHelper.floor_double(entity.y / 16.0)) < 0) {
            k = 0;
        }
        if (k >= this.entities.length) {
            k = this.entities.length - 1;
        }
        entity.addedToChunk = true;
        entity.chunkCoordX = this.xPosition;
        entity.chunkCoordY = k;
        entity.chunkCoordZ = this.zPosition;
        this.entities[k].add(entity);
    }

    public void removeEntity(Entity entity) {
        this.removeEntityAtIndex(entity, entity.chunkCoordY);
    }

    public void removeEntityAtIndex(Entity entity, int i) {
        if (i < 0) {
            i = 0;
        }
        if (i >= this.entities.length) {
            i = this.entities.length - 1;
        }
        this.entities[i].remove(entity);
    }

    public boolean canBlockSeeTheSky(int i, int j, int k) {
        return j >= this.heightMap[k << 4 | i];
    }

    public TileEntity getChunkBlockTileEntity(int x, int y, int z) {
        ChunkPosition chunkposition = new ChunkPosition(x, y, z);
        TileEntity tileentity = this.tileEntityMap.get(chunkposition);
        if (tileentity == null) {
            int id = this.getBlockID(x, y, z);
            if (!Block.isBlockContainer[id]) {
                return null;
            }
            BlockTileEntity blockcontainer = (BlockTileEntity)Block.blocksList[id];
            blockcontainer.onBlockAdded(this.worldObj, this.xPosition * 16 + x, y, this.zPosition * 16 + z);
            tileentity = this.tileEntityMap.get(chunkposition);
        }
        if (tileentity != null && tileentity.isInvalid()) {
            this.tileEntityMap.remove(chunkposition);
            return null;
        }
        return tileentity;
    }

    public void addTileEntity(TileEntity tileentity) {
        int i = tileentity.xCoord - this.xPosition * 16;
        int j = tileentity.yCoord;
        int k = tileentity.zCoord - this.zPosition * 16;
        this.setChunkBlockTileEntity(i, j, k, tileentity);
        if (this.isChunkLoaded) {
            this.worldObj.loadedTileEntityList.add(tileentity);
        }
    }

    public void setChunkBlockTileEntity(int i, int j, int k, TileEntity tileentity) {
        ChunkPosition chunkposition = new ChunkPosition(i, j, k);
        tileentity.worldObj = this.worldObj;
        tileentity.xCoord = this.xPosition * 16 + i;
        tileentity.yCoord = j;
        tileentity.zCoord = this.zPosition * 16 + k;
        if (this.getBlockID(i, j, k) == 0 || !(Block.blocksList[this.getBlockID(i, j, k)] instanceof BlockTileEntity)) {
            System.out.println("Attempted to place a tile entity where there was no entity tile!");
            return;
        }
        tileentity.validate();
        this.tileEntityMap.put(chunkposition, tileentity);
    }

    public void removeChunkBlockTileEntity(int i, int j, int k) {
        TileEntity tileentity;
        ChunkPosition chunkposition = new ChunkPosition(i, j, k);
        if (this.isChunkLoaded && (tileentity = this.tileEntityMap.remove(chunkposition)) != null) {
            tileentity.invalidate();
        }
    }

    public void onChunkLoad() {
        this.isChunkLoaded = true;
        this.worldObj.func_31054_a(this.tileEntityMap.values());
        for (int i = 0; i < this.entities.length; ++i) {
            this.worldObj.addLoadedEntities(this.entities[i]);
        }
    }

    public void onChunkUnload() {
        this.isChunkLoaded = false;
        for (TileEntity tileentity : this.tileEntityMap.values()) {
            tileentity.invalidate();
        }
        for (int i = 0; i < this.entities.length; ++i) {
            this.worldObj.unloadEntities(this.entities[i]);
        }
    }

    public void setChunkModified() {
        this.isModified = true;
    }

    public void getEntitiesWithinAABBForEntity(Entity entity, AABB axisalignedbb, List list) {
        int i = MathHelper.floor_double((axisalignedbb.minY - 2.0) / 16.0);
        int j = MathHelper.floor_double((axisalignedbb.maxY + 2.0) / 16.0);
        if (i < 0) {
            i = 0;
        }
        if (j >= this.entities.length) {
            j = this.entities.length - 1;
        }
        for (int k = i; k <= j; ++k) {
            List<Entity> list1 = this.entities[k];
            for (int l = 0; l < list1.size(); ++l) {
                Entity entity1 = list1.get(l);
                if (entity1 == entity || !entity1.bb.intersectsWith(axisalignedbb)) continue;
                list.add(entity1);
            }
        }
    }

    public void getEntitiesOfTypeWithinAAAB(Class class1, AABB axisalignedbb, List list) {
        int i = MathHelper.floor_double((axisalignedbb.minY - 2.0) / 16.0);
        int j = MathHelper.floor_double((axisalignedbb.maxY + 2.0) / 16.0);
        if (i < 0) {
            i = 0;
        }
        if (j >= this.entities.length) {
            j = this.entities.length - 1;
        }
        for (int k = i; k <= j; ++k) {
            List<Entity> list1 = this.entities[k];
            for (int l = 0; l < list1.size(); ++l) {
                Entity entity = list1.get(l);
                if (!class1.isAssignableFrom(entity.getClass()) || !entity.bb.intersectsWith(axisalignedbb)) continue;
                list.add(entity);
            }
        }
    }

    public boolean needsSaving(boolean saveImmediately) {
        if (this.neverSave) {
            return false;
        }
        if (saveImmediately ? this.hasEntities && this.worldObj.getWorldTime() != this.lastSaveTime : this.hasEntities && this.worldObj.getWorldTime() >= this.lastSaveTime + 600L) {
            return true;
        }
        return this.isModified;
    }

    public int setChunkData(byte[] abyte0, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, int startIndex) {
        ByteBuffer bb = ByteBuffer.allocate(this.blocks.length * 2);
        bb.asShortBuffer().put(this.blocks);
        if (abyte0.length > 65536) {
            this.receivedFromServer = true;
        }
        for (int cX = minX; cX < maxX; ++cX) {
            for (int cZ = minZ; cZ < maxZ; ++cZ) {
                int cIndex = cX << this.heightBits + 4 | cZ << this.heightBits | minY;
                int cY = maxY - minY;
                System.arraycopy(abyte0, startIndex, bb.array(), cIndex * 2, cY * 2);
                startIndex += cY * 2;
            }
        }
        ShortBuffer.wrap(this.blocks).put(bb.asShortBuffer());
        this.generateHeightMap();
        for (int i2 = minX; i2 < maxX; ++i2) {
            for (int i3 = minZ; i3 < maxZ; ++i3) {
                int i4 = i2 << this.heightBits + 4 | i3 << this.heightBits | minY;
                int i5 = maxY - minY;
                System.arraycopy(abyte0, startIndex, this.data.data, i4, i5);
                startIndex += i5;
            }
        }
        for (int j2 = minX; j2 < maxX; ++j2) {
            for (int j3 = minZ; j3 < maxZ; ++j3) {
                int j4 = (j2 << this.heightBits + 4 | j3 << this.heightBits | minY) >> 1;
                int j5 = (maxY - minY) / 2;
                System.arraycopy(abyte0, startIndex, this.blocklightMap.data, j4, j5);
                startIndex += j5;
            }
        }
        for (int k2 = minX; k2 < maxX; ++k2) {
            for (int k3 = minZ; k3 < maxZ; ++k3) {
                int k4 = (k2 << this.heightBits + 4 | k3 << this.heightBits | minY) >> 1;
                int k5 = (maxY - minY) / 2;
                System.arraycopy(abyte0, startIndex, this.skylightMap.data, k4, k5);
                startIndex += k5;
            }
        }
        return startIndex;
    }

    public int getChunkData(byte[] abyte0, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, int startIndex) {
        int width = maxX - minX;
        int height = maxY - minY;
        int length = maxZ - minZ;
        ByteBuffer bb = ByteBuffer.allocate(this.blocks.length * 2);
        bb.asShortBuffer().put(this.blocks);
        if (width * height * length == this.blocks.length) {
            System.arraycopy(bb.array(), 0, abyte0, startIndex, this.blocks.length * 2);
            System.arraycopy(this.data.data, 0, abyte0, startIndex += this.blocks.length * 2, this.data.data.length);
            System.arraycopy(this.blocklightMap.data, 0, abyte0, startIndex += this.data.data.length, this.blocklightMap.data.length);
            System.arraycopy(this.skylightMap.data, 0, abyte0, startIndex += this.blocklightMap.data.length, this.skylightMap.data.length);
            return startIndex += this.skylightMap.data.length;
        }
        for (int cX = minX; cX < maxX; ++cX) {
            for (int cZ = minZ; cZ < maxZ; ++cZ) {
                int cIndex = cX << this.heightBits + 4 | cZ << this.heightBits | minY;
                System.arraycopy(bb.array(), cIndex * 2, abyte0, startIndex, height * 2);
                startIndex += height * 2;
            }
        }
        for (int l2 = minX; l2 < maxX; ++l2) {
            for (int l3 = minZ; l3 < maxZ; ++l3) {
                int l4 = l2 << this.heightBits + 4 | l3 << this.heightBits | minY;
                System.arraycopy(this.data.data, l4, abyte0, startIndex, height);
                startIndex += height;
            }
        }
        for (int i3 = minX; i3 < maxX; ++i3) {
            for (int i4 = minZ; i4 < maxZ; ++i4) {
                int i5 = (i3 << this.heightBits + 4 | i4 << this.heightBits | minY) >> 1;
                int i6 = height / 2;
                System.arraycopy(this.blocklightMap.data, i5, abyte0, startIndex, i6);
                startIndex += i6;
            }
        }
        for (int j3 = minX; j3 < maxX; ++j3) {
            for (int j4 = minZ; j4 < maxZ; ++j4) {
                int j5 = (j3 << this.heightBits + 4 | j4 << this.heightBits | minY) >> 1;
                int j6 = height / 2;
                System.arraycopy(this.skylightMap.data, j5, abyte0, startIndex, j6);
                startIndex += j6;
            }
        }
        return startIndex;
    }

    public Random getChunkRandom(long l) {
        return new Random(this.worldObj.getRandomSeed() + (long)(this.xPosition * this.xPosition * 4987142) + (long)(this.xPosition * 5947611) + (long)(this.zPosition * this.zPosition) * 4392871L + (long)(this.zPosition * 389711) ^ l);
    }

    public boolean isChunkEmpty() {
        return false;
    }

    public void fixMissingBlocks() {
        MissingBlockFixer.fixMissingBlocks(this.blocks);
    }
}

