/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.chunk;

public class ChunkCoordIntPair {
    public final int xPos;
    public final int zPos;

    public ChunkCoordIntPair(int x, int z) {
        this.xPos = x;
        this.zPos = z;
    }

    public static int toInt(int x, int z) {
        return (x >= 0 ? 0 : Integer.MIN_VALUE) | (x & 0x3FFF) << 16 | (z >= 0 ? 0 : 32768) | z & 0x3FFF;
    }

    public int hashCode() {
        return ChunkCoordIntPair.toInt(this.xPos, this.zPos);
    }

    public boolean equals(Object obj) {
        if (obj instanceof ChunkCoordIntPair) {
            ChunkCoordIntPair otherPair = (ChunkCoordIntPair)obj;
            return otherPair.xPos == this.xPos && otherPair.zPos == this.zPos;
        }
        return false;
    }
}

