/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.chunk;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.enums.LightLayer;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;
import net.minecraft.core.world.chunk.Chunk;

public class EmptyChunk
extends Chunk {
    public EmptyChunk(World world, int i, int j) {
        super(world, i, j);
        this.neverSave = true;
    }

    public EmptyChunk(World world, short[] ashort0, int i, int j) {
        super(world, ashort0, i, j);
        this.neverSave = true;
    }

    @Override
    public boolean isAtLocation(int x, int z) {
        return x == this.xPosition && z == this.zPosition;
    }

    @Override
    public int getHeightValue(int x, int z) {
        return 0;
    }

    @Override
    public void generateHeightMap() {
    }

    @Override
    public void generateMaps() {
    }

    @Override
    public int getBlockID(int i, int j, int k) {
        return 0;
    }

    @Override
    public boolean setBlockIDWithMetadata(int x, int y, int z, int id, int meta) {
        return true;
    }

    @Override
    public boolean setBlockID(int x, int y, int z, int id) {
        return true;
    }

    @Override
    public int getBlockMetadata(int i, int j, int k) {
        return 0;
    }

    @Override
    public void setBlockMetadata(int i, int j, int k, int l) {
    }

    @Override
    public int getSavedLightValue(LightLayer lightType, int i, int j, int k) {
        return 0;
    }

    @Override
    public void setLightValue(LightLayer layer, int x, int y, int z, int value) {
    }

    @Override
    public int getBlockLightValue(int i, int j, int k, int l) {
        return 0;
    }

    @Override
    public void addEntity(Entity entity) {
    }

    @Override
    public void removeEntity(Entity entity) {
    }

    @Override
    public void removeEntityAtIndex(Entity entity, int i) {
    }

    @Override
    public boolean canBlockSeeTheSky(int i, int j, int k) {
        return false;
    }

    @Override
    public TileEntity getChunkBlockTileEntity(int x, int y, int z) {
        return null;
    }

    @Override
    public void addTileEntity(TileEntity tileentity) {
    }

    @Override
    public void setChunkBlockTileEntity(int i, int j, int k, TileEntity tileentity) {
    }

    @Override
    public void removeChunkBlockTileEntity(int i, int j, int k) {
    }

    @Override
    public void onChunkLoad() {
    }

    @Override
    public void onChunkUnload() {
    }

    @Override
    public void setChunkModified() {
    }

    @Override
    public void getEntitiesWithinAABBForEntity(Entity entity, AABB axisalignedbb, List list) {
    }

    @Override
    public void getEntitiesOfTypeWithinAAAB(Class class1, AABB axisalignedbb, List list) {
    }

    @Override
    public boolean needsSaving(boolean saveImmediately) {
        return false;
    }

    @Override
    public int setChunkData(byte[] abyte0, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, int startIndex) {
        int dx = maxX - minX;
        int dy = maxY - minY;
        int dz = maxZ - minZ;
        int chunkSizeBlocks = dx * dy * dz;
        return chunkSizeBlocks * 2 + chunkSizeBlocks + chunkSizeBlocks / 2 * 2;
    }

    @Override
    public int getChunkData(byte[] abyte0, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, int startIndex) {
        int dx = maxX - minX;
        int dy = maxY - minY;
        int dz = maxZ - minZ;
        int chunkSizeBlocks = dx * dy * dz;
        int dataSize = chunkSizeBlocks * 2 + chunkSizeBlocks + chunkSizeBlocks / 2 * 2;
        Arrays.fill(abyte0, startIndex, startIndex + dataSize, (byte)0);
        return dataSize;
    }

    @Override
    public Random getChunkRandom(long l) {
        return new Random(this.worldObj.getRandomSeed() + (long)(this.xPosition * this.xPosition * 4987142) + (long)(this.xPosition * 5947611) + (long)(this.zPosition * this.zPosition) * 4392871L + (long)(this.zPosition * 389711) ^ l);
    }

    @Override
    public boolean isChunkEmpty() {
        return true;
    }
}

