/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.save.mcregion;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.world.save.mcregion.RegionFile;

public class RegionFileCache {
    private static final Map<File, Reference<RegionFile>> cache = new HashMap<File, Reference<RegionFile>>();

    private RegionFileCache() {
    }

    public static synchronized RegionFile loadRegionFileFromCoords(File worldDir, int x, int z) {
        RegionFile regionfile;
        File regionDir = new File(worldDir, "region");
        File regionFile = new File(regionDir, "r." + (x >> 5) + "." + (z >> 5) + ".mcr");
        Reference<RegionFile> reference = cache.get(regionFile);
        if (reference != null && (regionfile = reference.get()) != null) {
            return regionfile;
        }
        if (!regionDir.exists()) {
            regionDir.mkdirs();
        }
        if (cache.size() >= 256) {
            RegionFileCache.flushCache();
        }
        RegionFile loadedRegion = new RegionFile(regionFile);
        cache.put(regionFile, new SoftReference<RegionFile>(loadedRegion));
        return loadedRegion;
    }

    public static synchronized void flushCache() {
        for (Reference<RegionFile> reference : cache.values()) {
            try {
                RegionFile regionfile = reference.get();
                if (regionfile == null) continue;
                regionfile.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        cache.clear();
    }

    public static int getSizeDelta(File worldDir, int x, int z) {
        RegionFile regionfile = RegionFileCache.loadRegionFileFromCoords(worldDir, x, z);
        return regionfile.getSizeDeltaBytes();
    }

    public static DataInputStream getChunkInputStream(File worldDir, int x, int z) {
        RegionFile regionFile = RegionFileCache.loadRegionFileFromCoords(worldDir, x, z);
        return regionFile.getChunkDataInputStream(x & 0x1F, z & 0x1F);
    }

    public static DataOutputStream getChunkOutputStream(File worldDir, int x, int z) {
        RegionFile regionfile = RegionFileCache.loadRegionFileFromCoords(worldDir, x, z);
        return regionfile.getChunkDataOutputStream(x & 0x1F, z & 0x1F);
    }
}

