/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.saveddata.maps;

import com.mojang.nbt.CompoundTag;

public class MapWaypoint {
    public byte mapCoordX;
    public byte mapCoordZ;
    public int xPos;
    public int yPos;
    public int zPos;
    public byte[] colors = new byte[9];

    public MapWaypoint(byte mapCoordX, byte mapCoordZ, int x, int y, int z, byte[] colors) {
        this.mapCoordX = mapCoordX;
        this.mapCoordZ = mapCoordZ;
        this.xPos = x;
        this.yPos = y;
        this.zPos = z;
        for (int i = 0; i < this.colors.length; ++i) {
            this.colors[i] = i < colors.length ? colors[i] : (byte)0;
        }
    }

    public MapWaypoint(CompoundTag nbt) {
        this.readFromNBT(nbt);
    }

    public CompoundTag writeToNBT(CompoundTag tag) {
        tag.putByte("MapCoordX", this.mapCoordX);
        tag.putByte("MapCoordZ", this.mapCoordZ);
        tag.putInt("xPos", this.xPos);
        tag.putInt("yPos", this.yPos);
        tag.putInt("zPos", this.zPos);
        tag.putByteArray("Colors", this.colors);
        return tag;
    }

    public void readFromNBT(CompoundTag tag) {
        this.mapCoordX = tag.getByte("MapCoordX");
        this.mapCoordZ = tag.getByte("MapCoordZ");
        this.xPos = tag.getInteger("xPos");
        this.yPos = tag.getInteger("yPos");
        this.zPos = tag.getInteger("zPos");
        this.colors = tag.getByteArray("Colors");
    }
}

