/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.season;

import java.util.Properties;

public class SeasonColorProperties {
    public ColorMethod grassMethod;
    public float grassR;
    public ValueMethod grassRMethod;
    public float grassG;
    public ValueMethod grassGMethod;
    public float grassB;
    public ValueMethod grassBMethod;
    public ColorMethod foliageMethod;
    public float foliageR;
    public ValueMethod foliageRMethod;
    public float foliageG;
    public ValueMethod foliageGMethod;
    public float foliageB;
    public ValueMethod foliageBMethod;

    public SeasonColorProperties(String name, Properties prop) {
        String sGrassMethod = prop.getProperty("season." + name + ".grass.method", "none");
        String sGrassR = prop.getProperty("season." + name + ".grass.r", "*1.0");
        String sGrassG = prop.getProperty("season." + name + ".grass.g", "*1.0");
        String sGrassB = prop.getProperty("season." + name + ".grass.b", "*1.0");
        String sFoliageMethod = prop.getProperty("season." + name + ".foliage.method", "none");
        String sFoliageR = prop.getProperty("season." + name + ".foliage.r", "*1.0");
        String sFoliageG = prop.getProperty("season." + name + ".foliage.g", "*1.0");
        String sFoliageB = prop.getProperty("season." + name + ".foliage.b", "*1.0");
        switch (sGrassMethod) {
            case "modify": {
                this.grassMethod = ColorMethod.modify;
                break;
            }
            case "desaturate": {
                this.grassMethod = ColorMethod.desaturate;
                break;
            }
            default: {
                this.grassMethod = ColorMethod.none;
            }
        }
        if (sGrassR.startsWith("*")) {
            this.grassRMethod = ValueMethod.mult;
            sGrassR = sGrassR.substring(1);
        } else if (sGrassR.startsWith("+")) {
            this.grassRMethod = ValueMethod.add;
            sGrassR = sGrassR.substring(1);
        } else {
            this.grassRMethod = ValueMethod.flat;
        }
        try {
            this.grassR = Float.parseFloat(sGrassR);
        }
        catch (NumberFormatException e) {
            this.grassRMethod = ValueMethod.mult;
            this.grassR = 1.0f;
        }
        if (sGrassG.startsWith("*")) {
            this.grassGMethod = ValueMethod.mult;
            sGrassG = sGrassG.substring(1);
        } else if (sGrassG.startsWith("+")) {
            this.grassGMethod = ValueMethod.add;
            sGrassG = sGrassG.substring(1);
        } else {
            this.grassGMethod = ValueMethod.flat;
        }
        try {
            this.grassG = Float.parseFloat(sGrassG);
        }
        catch (NumberFormatException e) {
            this.grassGMethod = ValueMethod.mult;
            this.grassG = 1.0f;
        }
        if (sGrassB.startsWith("*")) {
            this.grassBMethod = ValueMethod.mult;
            sGrassB = sGrassB.substring(1);
        } else if (sGrassB.startsWith("+")) {
            this.grassBMethod = ValueMethod.add;
            sGrassB = sGrassB.substring(1);
        } else {
            this.grassBMethod = ValueMethod.flat;
        }
        try {
            this.grassB = Float.parseFloat(sGrassB);
        }
        catch (NumberFormatException e) {
            this.grassBMethod = ValueMethod.mult;
            this.grassB = 1.0f;
        }
        switch (sFoliageMethod) {
            case "modify": {
                this.foliageMethod = ColorMethod.modify;
                break;
            }
            case "desaturate": {
                this.foliageMethod = ColorMethod.desaturate;
                break;
            }
            default: {
                this.foliageMethod = ColorMethod.none;
            }
        }
        if (sFoliageR.startsWith("*")) {
            this.foliageRMethod = ValueMethod.mult;
            sFoliageR = sFoliageR.substring(1);
        } else if (sFoliageR.startsWith("+")) {
            this.foliageRMethod = ValueMethod.add;
            sFoliageR = sFoliageR.substring(1);
        } else {
            this.foliageRMethod = ValueMethod.flat;
        }
        try {
            this.foliageR = Float.parseFloat(sFoliageR);
        }
        catch (NumberFormatException e) {
            this.foliageRMethod = ValueMethod.mult;
            this.foliageR = 1.0f;
        }
        if (sFoliageG.startsWith("*")) {
            this.foliageGMethod = ValueMethod.mult;
            sFoliageG = sFoliageG.substring(1);
        } else if (sFoliageG.startsWith("+")) {
            this.foliageGMethod = ValueMethod.add;
            sFoliageG = sFoliageG.substring(1);
        } else {
            this.foliageGMethod = ValueMethod.flat;
        }
        try {
            this.foliageG = Float.parseFloat(sFoliageG);
        }
        catch (NumberFormatException e) {
            this.foliageGMethod = ValueMethod.mult;
            this.foliageG = 1.0f;
        }
        if (sFoliageB.startsWith("*")) {
            this.foliageBMethod = ValueMethod.mult;
            sFoliageB = sFoliageB.substring(1);
        } else if (sFoliageB.startsWith("+")) {
            this.foliageBMethod = ValueMethod.add;
            sFoliageB = sFoliageB.substring(1);
        } else {
            this.foliageBMethod = ValueMethod.flat;
        }
        try {
            this.foliageB = Float.parseFloat(sFoliageB);
        }
        catch (NumberFormatException e) {
            this.foliageBMethod = ValueMethod.mult;
            this.foliageB = 1.0f;
        }
    }

    static enum ColorMethod {
        none,
        modify,
        desaturate;

    }

    static enum ValueMethod {
        flat,
        mult,
        add;

    }
}

