/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.type;

import net.minecraft.core.world.World;
import net.minecraft.core.world.biome.provider.BiomeProvider;
import net.minecraft.core.world.biome.provider.BiomeProviderOverworld;
import net.minecraft.core.world.config.season.SeasonConfig;
import net.minecraft.core.world.season.Seasons;
import net.minecraft.core.world.type.WorldTypeOverworld;
import net.minecraft.core.world.weather.Weather;
import net.minecraft.core.world.wind.WindManagerGeneric;

public class WorldTypeOverworldParadise
extends WorldTypeOverworld {
    public WorldTypeOverworldParadise(String languageKey) {
        super(languageKey, Weather.overworldClear, new WindManagerGeneric(), SeasonConfig.builder().withSingleSeason(Seasons.OVERWORLD_SPRING).build());
    }

    @Override
    public BiomeProvider createBiomeProvider(World world) {
        return new BiomeProviderOverworld(world.getRandomSeed(), this);
    }

    @Override
    public int getMinY() {
        return 0;
    }

    @Override
    public int getMaxY() {
        return 127;
    }

    @Override
    public int getOceanY() {
        return 64;
    }

    @Override
    public float getCelestialAngle(World world, long tick, float partialTick) {
        return 0.0f;
    }

    @Override
    public float getCloudHeight() {
        return 108.0f;
    }
}

