/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.weather;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLayerSnow;
import net.minecraft.core.enums.LightLayer;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.world.World;
import net.minecraft.core.world.biome.Biome;
import net.minecraft.core.world.biome.Biomes;
import net.minecraft.core.world.chunk.Chunk;
import net.minecraft.core.world.weather.Weather;

public class WeatherSnow
extends Weather {
    public WeatherSnow(int id) {
        super(id);
    }

    @Override
    public void doChunkLoadEffect(World world, Chunk chunk) {
        for (int x = 0; x < 16; ++x) {
            block1: for (int z = 0; z < 16; ++z) {
                int y = chunk.getHeightValue(x, z);
                int worldX = chunk.xPosition * 16 + x;
                int worldZ = chunk.zPosition * 16 + z;
                int blockId = chunk.getBlockID(x, y, z);
                int blockIdBelow = chunk.getBlockID(x, y - 1, z);
                Biome biome = world.getBlockBiome(worldX, y, worldZ);
                for (int i = 0; i < biome.blockedWeathers.length; ++i) {
                    if (biome.blockedWeathers[i] == this) continue block1;
                }
                if (!(world.weatherPower > 0.6f) || y < 0 || y >= world.getHeightBlocks() || chunk.getSavedLightValue(LightLayer.Block, x, y, z) >= 10 || blockId != 0 || blockIdBelow == 0 || !Block.layerSnow.canPlaceBlockAt(world, worldX, y, worldZ) || blockIdBelow == Block.ice.id) continue;
                chunk.setBlockID(x, y, z, Block.layerSnow.id);
            }
        }
    }

    @Override
    public void doEnvironmentUpdate(World world, Random rand, int x, int z) {
        block4: {
            int i;
            int blockIdBelow;
            int y;
            block6: {
                Biome biome;
                int blockId;
                boolean snow;
                block5: {
                    int probability = (int)(64.0f * (1.0f / world.weatherPower));
                    if (world.seasonManager.getCurrentSeason() != null && world.seasonManager.getCurrentSeason().hasDeeperSnow) {
                        probability /= 2;
                    }
                    snow = rand.nextInt(probability) == 0;
                    y = world.getHeightValue(x, z);
                    blockId = world.getBlockId(x, y, z);
                    blockIdBelow = world.getBlockId(x, y - 1, z);
                    biome = world.getBlockBiome(x, y, z);
                    for (i = 0; i < biome.blockedWeathers.length; ++i) {
                        if (biome.blockedWeathers[i] != this) continue;
                        return;
                    }
                    if (!(world.weatherPower > 0.6f) || y < 0 || y >= world.getHeightBlocks() || world.getSavedLightValue(LightLayer.Block, x, y, z) >= 10) break block4;
                    if (blockId != 0 || blockIdBelow == 0 || !Block.layerSnow.canPlaceBlockAt(world, x, y, z) || blockIdBelow == Block.ice.id) break block5;
                    if (!snow) break block4;
                    world.setBlockWithNotify(x, y, z, Block.layerSnow.id);
                    break block4;
                }
                if (!(world.weatherPower > 0.5f) || blockId != Block.layerSnow.id || world.seasonManager.getCurrentSeason() == null || !world.seasonManager.getCurrentSeason().hasDeeperSnow && biome != Biomes.OVERWORLD_GLACIER) break block6;
                if (!snow) break block4;
                ((BlockLayerSnow)Block.layerSnow).accumulate(world, x, y, z);
                break block4;
            }
            if (blockIdBelow == Block.fluidWaterStill.id && world.getBlockMetadata(x, y - 1, z) == 0 && rand.nextFloat() < world.weatherPower * world.weatherIntensity) {
                for (i = 0; i < 4; ++i) {
                    Direction direction = Direction.horizontalDirections[i];
                    Block block = world.getBlock(x + direction.getOffsetX(), y - 1, z + direction.getOffsetZ());
                    if (block != Block.ice && (block == null || !block.isOpaqueCube())) continue;
                    world.setBlockWithNotify(x, y - 1, z, Block.ice.id);
                    break;
                }
            }
        }
    }
}

