/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.entity.fx;

import net.minecraft.client.entity.fx.EntityFX;
import net.minecraft.client.render.Tessellator;
import net.minecraft.core.entity.animal.EntityFireflyCluster;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;

public class EntityFireflyFX
extends EntityFX {
    float field_671_a;
    float sinTimer = 0.0f;
    boolean isReversed = false;
    float midR = 0.0f;
    float midG = 0.0f;
    float midB = 0.0f;
    final float minR = 0.3764706f;
    final float minG = 0.21176471f;
    final float minB = 0.0f;
    float maxR = 0.9411765f;
    float maxG = 1.0f;
    float maxB = 0.6784314f;
    float oR;
    float oG;
    float oB;

    public EntityFireflyFX(World world, double x, double y, double z, double motionX, double motionY, double motionZ, int type) {
        this(world, x, y, z, motionX, motionY, motionZ, 1.0f, type);
    }

    public EntityFireflyFX(World world, double x, double y, double z, double motionX, double motionY, double motionZ, float scale, int type) {
        super(world, x, y, z, 0.0, 0.0, 0.0);
        this.xd = 0.01;
        this.yd = 0.01;
        this.zd = 0.01;
        this.xd += motionX;
        this.yd += motionY;
        this.zd += motionZ;
        this.setColour(type);
        this.field_671_a = this.particleScale = 2.0f;
        this.particleMaxAge = (int)(24.0 + (double)this.random.nextInt(6));
        this.particleMaxAge = (int)((float)this.particleMaxAge * scale);
        this.noPhysics = false;
        this.particleTextureIndex = 112;
        if (this.random.nextInt(2) == 0) {
            this.isReversed = true;
        }
        this.oR = this.random.nextFloat() * 0.06f - 0.03f;
        this.oG = this.random.nextFloat() * 0.06f - 0.03f;
        this.oB = this.random.nextFloat() * 0.06f - 0.03f;
    }

    private void setColour(int type) {
        float[] color = EntityFireflyCluster.FireflyColor.fireFlyColors.get(type).getMidColor();
        this.midR = color[0];
        this.midG = color[1];
        this.midB = color[2];
        this.particleRed = this.midR;
        this.particleGreen = this.midG;
        this.particleBlue = this.midB;
        this.maxR = MathHelper.clamp(this.midR + 0.25f, 0.0f, 1.0f);
        this.maxG = MathHelper.clamp(this.midG + 0.25f, 0.0f, 1.0f);
        this.maxB = MathHelper.clamp(this.midB + 0.25f, 0.0f, 1.0f);
    }

    public void setParticleAge(int age) {
        this.particleAge = age;
    }

    @Override
    public float getBrightness(float partialTick) {
        float internalBrightness = this.getInternalBrightness(partialTick);
        float worldBrightness = super.getBrightness(partialTick);
        return Math.max(internalBrightness, worldBrightness);
    }

    public float getInternalBrightness(float partialTick) {
        float b = (float)(Math.sin((float)this.particleAge * 0.25f) + 1.0) / 2.0f;
        return MathHelper.clamp(b, 0.0f, 1.0f);
    }

    @Override
    public void renderParticle(Tessellator t, float partialTick, float rotationX, float rotationXZ, float rotationZ, float rotationYZ, float rotationXY) {
        float b = this.getInternalBrightness(partialTick);
        if (b < 0.5f) {
            this.particleRed = MathHelper.lerp(0.3764706f, this.midR, b * 2.0f);
            this.particleGreen = MathHelper.lerp(0.21176471f, this.midG, b * 2.0f);
            this.particleBlue = MathHelper.lerp(0.0f, this.midB, b * 2.0f);
        } else {
            this.particleRed = MathHelper.lerp(this.midR, this.maxR, (b - 0.5f) * 2.0f);
            this.particleGreen = MathHelper.lerp(this.midG, this.maxG, (b - 0.5f) * 2.0f);
            this.particleBlue = MathHelper.lerp(this.midB, this.maxB, (b - 0.5f) * 2.0f);
        }
        this.particleRed += this.oR;
        this.particleGreen += this.oG;
        this.particleBlue += this.oB;
        super.renderParticle(t, partialTick, rotationX, rotationXZ, rotationZ, rotationYZ, rotationXY);
    }

    public void renderParticleInGUI(Tessellator t, float partialTick) {
        float b = this.getInternalBrightness(partialTick);
        if (b < 0.5f) {
            this.particleRed = MathHelper.lerp(0.3764706f, this.midR, b * 2.0f);
            this.particleGreen = MathHelper.lerp(0.21176471f, this.midG, b * 2.0f);
            this.particleBlue = MathHelper.lerp(0.0f, this.midB, b * 2.0f);
        } else {
            this.particleRed = MathHelper.lerp(this.midR, this.maxR, (b - 0.5f) * 2.0f);
            this.particleGreen = MathHelper.lerp(this.midG, this.maxG, (b - 0.5f) * 2.0f);
            this.particleBlue = MathHelper.lerp(this.midB, this.maxB, (b - 0.5f) * 2.0f);
        }
        this.particleRed += this.oR;
        this.particleGreen += this.oG;
        this.particleBlue += this.oB;
        float texMinU = (float)(this.particleTextureIndex % 16) / 16.0f;
        float texMaxU = texMinU + 0.0624375f;
        float texMinV = (float)(this.particleTextureIndex / 16) / 16.0f;
        float texMaxV = texMinV + 0.0624375f;
        float scale = 0.1f * this.particleScale;
        float posX = (float)(this.xo + (this.x - this.xo) * (double)partialTick);
        float posY = (float)(this.yo + (this.y - this.yo) * (double)partialTick);
        float brightness = this.getBrightness(partialTick);
        t.setColorOpaque_F(this.particleRed * brightness, this.particleGreen * brightness, this.particleBlue * brightness);
        t.addVertexWithUV(posX + scale, posY - scale, 0.0, texMaxU, texMaxV);
        t.addVertexWithUV(posX + scale, posY + scale, 0.0, texMaxU, texMinV);
        t.addVertexWithUV(posX - scale, posY + scale, 0.0, texMinU, texMinV);
        t.addVertexWithUV(posX - scale, posY - scale, 0.0, texMinU, texMaxV);
    }

    public void tickGUI() {
        this.sinTimer += 1.0f;
        if (this.sinTimer > 100.0f) {
            this.sinTimer = 0.0f;
        }
        if (this.particleAge++ >= this.particleMaxAge && this.getInternalBrightness(1.0f) < 0.01f) {
            this.remove();
        }
        this.xo = this.x;
        this.yo = this.y;
        this.xd = MathHelper.sin(this.sinTimer * 0.15f) / 60.0f;
        this.yd = MathHelper.cos(this.sinTimer * 0.15f) / 60.0f;
        if (this.isReversed) {
            this.xd = -this.xd;
            this.yd = -this.yd;
        }
        this.move(this.xd, this.yd, 0.0);
    }

    @Override
    public void tick() {
        this.sinTimer += 1.0f;
        if (this.sinTimer > 100.0f) {
            this.sinTimer = 0.0f;
        }
        if (this.particleAge++ >= this.particleMaxAge && this.getInternalBrightness(1.0f) < 0.01f) {
            this.remove();
        }
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        this.xd = MathHelper.sin(this.sinTimer * 0.15f) / 60.0f;
        this.zd = MathHelper.cos(this.sinTimer * 0.15f) / 60.0f;
        if (this.isReversed) {
            this.xd = -this.xd;
            this.yd = -this.yd;
            this.zd = -this.zd;
        }
        this.move(this.xd, this.yd, this.zd);
    }
}

