/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.entity;

import net.minecraft.client.Minecraft;
import net.minecraft.client.render.TileEntityRenderDispatcher;
import net.minecraft.client.render.entity.EntityRenderer;
import net.minecraft.client.render.model.ModelBase;
import net.minecraft.client.render.model.ModelBoat;
import net.minecraft.client.render.tileentity.TileEntityRendererFlag;
import net.minecraft.core.entity.vehicle.EntityBoat;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;
import net.minecraft.core.world.wind.WindManager;
import org.lwjgl.opengl.GL11;

public class BoatRenderer
extends EntityRenderer<EntityBoat> {
    protected ModelBase modelBoat;
    private TileEntityRendererFlag flagRenderer = new TileEntityRendererFlag();

    public BoatRenderer() {
        this.shadowSize = 0.5f;
        this.modelBoat = new ModelBoat();
        this.flagRenderer.setRenderDispatcher(TileEntityRenderDispatcher.instance);
    }

    public void func_157_a(EntityBoat entity, double x, double y, double z, float yaw, float partialTick) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        GL11.glRotatef((float)(180.0f - yaw), (float)0.0f, (float)1.0f, (float)0.0f);
        float f2 = (float)entity.boatTimeSinceHit - partialTick;
        float f3 = (float)entity.boatCurrentDamage - partialTick;
        if (f3 < 0.0f) {
            f3 = 0.0f;
        }
        if (f2 > 0.0f) {
            GL11.glRotatef((float)(MathHelper.sin(f2) * f2 * f3 / 10.0f * (float)entity.boatRockDirection), (float)1.0f, (float)0.0f, (float)0.0f);
        }
        if (entity.tileEntityFlag != null) {
            World theWorld = Minecraft.getMinecraft((Object)this).theWorld;
            WindManager theWind = theWorld.getWorldType().getWindManager();
            float windAngle = theWind.getWindDirection(theWorld, (float)x, (float)y, (float)z) * 360.0f + (180.0f - yaw);
            float boatAngle = 180.0f;
            float boatSpeed = MathHelper.sqrt_float((float)(entity.xd * entity.xd + entity.zd * entity.zd));
            float angle = MathHelper.lerp(windAngle, boatAngle, (float)MathHelper.clamp((double)boatSpeed, 0.0, 0.25) * 4.0f);
            this.flagRenderer.doRender(entity.tileEntityFlag, -1.19, 0.187, -0.5, partialTick, false, angle);
        }
        this.loadTexture("/terrain.png");
        float f4 = 0.75f;
        GL11.glScalef((float)f4, (float)f4, (float)f4);
        GL11.glScalef((float)(1.0f / f4), (float)(1.0f / f4), (float)(1.0f / f4));
        this.loadTexture("/item/boat.png");
        GL11.glScalef((float)-1.0f, (float)-1.0f, (float)1.0f);
        this.modelBoat.render(0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
        GL11.glPopMatrix();
    }

    @Override
    public void doRender(EntityBoat entity, double x, double y, double z, float yaw, float partialTick) {
        this.func_157_a(entity, x, y, z, yaw, partialTick);
    }
}

